/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.association;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.association.AssociationModel;
import org.dmg.pmml.association.AssociationRule;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.ItemRef;
import org.dmg.pmml.association.Itemset;
import org.dmg.pmml.association.PMMLAttributes;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.MissingFieldValueException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.association.Association;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.MisplacedElementException;
import org.jpmml.model.MissingAttributeException;

public class AssociationModelEvaluator
extends ModelEvaluator<AssociationModel>
implements HasGroupFields,
HasEntityRegistry<AssociationRule> {
    private BiMap<String, AssociationRule> entityRegistry = ImmutableBiMap.of();
    private Map<String, Item> items = Collections.emptyMap();
    private Map<String, Itemset> itemsets = Collections.emptyMap();
    private List<InputField> groupInputFields = null;
    private List<ItemValue> itemValues = null;
    private static final FieldValue STRING_TRUE = FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, "T");
    private static final FieldValue STRING_FALSE = FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, "F");
    private static final FieldValue BOOLEAN_TRUE = FieldValues.CATEGORICAL_BOOLEAN_TRUE;
    private static final FieldValue BOOLEAN_FALSE = FieldValues.CATEGORICAL_BOOLEAN_FALSE;

    private AssociationModelEvaluator() {
    }

    public AssociationModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, AssociationModel.class));
    }

    public AssociationModelEvaluator(PMML pmml, AssociationModel associationModel) {
        super(pmml, associationModel);
        Targets targets = associationModel.getTargets();
        if (targets != null) {
            throw new MisplacedElementException((PMMLObject)targets);
        }
        if (associationModel.hasAssociationRules()) {
            this.entityRegistry = ImmutableBiMap.copyOf(EntityUtil.buildBiMap(associationModel.getAssociationRules()));
        }
        if (associationModel.hasItems()) {
            this.items = ImmutableMap.copyOf(IndexableUtil.buildMap(associationModel.getItems()));
        }
        if (associationModel.hasItemsets()) {
            this.itemsets = ImmutableMap.copyOf(IndexableUtil.buildMap(associationModel.getItemsets()));
        }
    }

    @Override
    public String getSummary() {
        return "Association rules";
    }

    @Override
    public List<InputField> getGroupFields() {
        if (this.groupInputFields == null) {
            List<InputField> groupInputFields = this.filterInputFields(this.createInputFields(MiningField.UsageType.GROUP));
            this.groupInputFields = ImmutableList.copyOf(groupInputFields);
        }
        return this.groupInputFields;
    }

    @Override
    public Target getTarget(String name) {
        return null;
    }

    @Override
    public String getTargetName() {
        return Evaluator.DEFAULT_TARGET_NAME;
    }

    @Override
    public BiMap<String, AssociationRule> getEntityRegistry() {
        return this.entityRegistry;
    }

    @Override
    protected List<TargetField> createTargetFields() {
        List<TargetField> targetFields = super.createTargetFields();
        if (!targetFields.isEmpty()) {
            throw this.createMiningSchemaException("Expected 0 target fields, got " + targetFields.size() + " target fields");
        }
        return targetFields;
    }

    @Override
    protected <V extends Number> Map<String, Association> evaluateAssociationRules(ValueFactory<V> valueFactory, EvaluationContext context) {
        AssociationModel associationModel = (AssociationModel)this.getModel();
        Set<String> activeItems = this.getActiveItemIds(context);
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        List itemsets = associationModel.getItemsets();
        int max = itemsets.size();
        for (int i = 0; i < max; ++i) {
            Itemset itemset = (Itemset)itemsets.get(i);
            flags.put(itemset.requireId(), AssociationModelEvaluator.isSubset(activeItems, itemset));
        }
        List associationRules = associationModel.getAssociationRules();
        BitSet antecedentFlags = new BitSet(associationRules.size());
        BitSet consequentFlags = new BitSet(associationRules.size());
        int max2 = associationRules.size();
        for (int i = 0; i < max2; ++i) {
            AssociationRule associationRule = (AssociationRule)associationRules.get(i);
            String antecedent = associationRule.requireAntecedent();
            Boolean antecedentFlag = (Boolean)flags.get(antecedent);
            if (antecedentFlag == null) {
                throw new InvalidAttributeException((PMMLObject)associationRule, PMMLAttributes.ASSOCIATIONRULE_ANTECEDENT, (Object)antecedent);
            }
            antecedentFlags.set(i, antecedentFlag);
            String consequent = associationRule.requireConsequent();
            Boolean consequentFlag = (Boolean)flags.get(consequent);
            if (consequentFlag == null) {
                throw new InvalidAttributeException((PMMLObject)associationRule, PMMLAttributes.ASSOCIATIONRULE_CONSEQUENT, (Object)consequent);
            }
            consequentFlags.set(i, consequentFlag);
        }
        Association association = new Association(associationRules, antecedentFlags, consequentFlags){

            @Override
            public BiMap<String, AssociationRule> getEntityRegistry() {
                return AssociationModelEvaluator.this.getEntityRegistry();
            }

            @Override
            public Map<String, Item> getItems() {
                return AssociationModelEvaluator.this.getItems();
            }

            @Override
            public Map<String, Itemset> getItemsets() {
                return AssociationModelEvaluator.this.getItemsets();
            }
        };
        return Collections.singletonMap(this.getTargetName(), association);
    }

    Set<String> getActiveItemIds(EvaluationContext context) {
        List<InputField> activeFields = this.getActiveFields();
        List<InputField> groupFields = this.getGroupFields();
        HashSet<String> result = new HashSet<String>();
        HashMap explodedValues = null;
        List<ItemValue> itemValues = this.getItemValues();
        int max = itemValues.size();
        for (int i = 0; i < max; ++i) {
            ItemValue itemValue = itemValues.get(i);
            String id = itemValue.getId();
            String name = itemValue.getField();
            String category = itemValue.getCategory();
            FieldValue value = context.evaluate(name);
            if (groupFields.isEmpty()) {
                if (FieldValueUtil.isMissing(value)) continue;
                if (category == null) {
                    DataType dataType = value.getDataType();
                    switch (dataType) {
                        case STRING: {
                            if (STRING_TRUE.equalsValue(value)) {
                                result.add(id);
                                break;
                            }
                            if (STRING_FALSE.equalsValue(value)) break;
                        }
                        default: {
                            if (BOOLEAN_TRUE.equalsValue(value)) {
                                result.add(id);
                                break;
                            }
                            if (BOOLEAN_FALSE.equalsValue(value)) break;
                            throw new EvaluationException("Expected " + EvaluationException.formatValue(BOOLEAN_FALSE) + " or " + EvaluationException.formatValue(BOOLEAN_TRUE) + ", got " + EvaluationException.formatValue(value));
                        }
                    }
                    continue;
                }
                if (!value.equalsValue(category)) continue;
                result.add(id);
                continue;
            }
            if (groupFields.size() == 1) {
                HashSet<FieldValue> explodedValue;
                if (FieldValueUtil.isMissing(value)) {
                    throw new MissingFieldValueException(name);
                }
                if (explodedValues == null) {
                    explodedValues = new HashMap();
                }
                if ((explodedValue = (HashSet<FieldValue>)explodedValues.get(name)) == null) {
                    explodedValue = new HashSet<FieldValue>();
                    Collection<?> objects = value.asCollection();
                    for (Object object : objects) {
                        explodedValue.add(FieldValueUtil.create(value, object));
                    }
                }
                if (category == null) {
                    throw new IllegalStateException();
                }
                FieldValue categoryValue = FieldValueUtil.create(value, category);
                if (!explodedValue.contains(categoryValue)) continue;
                result.add(id);
                continue;
            }
            throw this.createMiningSchemaException("Expected 0 or 1 group field(s), got " + groupFields.size() + " group fields");
        }
        return result;
    }

    private Map<String, Item> getItems() {
        return this.items;
    }

    private Map<String, Itemset> getItemsets() {
        return this.itemsets;
    }

    private List<ItemValue> getItemValues() {
        if (this.itemValues == null) {
            this.itemValues = ImmutableList.copyOf(AssociationModelEvaluator.parseItemValues(this));
        }
        return this.itemValues;
    }

    private static boolean isSubset(Set<String> items, Itemset itemset) {
        boolean result = true;
        List itemRefs = itemset.getItemRefs();
        int max = itemRefs.size();
        for (int i = 0; i < max; ++i) {
            ItemRef itemRef = (ItemRef)itemRefs.get(i);
            if (result &= items.contains(itemRef.requireItemRef())) continue;
            return false;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<ItemValue> parseItemValues(AssociationModelEvaluator modelEvaluator) {
        AssociationModel associationModel = (AssociationModel)modelEvaluator.getModel();
        List<InputField> activeFields = modelEvaluator.getActiveFields();
        List<InputField> groupFields = modelEvaluator.getGroupFields();
        ArrayList<ItemValue> result = new ArrayList<ItemValue>();
        List items = associationModel.getItems();
        for (Item item : items) {
            String id = item.requireId();
            String value = item.requireValue();
            String fieldName = item.getField();
            String category = item.getCategory();
            if (fieldName == null) {
                if (groupFields.isEmpty()) {
                    if (activeFields.isEmpty()) {
                        throw modelEvaluator.createMiningSchemaException("Expected 1 or more active field(s), got " + activeFields.size() + " active fields");
                    }
                    fieldName = value;
                    category = null;
                    Field<?> field = modelEvaluator.resolveField(fieldName);
                    if (field == null) {
                        int index = value.indexOf(61);
                        if (index <= -1) throw new InvalidAttributeException((PMMLObject)item, PMMLAttributes.ITEM_VALUE, (Object)value);
                        fieldName = value.substring(0, index);
                        category = value.substring(index + 1);
                        field = modelEvaluator.resolveField(fieldName);
                        if (field == null) {
                            throw new InvalidAttributeException((PMMLObject)item, PMMLAttributes.ITEM_VALUE, (Object)value);
                        }
                    }
                } else {
                    if (groupFields.size() != 1) throw modelEvaluator.createMiningSchemaException("Expected 0 or 1 group field(s), got " + groupFields.size() + " group fields");
                    if (activeFields.size() != 1) {
                        throw modelEvaluator.createMiningSchemaException("Expected 1 active field, got " + activeFields.size() + " active fields");
                    }
                    InputField activeField = activeFields.get(0);
                    fieldName = activeField.getFieldName();
                    category = value;
                }
            } else if ((groupFields.size() != 1 || category == null) && category == null) {
                throw new MissingAttributeException((PMMLObject)item, PMMLAttributes.ITEM_CATEGORY);
            }
            ItemValue itemValue = new ItemValue(id, fieldName, category);
            result.add(itemValue);
        }
        return result;
    }

    private static class ItemValue
    implements Serializable {
        private String id = null;
        private String field = null;
        private String category = null;

        private ItemValue() {
        }

        private ItemValue(String id, String field, String category) {
            this.setId(id);
            this.setField(field);
            this.setCategory(category);
        }

        private String getId() {
            return this.id;
        }

        private void setId(String id) {
            this.id = id;
        }

        private String getField() {
            return this.field;
        }

        private void setField(String field) {
            this.field = field;
        }

        private String getCategory() {
            return this.category;
        }

        private void setCategory(String category) {
            this.category = category;
        }
    }
}

