/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.clustering;

import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.clustering.Cluster;
import org.jpmml.evaluator.AffinityDistribution;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityClassification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.HasAffinityRanking;
import org.jpmml.evaluator.HasDisplayValue;
import org.jpmml.evaluator.HasEntityAffinity;
import org.jpmml.evaluator.HasEntityIdRanking;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;

public abstract class ClusterAffinityDistribution<V extends Number>
extends EntityClassification<Cluster, String, V>
implements HasEntityIdRanking,
HasDisplayValue,
HasAffinityRanking,
HasEntityAffinity {
    ClusterAffinityDistribution(Classification.Type type, ValueMap<String, V> affinities) {
        super(AffinityDistribution.validateType(type), affinities);
    }

    @Override
    protected void computeResult(DataType dataType) {
        super.computeResult(dataType);
    }

    @Override
    public Set<String> getCategories() {
        return this.keySet();
    }

    @Override
    public List<String> getEntityIdRanking() {
        return this.getWinnerKeys();
    }

    @Override
    public String getDisplayValue() {
        Cluster cluster = (Cluster)this.getEntity();
        if (cluster == null) {
            throw new IllegalStateException();
        }
        return cluster.getName();
    }

    @Override
    public Double getAffinity(String category) {
        return this.getValue(category);
    }

    @Override
    public Report getAffinityReport(String category) {
        return this.getValueReport(category);
    }

    @Override
    public List<Double> getAffinityRanking() {
        return this.getWinnerValues();
    }

    @Override
    public Double getEntityAffinity() {
        return this.getAffinity(this.getEntityId());
    }

    @Override
    public void put(Cluster entity, Value<V> value) {
        BiMap entityRegistry = this.getEntityRegistry();
        String id = EntityUtil.getId(entity, entityRegistry);
        this.put(entity, id, value);
    }
}

