/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Arrays;
import java.util.Collection;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.ComplexDoubleVector;
import org.jpmml.evaluator.DoubleVector;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidArgumentException;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Vector;
import org.jpmml.evaluator.functions.BinaryFunction;

public class PercentileFunction
extends BinaryFunction {
    public PercentileFunction() {
        this(PercentileFunction.class.getName());
    }

    public PercentileFunction(String name) {
        super(name, Arrays.asList("values", "percentile"));
    }

    public Double evaluate(Collection<?> values, int percentile) {
        if (percentile < 1 || percentile > 100) {
            throw new InvalidArgumentException(this, InvalidArgumentException.formatMessage(this, "percentile", percentile) + ". Must be greater than 0, and less than or equal to 100");
        }
        ComplexDoubleVector doubleValues = new ComplexDoubleVector(values.size());
        for (Object value : values) {
            Number number = (Number)TypeUtil.parseOrCast(DataType.DOUBLE, value);
            ((Vector)doubleValues).add(number.doubleValue());
        }
        return ((DoubleVector)doubleValues).doublePercentile(percentile);
    }

    @Override
    public FieldValue evaluate(FieldValue first, FieldValue second) {
        Double result = this.evaluate(first.asCollection(), second.asInteger());
        return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, result);
    }
}

