/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.scorecard;

import java.util.Objects;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.PMMLAttributes;
import org.jpmml.model.MissingAttributeException;

public class PartialScore {
    private Characteristic characteristic = null;
    private Attribute attribute = null;
    private Number value = null;

    PartialScore(Characteristic characteristic, Attribute attribute, Number value) {
        this.setCharacteristic(characteristic);
        this.setAttribute(attribute);
        this.setValue(value);
    }

    public Number getBaselineScore(Number defaultBaselineScore) {
        Characteristic characteristic = this.getCharacteristic();
        Number baselineScore = characteristic.getBaselineScore();
        if (baselineScore == null) {
            baselineScore = defaultBaselineScore;
        }
        if (baselineScore == null) {
            throw new MissingAttributeException((PMMLObject)characteristic, PMMLAttributes.CHARACTERISTIC_BASELINESCORE);
        }
        return baselineScore;
    }

    public String getReasonCode() {
        Characteristic characteristic = this.getCharacteristic();
        Attribute attribute = this.getAttribute();
        String reasonCode = attribute.getReasonCode();
        if (reasonCode == null) {
            reasonCode = characteristic.getReasonCode();
        }
        if (reasonCode == null) {
            throw new MissingAttributeException((PMMLObject)attribute, PMMLAttributes.ATTRIBUTE_REASONCODE);
        }
        return reasonCode;
    }

    public Characteristic getCharacteristic() {
        return this.characteristic;
    }

    private void setCharacteristic(Characteristic characteristic) {
        this.characteristic = Objects.requireNonNull(characteristic);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    private void setAttribute(Attribute attribute) {
        this.attribute = Objects.requireNonNull(attribute);
    }

    public Number getValue() {
        return this.value;
    }

    private void setValue(Number value) {
        this.value = Objects.requireNonNull(value);
    }
}

