/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.provider.AbstractMemoryIO;
import com.kenai.jaffl.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class AbstractBufferMemoryIO
extends AbstractMemoryIO {
    protected final ByteBuffer buffer;

    public AbstractBufferMemoryIO(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public final boolean isDirect() {
        return this.buffer.isDirect();
    }

    public long getAddress() {
        throw new UnsupportedOperationException("Not a direct memory object.");
    }

    public final ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public byte getByte(long offset2) {
        return this.buffer.get((int)offset2);
    }

    public short getShort(long offset2) {
        return this.buffer.getShort((int)offset2);
    }

    public int getInt(long offset2) {
        return this.buffer.getInt((int)offset2);
    }

    public long getLong(long offset2) {
        return this.buffer.getLong((int)offset2);
    }

    public float getFloat(long offset2) {
        return this.buffer.getFloat((int)offset2);
    }

    public double getDouble(long offset2) {
        return this.buffer.getDouble((int)offset2);
    }

    public void putByte(long offset2, byte value2) {
        this.buffer.put((int)offset2, value2);
    }

    public void putShort(long offset2, short value2) {
        this.buffer.putShort((int)offset2, value2);
    }

    public void putInt(long offset2, int value2) {
        this.buffer.putInt((int)offset2, value2);
    }

    public void putLong(long offset2, long value2) {
        this.buffer.putLong((int)offset2, value2);
    }

    public void putFloat(long offset2, float value2) {
        this.buffer.putFloat((int)offset2, value2);
    }

    public void putDouble(long offset2, double value2) {
        this.buffer.putDouble((int)offset2, value2);
    }

    public String getString(long offset2, int size2) {
        return BufferUtil.getString(BufferUtil.slice(this.buffer, (int)offset2), Charset.defaultCharset());
    }

    public void putString(long offset2, String string2) {
        BufferUtil.putString(BufferUtil.slice(this.buffer, (int)offset2), Charset.defaultCharset(), string2);
    }

    public void get(long offset2, byte[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len).get(dst, off, len);
    }

    public void get(long offset2, short[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 16 / 8).asShortBuffer().get(dst, off, len);
    }

    public void get(long offset2, int[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 32 / 8).asIntBuffer().get(dst, off, len);
    }

    public void get(long offset2, long[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 64 / 8).asLongBuffer().get(dst, off, len);
    }

    public void get(long offset2, float[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 32 / 8).asFloatBuffer().get(dst, off, len);
    }

    public void get(long offset2, double[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 64 / 8).asDoubleBuffer().get(dst, off, len);
    }

    public void put(long offset2, byte[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len).put(dst, off, len);
    }

    public void put(long offset2, short[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 16 / 8).asShortBuffer().put(dst, off, len);
    }

    public void put(long offset2, int[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 32 / 8).asIntBuffer().put(dst, off, len);
    }

    public void put(long offset2, long[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 64 / 8).asLongBuffer().put(dst, off, len);
    }

    public void put(long offset2, float[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 32 / 8).asFloatBuffer().put(dst, off, len);
    }

    public void put(long offset2, double[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 64 / 8).asDoubleBuffer().put(dst, off, len);
    }

    public String getString(long offset2) {
        return BufferUtil.getString(BufferUtil.slice(this.buffer, (int)offset2), Charset.defaultCharset());
    }

    public String getString(long offset2, int maxLength, Charset cs) {
        return BufferUtil.getString(BufferUtil.slice(this.buffer, (int)offset2, maxLength), cs);
    }

    public void putString(long offset2, String string2, int maxLength, Charset cs) {
        BufferUtil.putString(BufferUtil.slice(this.buffer, (int)offset2, maxLength), cs, string2);
    }

    public int indexOf(long offset2, byte value2, int maxlen) {
        while (offset2 > -1L) {
            if (this.buffer.get((int)offset2) == value2) {
                return (int)offset2;
            }
            ++offset2;
        }
        return -1;
    }

    public void setMemory(long offset2, long size2, byte value2) {
        int i = 0;
        while ((long)i < size2) {
            this.buffer.put((int)offset2 + i, value2);
            ++i;
        }
    }
}

