/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ReferenceReaper;

@JRubyClass(name={"FFI::AutoPointer"}, parent="FFI::Pointer")
public final class AutoPointer
extends Pointer {
    static final String AUTOPTR_CLASS_NAME = "AutoPointer";
    private static final Map<Reaper, Boolean> referenceSet = new ConcurrentHashMap<Reaper, Boolean>();
    private Pointer pointer;

    public static RubyClass createAutoPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder(AUTOPTR_CLASS_NAME, module.getClass("Pointer"), AutoPointerAllocator.INSTANCE);
        result.defineAnnotatedMethods(AutoPointer.class);
        result.defineAnnotatedConstants(AutoPointer.class);
        return result;
    }

    private AutoPointer(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz, new NullMemoryIO(runtime2));
    }

    private static final void checkPointer(Ruby runtime2, IRubyObject ptr) {
        if (!(ptr instanceof Pointer)) {
            throw runtime2.newTypeError(ptr, runtime2.fastGetModule("FFI").fastGetClass("Pointer"));
        }
        if (ptr instanceof MemoryPointer || ptr instanceof AutoPointer) {
            throw runtime2.newTypeError("Cannot use AutoPointer with MemoryPointer or AutoPointer instances");
        }
    }

    @JRubyMethod(name={"initialize"})
    public final IRubyObject initialize(ThreadContext context, IRubyObject pointerArg) {
        Ruby runtime2 = context.getRuntime();
        AutoPointer.checkPointer(runtime2, pointerArg);
        if (!this.getMetaClass().respondsTo("release")) {
            throw runtime2.newRuntimeError("No release method defined");
        }
        this.setMemoryIO(((Pointer)pointerArg).getMemoryIO());
        this.pointer = (Pointer)pointerArg;
        referenceSet.put(new Reaper(this, this.pointer, this.getMetaClass(), "release"), Boolean.TRUE);
        return this;
    }

    @JRubyMethod(name={"initialize"})
    public final IRubyObject initialize(ThreadContext context, IRubyObject pointerArg, IRubyObject releaser) {
        AutoPointer.checkPointer(context.getRuntime(), pointerArg);
        this.setMemoryIO(((Pointer)pointerArg).getMemoryIO());
        this.pointer = (Pointer)pointerArg;
        referenceSet.put(new Reaper(this, this.pointer, releaser, "call"), Boolean.TRUE);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Reaper
    extends ReferenceReaper.Phantom<AutoPointer>
    implements Runnable {
        private final Pointer pointer;
        private final IRubyObject proc;
        private final String methodName;

        private Reaper(AutoPointer pointer2, Pointer ptr, IRubyObject proc2, String methodName) {
            super(pointer2);
            this.pointer = ptr;
            this.proc = proc2;
            this.methodName = methodName;
        }

        @Override
        public void run() {
            referenceSet.remove(this);
            this.proc.callMethod(this.pointer.getRuntime().getCurrentContext(), this.methodName, this.pointer);
        }
    }

    private static final class AutoPointerAllocator
    implements ObjectAllocator {
        static final ObjectAllocator INSTANCE = new AutoPointerAllocator();

        private AutoPointerAllocator() {
        }

        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new AutoPointer(runtime2, klazz);
        }
    }
}

