/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.sun.jna.FromNativeContext;
import com.sun.jna.NativeMapped;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapStruct
implements NativeMapped {
    private static final String arch = System.getProperty("os.arch").toLowerCase();
    private static final boolean isSPARC = "sparc".equals(arch);
    private static final int LONG_SIZE = (Platform.isWindows() ? 4 : Pointer.SIZE) * 8;
    private static final int LONG_ALIGN = isSPARC ? 64 : LONG_SIZE;
    private static final long LONG_MASK = LONG_SIZE == 32 ? java.lang.Integer.MAX_VALUE : java.lang.Long.MAX_VALUE;
    private static final int DOUBLE_ALIGN = isSPARC ? 64 : LONG_SIZE;
    private static final int FLOAT_ALIGN = isSPARC ? 64 : 32;
    private ByteBuffer buffer;
    private int size = 0;

    @Override
    public Object fromNative(Object arg0, FromNativeContext arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object toNative() {
        return this.getByteBuffer();
    }

    @Override
    public Class nativeType() {
        return ByteBuffer.class;
    }

    protected final ByteBuffer getByteBuffer() {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(this.size).order(ByteOrder.nativeOrder());
        }
        return this.buffer;
    }

    public final int getStructSize() {
        return this.size;
    }

    protected final int addField(int size2, int align) {
        int mask = align / 8 - 1;
        if ((this.size & mask) != 0) {
            this.size = (this.size & ~mask) + align / 8;
        }
        int off = this.size;
        this.size += size2 / 8;
        return off;
    }

    protected <T extends Field> T[] array(T[] array) {
        try {
            Class<?> arrayClass = array.getClass().getComponentType();
            Constructor<?> ctor = arrayClass.getDeclaredConstructor(arrayClass.getEnclosingClass());
            Object[] parameters = new Object[]{this};
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Field)ctor.newInstance(parameters);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return array;
    }

    protected class LongLong
    extends Int64 {
        public LongLong() {
        }

        public LongLong(long value2) {
            super(value2);
        }
    }

    protected class ULong
    extends Field {
        public ULong() {
            super(LONG_SIZE, LONG_ALIGN);
        }

        public ULong(long value2) {
            this();
            this.set(value2);
        }

        public final long get() {
            long value2 = LONG_SIZE == 32 ? (long)HeapStruct.this.getByteBuffer().getInt(this.offset) : HeapStruct.this.getByteBuffer().getLong(this.offset);
            return value2 < 0L ? (value2 & LONG_MASK) + LONG_MASK + 1L : value2;
        }

        public final void set(long value2) {
            if (LONG_SIZE == 32) {
                HeapStruct.this.getByteBuffer().putInt(this.offset, (int)value2);
            } else {
                HeapStruct.this.getByteBuffer().putLong(this.offset, value2);
            }
        }
    }

    protected class Long
    extends Field {
        public Long() {
            super(LONG_SIZE, LONG_ALIGN);
        }

        public Long(long value2) {
            this();
            this.set(value2);
        }

        public final long get() {
            return LONG_SIZE == 32 ? (long)HeapStruct.this.getByteBuffer().getInt(this.offset) : HeapStruct.this.getByteBuffer().getLong(this.offset);
        }

        public final void set(long value2) {
            if (LONG_SIZE == 32) {
                HeapStruct.this.getByteBuffer().putInt(this.offset, (int)value2);
            } else {
                HeapStruct.this.getByteBuffer().putLong(this.offset, value2);
            }
        }
    }

    protected class Int64
    extends Field {
        public Int64() {
            super(64, LONG_ALIGN);
        }

        public Int64(long value2) {
            this();
            this.set(value2);
        }

        public final long get() {
            return HeapStruct.this.getByteBuffer().getLong(this.offset);
        }

        public final void set(long value2) {
            HeapStruct.this.getByteBuffer().putLong(this.offset, value2);
        }
    }

    protected class Integer
    extends Int32 {
        public Integer() {
        }

        public Integer(int value2) {
            super(value2);
        }
    }

    protected class UInt32
    extends Field {
        public UInt32() {
            super(32);
        }

        public UInt32(long value2) {
            this();
            this.set(value2);
        }

        public final long get() {
            long value2 = HeapStruct.this.getByteBuffer().getInt(this.offset);
            return value2 < 0L ? (value2 & java.lang.Integer.MAX_VALUE) + 0x80000000L : value2;
        }

        public final void set(long value2) {
            HeapStruct.this.getByteBuffer().putInt(this.offset, (int)value2);
        }
    }

    protected class Int32
    extends Field {
        public Int32() {
            super(32);
        }

        public Int32(int value2) {
            this();
            this.set(value2);
        }

        public final int get() {
            return HeapStruct.this.getByteBuffer().getInt(this.offset);
        }

        public final void set(int value2) {
            HeapStruct.this.getByteBuffer().putInt(this.offset, value2);
        }
    }

    protected class Short
    extends Int16 {
        public Short() {
        }

        public Short(short value2) {
            super(value2);
        }
    }

    protected class UInt16
    extends Field {
        public UInt16() {
            super(16);
        }

        public UInt16(short value2) {
            this();
            this.set(value2);
        }

        public final int get() {
            int value2 = HeapStruct.this.getByteBuffer().getShort(this.offset);
            return value2 < 0 ? (value2 & java.lang.Short.MAX_VALUE) + 32768 : value2;
        }

        public final void set(int value2) {
            HeapStruct.this.getByteBuffer().putShort(this.offset, (short)value2);
        }
    }

    protected class Int16
    extends Field {
        public Int16() {
            super(16);
        }

        public Int16(short value2) {
            this();
            this.set(value2);
        }

        public final short get() {
            return HeapStruct.this.getByteBuffer().getShort(this.offset);
        }

        public final void set(short value2) {
            HeapStruct.this.getByteBuffer().putShort(this.offset, value2);
        }
    }

    protected final class Byte
    extends Int8 {
        public Byte() {
        }

        public Byte(byte value2) {
            super(value2);
        }
    }

    protected class UInt8
    extends Field {
        public UInt8() {
            super(8);
        }

        public UInt8(short value2) {
            this();
            this.set(value2);
        }

        public final short get() {
            short value2 = HeapStruct.this.getByteBuffer().get(this.offset);
            return value2 < 0 ? (short)((value2 & 0x7F) + 128) : value2;
        }

        public final void set(short value2) {
            HeapStruct.this.getByteBuffer().put(this.offset, (byte)value2);
        }
    }

    protected class Int8
    extends Field {
        public Int8() {
            super(8);
        }

        public Int8(byte value2) {
            this();
            this.set(value2);
        }

        public final byte get() {
            return HeapStruct.this.getByteBuffer().get(this.offset);
        }

        public final void set(byte value2) {
            HeapStruct.this.getByteBuffer().put(this.offset, value2);
        }
    }

    protected abstract class Field {
        public final int size;
        public final int align;
        public final int offset;

        public Field(int size2) {
            this(size2, size2);
        }

        public Field(int size2, int align) {
            this.size = size2;
            this.align = align;
            this.offset = HeapStruct.this.addField(size2, align);
        }
    }
}

