/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.OutboundHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractClient.class);
    protected final String host;
    protected final int port;
    protected final String contextPath;
    protected NettyHttpClient nettyHttpClient = new NettyHttpClient();
    protected HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    protected ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    protected VerificationSerializer verificationSerializer = new VerificationSerializer();
    protected VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    protected AbstractClient(String host, int port, String contextPath) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Host can not be null or empty");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("ContextPath can not be null");
        }
        this.host = host;
        this.port = port;
        this.contextPath = this.cleanContextPath(contextPath);
    }

    private String cleanContextPath(String contextPath) {
        if (!Strings.isNullOrEmpty((String)contextPath)) {
            if (!contextPath.endsWith("/")) {
                contextPath = contextPath + "/";
            }
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
        }
        return contextPath;
    }

    protected String calculatePath(String path) {
        return "/" + path;
    }

    protected HttpResponse sendRequest(HttpRequest httpRequest) {
        return this.nettyHttpClient.sendRequest(OutboundHttpRequest.outboundRequest((String)this.host, (int)this.port, (String)this.contextPath, (HttpRequest)httpRequest));
    }
}

