/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.client.model.Collation;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.Success;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import com.mongodb.reactivestreams.client.internal.PublisherHelper;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class AggregatePublisherImpl<TResult>
implements AggregatePublisher<TResult> {
    private final AggregateIterable<TResult> wrapped;

    AggregatePublisherImpl(AggregateIterable<TResult> wrapped) {
        this.wrapped = (AggregateIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public AggregatePublisher<TResult> allowDiskUse(Boolean allowDiskUse) {
        this.wrapped.allowDiskUse(allowDiskUse);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> useCursor(Boolean useCursor) {
        this.wrapped.useCursor(useCursor);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.wrapped.bypassDocumentValidation(bypassDocumentValidation);
        return this;
    }

    @Override
    public Publisher<Success> toCollection() {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                AggregatePublisherImpl.this.wrapped.toCollection(PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public AggregatePublisher<TResult> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> comment(String comment) {
        this.wrapped.comment(comment);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> hint(Bson hint) {
        this.wrapped.hint(hint);
        return this;
    }

    public void subscribe(Subscriber<? super TResult> s) {
        new ObservableToPublisher<TResult>(Observables.observe(this.wrapped)).subscribe(s);
    }
}

