/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.management;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.loading.PrivateMLet;
import org.mortbay.component.Container;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.management.ObjectMBean;
import org.mortbay.util.TypeUtil;

public class MBeanContainer
implements Container.Listener {
    private final MBeanServer _server;
    private volatile int _managementPort;
    private final WeakHashMap _beans = new WeakHashMap();
    private final HashMap _unique = new HashMap();

    public synchronized ObjectName findMBean(Object object) {
        ObjectName bean = (ObjectName)this._beans.get(object);
        return bean == null ? null : bean;
    }

    public synchronized Object findBean(ObjectName oname) {
        Iterator iter = this._beans.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ObjectName bean = (ObjectName)entry.getValue();
            if (!bean.equals(oname)) continue;
            return entry.getKey();
        }
        return null;
    }

    public MBeanContainer(MBeanServer server) {
        this._server = server;
        Logger log = Log.getLog();
        if (log != null) {
            this.addBean(log);
        }
    }

    public void setManagementPort(int port) {
        this._managementPort = port;
    }

    public void start() {
        if (this._managementPort > 0) {
            try {
                Log.warn((String)"HttpAdaptor for mx4j is not secure");
                PrivateMLet mlet = new PrivateMLet(new URL[0], Thread.currentThread().getContextClassLoader(), false);
                ObjectName mletName = ObjectName.getInstance("mx4j", "name", "HttpAdaptorLoader");
                this._server.registerMBean(mlet, mletName);
                ObjectName adaptorName = ObjectName.getInstance("mx4j", "name", "HttpAdaptor");
                this._server.createMBean("mx4j.tools.adaptor.http.HttpAdaptor", adaptorName, mletName);
                this._server.setAttribute(adaptorName, new Attribute("Port", new Integer(this._managementPort)));
                this._server.setAttribute(adaptorName, new Attribute("Host", "localhost"));
                ObjectName processorName = ObjectName.getInstance("mx4j", "name", "XSLTProcessor");
                this._server.createMBean("mx4j.tools.adaptor.http.XSLTProcessor", processorName, mletName);
                this._server.setAttribute(adaptorName, new Attribute("ProcessorName", processorName));
                this._server.invoke(adaptorName, "start", null, null);
                Runtime.getRuntime().addShutdownHook(new ShutdownHook(mletName, adaptorName, processorName));
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
    }

    public synchronized void add(Container.Relationship event) {
        ObjectName child;
        ObjectName parent = (ObjectName)this._beans.get(event.getParent());
        if (parent == null) {
            this.addBean(event.getParent());
        }
        if ((child = (ObjectName)this._beans.get(event.getChild())) == null) {
            this.addBean(event.getChild());
        }
    }

    public synchronized void remove(Container.Relationship event) {
    }

    public synchronized void removeBean(Object obj) {
        ObjectName bean = (ObjectName)this._beans.get(obj);
        if (bean != null) {
            try {
                this._server.unregisterMBean(bean);
                Log.debug((String)"Unregistered {}", (Object)bean);
            }
            catch (InstanceNotFoundException e) {
                Log.ignore((Throwable)e);
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
    }

    public synchronized void addBean(Object obj) {
        try {
            Integer count;
            String name;
            int dot;
            if (obj == null || this._beans.containsKey(obj)) {
                return;
            }
            Object mbean = ObjectMBean.mbeanFor(obj);
            if (mbean == null) {
                return;
            }
            if (mbean instanceof ObjectMBean) {
                ((ObjectMBean)mbean).setMBeanContainer(this);
            }
            if ((dot = (name = obj.getClass().getName().toLowerCase()).lastIndexOf(46)) >= 0) {
                name = name.substring(dot + 1);
            }
            count = TypeUtil.newInteger((int)((count = (Integer)this._unique.get(name)) == null ? 0 : 1 + count));
            this._unique.put(name, count);
            String domain = obj.getClass().getPackage().getName();
            ObjectName oname = ObjectName.getInstance(domain + ":type=" + name + ",id=" + count);
            ObjectInstance oinstance = this._server.registerMBean(mbean, oname);
            Log.debug((String)"Registered {}", (Object)oinstance.getObjectName());
            this._beans.put(obj, oinstance.getObjectName());
        }
        catch (Exception e) {
            Log.warn((String)("bean: " + obj), (Throwable)e);
        }
    }

    private class ShutdownHook
    extends Thread {
        private final ObjectName mletName;
        private final ObjectName adaptorName;
        private final ObjectName processorName;

        public ShutdownHook(ObjectName mletName, ObjectName adaptorName, ObjectName processorName) {
            this.mletName = mletName;
            this.adaptorName = adaptorName;
            this.processorName = processorName;
        }

        public void run() {
            this.halt();
            this.unregister(this.processorName);
            this.unregister(this.adaptorName);
            this.unregister(this.mletName);
        }

        private void halt() {
            try {
                MBeanContainer.this._server.invoke(this.adaptorName, "stop", null, null);
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }

        private void unregister(ObjectName objectName) {
            try {
                MBeanContainer.this._server.unregisterMBean(objectName);
                Log.debug((String)("Unregistered " + objectName));
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
    }
}

