/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta;

import java.util.logging.Logger;
import org.multiverse.api.PropagationLevel;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.closures.AtomicBooleanClosure;
import org.multiverse.api.closures.AtomicClosure;
import org.multiverse.api.closures.AtomicDoubleClosure;
import org.multiverse.api.closures.AtomicIntClosure;
import org.multiverse.api.closures.AtomicLongClosure;
import org.multiverse.api.closures.AtomicVoidClosure;
import org.multiverse.api.exceptions.InvisibleCheckedException;
import org.multiverse.api.exceptions.ReadWriteConflict;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.api.exceptions.SpeculativeConfigurationError;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.api.exceptions.TransactionNotAllowedException;
import org.multiverse.api.exceptions.TransactionRequiredException;
import org.multiverse.sensors.TransactionSensor;
import org.multiverse.stms.beta.AbstractBetaAtomicBlock;
import org.multiverse.stms.beta.BetaTransactionFactory;
import org.multiverse.stms.beta.transactions.BetaTransaction;

public final class FatBetaAtomicBlock
extends AbstractBetaAtomicBlock {
    private static final Logger logger = Logger.getLogger(FatBetaAtomicBlock.class.getName());
    private final PropagationLevel propagationLevel;

    public FatBetaAtomicBlock(BetaTransactionFactory transactionFactory) {
        super(transactionFactory);
        this.propagationLevel = this.transactionConfiguration.propagationLevel;
    }

    @Override
    public BetaTransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    @Override
    public <E> E executeChecked(AtomicClosure<E> closure) throws Exception {
        try {
            return this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <E> E execute(AtomicClosure<E> closure) {
        if (closure == null) {
            throw new NullPointerException();
        }
        ThreadLocalTransaction.Container transactionContainer = ThreadLocalTransaction.getThreadLocalTransactionContainer();
        BetaTransaction tx = (BetaTransaction)transactionContainer.transaction;
        if (tx == null || !tx.isAlive()) {
            tx = null;
        }
        try {
            switch (this.propagationLevel) {
                case Requires: {
                    if (tx != null) {
                        if (!___TracingEnabled) return closure.execute(tx);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'Requires' propagation level, and existing transaction [%s] found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Requires' propagation level and no transaction found, starting a new transaction", this.transactionConfiguration.familyName));
                    }
                    tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                    transactionContainer.transaction = tx;
                    return this.execute(tx, transactionContainer, closure);
                }
                case Mandatory: {
                    if (tx != null) {
                        if (!___TracingEnabled) return closure.execute(tx);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'Mandatory' propagation level and transaction [%s] found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Mandatory' propagation level, and no transaction is found", this.transactionConfiguration.familyName));
                    }
                    throw new TransactionRequiredException(String.format("No transaction is found for atomicblock '%s' with 'Mandatory' propagation level", this.transactionConfiguration.familyName));
                }
                case Never: {
                    if (tx == null) {
                        if (!___TracingEnabled) return closure.execute(null);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(null);
                        logger.info(String.format("[%s] Has 'Never' propagation level and no transaction is found", this.transactionConfiguration.familyName));
                        return closure.execute(null);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Never' propagation level, but transaction [%s] is found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    throw new TransactionNotAllowedException(String.format("No transaction is allowed for atomicblock '%s' with propagation level 'Never', but transaction '%s' was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                }
                case RequiresNew: {
                    if (tx == null) {
                        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                            logger.info(String.format("[%s] Has 'RequiresNew' propagation level and no transaction is found, starting new transaction", this.transactionConfiguration.familyName));
                        }
                        tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                        transactionContainer.transaction = tx;
                        return this.execute(tx, transactionContainer, closure);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    BetaTransaction suspendedTransaction = tx;
                    tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                    transactionContainer.transaction = tx;
                    try {
                        E e = this.execute(tx, transactionContainer, closure);
                        return e;
                    }
                    finally {
                        transactionContainer.transaction = suspendedTransaction;
                    }
                }
                case Supports: {
                    if (!___TracingEnabled) return closure.execute(tx);
                    if (tx != null) {
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                    logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    return closure.execute(tx);
                }
            }
            throw new IllegalStateException();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <E> E execute(BetaTransaction tx, ThreadLocalTransaction.Container transactionContainer, AtomicClosure<E> closure) throws Exception {
        try {
            boolean abort = true;
            while (true) {
                E e;
                block17: {
                    try {
                        TransactionSensor sensor;
                        E result = closure.execute(tx);
                        tx.commit();
                        abort = false;
                        e = result;
                        if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                            sensor.signalExecution(tx.getAttempt(), !abort);
                        }
                        if (!abort) break block17;
                    }
                    catch (Retry e2) {
                        block18: {
                            try {
                                TransactionSensor sensor;
                                abort = false;
                                if (!___TracingEnabled || !this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) continue;
                                logger.info(String.format("[%s] Encountered a retry", this.transactionConfiguration.familyName));
                                continue;
                                catch (SpeculativeConfigurationError e3) {
                                    abort = false;
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a speculative configuration error", this.transactionConfiguration.familyName));
                                    }
                                    BetaTransaction old = tx;
                                    tx = this.transactionFactory.upgradeAfterSpeculativeFailure(tx, transactionContainer.transactionPool);
                                    transactionContainer.transactionPool.putBetaTransaction(old);
                                    transactionContainer.transaction = tx;
                                    continue;
                                }
                                catch (ReadWriteConflict e4) {
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a read or write conflict", this.transactionConfiguration.familyName));
                                    }
                                    this.backoffPolicy.delayedUninterruptible(tx.getAttempt());
                                }
                                if (tx.softReset()) continue;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (!abort) break block18;
                            }
                            catch (Throwable throwable) {
                                TransactionSensor sensor;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (abort) {
                                    tx.abort();
                                }
                                transactionContainer.transactionPool.putBetaTransaction(tx);
                                transactionContainer.transaction = null;
                                throw throwable;
                            }
                            tx.abort();
                        }
                        transactionContainer.transactionPool.putBetaTransaction(tx);
                        transactionContainer.transaction = null;
                        break;
                    }
                    tx.abort();
                }
                transactionContainer.transactionPool.putBetaTransaction(tx);
                transactionContainer.transaction = null;
                return e;
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
            logger.info(String.format("[%s] Too many retries, a maximum of %s is allowed", this.transactionConfiguration.familyName, this.transactionConfiguration.getMaxRetries()));
        }
        throw new TooManyRetriesException(String.format("[%s] Maximum number of %s retries has been reached", this.transactionConfiguration.getFamilyName(), this.transactionConfiguration.getMaxRetries()));
    }

    @Override
    public int executeChecked(AtomicIntClosure closure) throws Exception {
        try {
            return this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(AtomicIntClosure closure) {
        if (closure == null) {
            throw new NullPointerException();
        }
        ThreadLocalTransaction.Container transactionContainer = ThreadLocalTransaction.getThreadLocalTransactionContainer();
        BetaTransaction tx = (BetaTransaction)transactionContainer.transaction;
        if (tx == null || !tx.isAlive()) {
            tx = null;
        }
        try {
            switch (this.propagationLevel) {
                case Requires: {
                    if (tx != null) {
                        if (!___TracingEnabled) return closure.execute(tx);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'Requires' propagation level, and existing transaction [%s] found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Requires' propagation level and no transaction found, starting a new transaction", this.transactionConfiguration.familyName));
                    }
                    tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                    transactionContainer.transaction = tx;
                    return this.execute(tx, transactionContainer, closure);
                }
                case Mandatory: {
                    if (tx != null) {
                        if (!___TracingEnabled) return closure.execute(tx);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'Mandatory' propagation level and transaction [%s] found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Mandatory' propagation level, and no transaction is found", this.transactionConfiguration.familyName));
                    }
                    throw new TransactionRequiredException(String.format("No transaction is found for atomicblock '%s' with 'Mandatory' propagation level", this.transactionConfiguration.familyName));
                }
                case Never: {
                    if (tx == null) {
                        if (!___TracingEnabled) return closure.execute(null);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(null);
                        logger.info(String.format("[%s] Has 'Never' propagation level and no transaction is found", this.transactionConfiguration.familyName));
                        return closure.execute(null);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Never' propagation level, but transaction [%s] is found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    throw new TransactionNotAllowedException(String.format("No transaction is allowed for atomicblock '%s' with propagation level 'Never', but transaction '%s' was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                }
                case RequiresNew: {
                    if (tx == null) {
                        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                            logger.info(String.format("[%s] Has 'RequiresNew' propagation level and no transaction is found, starting new transaction", this.transactionConfiguration.familyName));
                        }
                        tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                        transactionContainer.transaction = tx;
                        return this.execute(tx, transactionContainer, closure);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    BetaTransaction suspendedTransaction = tx;
                    tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                    transactionContainer.transaction = tx;
                    try {
                        int n = this.execute(tx, transactionContainer, closure);
                        return n;
                    }
                    finally {
                        transactionContainer.transaction = suspendedTransaction;
                    }
                }
                case Supports: {
                    if (!___TracingEnabled) return closure.execute(tx);
                    if (tx != null) {
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                    logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    return closure.execute(tx);
                }
            }
            throw new IllegalStateException();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int execute(BetaTransaction tx, ThreadLocalTransaction.Container transactionContainer, AtomicIntClosure closure) throws Exception {
        try {
            boolean abort = true;
            while (true) {
                int n;
                block17: {
                    try {
                        TransactionSensor sensor;
                        int result = closure.execute(tx);
                        tx.commit();
                        abort = false;
                        n = result;
                        if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                            sensor.signalExecution(tx.getAttempt(), !abort);
                        }
                        if (!abort) break block17;
                    }
                    catch (Retry e) {
                        block18: {
                            try {
                                TransactionSensor sensor;
                                abort = false;
                                if (!___TracingEnabled || !this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) continue;
                                logger.info(String.format("[%s] Encountered a retry", this.transactionConfiguration.familyName));
                                continue;
                                catch (SpeculativeConfigurationError e2) {
                                    abort = false;
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a speculative configuration error", this.transactionConfiguration.familyName));
                                    }
                                    BetaTransaction old = tx;
                                    tx = this.transactionFactory.upgradeAfterSpeculativeFailure(tx, transactionContainer.transactionPool);
                                    transactionContainer.transactionPool.putBetaTransaction(old);
                                    transactionContainer.transaction = tx;
                                    continue;
                                }
                                catch (ReadWriteConflict e3) {
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a read or write conflict", this.transactionConfiguration.familyName));
                                    }
                                    this.backoffPolicy.delayedUninterruptible(tx.getAttempt());
                                }
                                if (tx.softReset()) continue;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (!abort) break block18;
                            }
                            catch (Throwable throwable) {
                                TransactionSensor sensor;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (abort) {
                                    tx.abort();
                                }
                                transactionContainer.transactionPool.putBetaTransaction(tx);
                                transactionContainer.transaction = null;
                                throw throwable;
                            }
                            tx.abort();
                        }
                        transactionContainer.transactionPool.putBetaTransaction(tx);
                        transactionContainer.transaction = null;
                        break;
                    }
                    tx.abort();
                }
                transactionContainer.transactionPool.putBetaTransaction(tx);
                transactionContainer.transaction = null;
                return n;
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
            logger.info(String.format("[%s] Too many retries, a maximum of %s is allowed", this.transactionConfiguration.familyName, this.transactionConfiguration.getMaxRetries()));
        }
        throw new TooManyRetriesException(String.format("[%s] Maximum number of %s retries has been reached", this.transactionConfiguration.getFamilyName(), this.transactionConfiguration.getMaxRetries()));
    }

    @Override
    public long executeChecked(AtomicLongClosure closure) throws Exception {
        try {
            return this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long execute(AtomicLongClosure closure) {
        if (closure == null) {
            throw new NullPointerException();
        }
        ThreadLocalTransaction.Container transactionContainer = ThreadLocalTransaction.getThreadLocalTransactionContainer();
        BetaTransaction tx = (BetaTransaction)transactionContainer.transaction;
        if (tx == null || !tx.isAlive()) {
            tx = null;
        }
        try {
            switch (this.propagationLevel) {
                case Requires: {
                    if (tx != null) {
                        if (!___TracingEnabled) return closure.execute(tx);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'Requires' propagation level, and existing transaction [%s] found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Requires' propagation level and no transaction found, starting a new transaction", this.transactionConfiguration.familyName));
                    }
                    tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                    transactionContainer.transaction = tx;
                    return this.execute(tx, transactionContainer, closure);
                }
                case Mandatory: {
                    if (tx != null) {
                        if (!___TracingEnabled) return closure.execute(tx);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'Mandatory' propagation level and transaction [%s] found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Mandatory' propagation level, and no transaction is found", this.transactionConfiguration.familyName));
                    }
                    throw new TransactionRequiredException(String.format("No transaction is found for atomicblock '%s' with 'Mandatory' propagation level", this.transactionConfiguration.familyName));
                }
                case Never: {
                    if (tx == null) {
                        if (!___TracingEnabled) return closure.execute(null);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(null);
                        logger.info(String.format("[%s] Has 'Never' propagation level and no transaction is found", this.transactionConfiguration.familyName));
                        return closure.execute(null);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Never' propagation level, but transaction [%s] is found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    throw new TransactionNotAllowedException(String.format("No transaction is allowed for atomicblock '%s' with propagation level 'Never', but transaction '%s' was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                }
                case RequiresNew: {
                    if (tx == null) {
                        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                            logger.info(String.format("[%s] Has 'RequiresNew' propagation level and no transaction is found, starting new transaction", this.transactionConfiguration.familyName));
                        }
                        tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                        transactionContainer.transaction = tx;
                        return this.execute(tx, transactionContainer, closure);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    BetaTransaction suspendedTransaction = tx;
                    tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                    transactionContainer.transaction = tx;
                    try {
                        long l = this.execute(tx, transactionContainer, closure);
                        return l;
                    }
                    finally {
                        transactionContainer.transaction = suspendedTransaction;
                    }
                }
                case Supports: {
                    if (!___TracingEnabled) return closure.execute(tx);
                    if (tx != null) {
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                    logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    return closure.execute(tx);
                }
            }
            throw new IllegalStateException();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long execute(BetaTransaction tx, ThreadLocalTransaction.Container transactionContainer, AtomicLongClosure closure) throws Exception {
        try {
            boolean abort = true;
            while (true) {
                long l;
                block17: {
                    try {
                        TransactionSensor sensor;
                        long result = closure.execute(tx);
                        tx.commit();
                        abort = false;
                        l = result;
                        if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                            sensor.signalExecution(tx.getAttempt(), !abort);
                        }
                        if (!abort) break block17;
                    }
                    catch (Retry e) {
                        block18: {
                            try {
                                TransactionSensor sensor;
                                abort = false;
                                if (!___TracingEnabled || !this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) continue;
                                logger.info(String.format("[%s] Encountered a retry", this.transactionConfiguration.familyName));
                                continue;
                                catch (SpeculativeConfigurationError e2) {
                                    abort = false;
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a speculative configuration error", this.transactionConfiguration.familyName));
                                    }
                                    BetaTransaction old = tx;
                                    tx = this.transactionFactory.upgradeAfterSpeculativeFailure(tx, transactionContainer.transactionPool);
                                    transactionContainer.transactionPool.putBetaTransaction(old);
                                    transactionContainer.transaction = tx;
                                    continue;
                                }
                                catch (ReadWriteConflict e3) {
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a read or write conflict", this.transactionConfiguration.familyName));
                                    }
                                    this.backoffPolicy.delayedUninterruptible(tx.getAttempt());
                                }
                                if (tx.softReset()) continue;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (!abort) break block18;
                            }
                            catch (Throwable throwable) {
                                TransactionSensor sensor;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (abort) {
                                    tx.abort();
                                }
                                transactionContainer.transactionPool.putBetaTransaction(tx);
                                transactionContainer.transaction = null;
                                throw throwable;
                            }
                            tx.abort();
                        }
                        transactionContainer.transactionPool.putBetaTransaction(tx);
                        transactionContainer.transaction = null;
                        break;
                    }
                    tx.abort();
                }
                transactionContainer.transactionPool.putBetaTransaction(tx);
                transactionContainer.transaction = null;
                return l;
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
            logger.info(String.format("[%s] Too many retries, a maximum of %s is allowed", this.transactionConfiguration.familyName, this.transactionConfiguration.getMaxRetries()));
        }
        throw new TooManyRetriesException(String.format("[%s] Maximum number of %s retries has been reached", this.transactionConfiguration.getFamilyName(), this.transactionConfiguration.getMaxRetries()));
    }

    @Override
    public double executeChecked(AtomicDoubleClosure closure) throws Exception {
        try {
            return this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public double execute(AtomicDoubleClosure closure) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 7[CASE], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private double execute(BetaTransaction tx, ThreadLocalTransaction.Container transactionContainer, AtomicDoubleClosure closure) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean executeChecked(AtomicBooleanClosure closure) throws Exception {
        try {
            return this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(AtomicBooleanClosure closure) {
        if (closure == null) {
            throw new NullPointerException();
        }
        ThreadLocalTransaction.Container transactionContainer = ThreadLocalTransaction.getThreadLocalTransactionContainer();
        BetaTransaction tx = (BetaTransaction)transactionContainer.transaction;
        if (tx == null || !tx.isAlive()) {
            tx = null;
        }
        try {
            switch (this.propagationLevel) {
                case Requires: {
                    if (tx != null) {
                        if (!___TracingEnabled) return closure.execute(tx);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'Requires' propagation level, and existing transaction [%s] found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Requires' propagation level and no transaction found, starting a new transaction", this.transactionConfiguration.familyName));
                    }
                    tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                    transactionContainer.transaction = tx;
                    return this.execute(tx, transactionContainer, closure);
                }
                case Mandatory: {
                    if (tx != null) {
                        if (!___TracingEnabled) return closure.execute(tx);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'Mandatory' propagation level and transaction [%s] found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Mandatory' propagation level, and no transaction is found", this.transactionConfiguration.familyName));
                    }
                    throw new TransactionRequiredException(String.format("No transaction is found for atomicblock '%s' with 'Mandatory' propagation level", this.transactionConfiguration.familyName));
                }
                case Never: {
                    if (tx == null) {
                        if (!___TracingEnabled) return closure.execute(null);
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(null);
                        logger.info(String.format("[%s] Has 'Never' propagation level and no transaction is found", this.transactionConfiguration.familyName));
                        return closure.execute(null);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Never' propagation level, but transaction [%s] is found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    throw new TransactionNotAllowedException(String.format("No transaction is allowed for atomicblock '%s' with propagation level 'Never', but transaction '%s' was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                }
                case RequiresNew: {
                    if (tx == null) {
                        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                            logger.info(String.format("[%s] Has 'RequiresNew' propagation level and no transaction is found, starting new transaction", this.transactionConfiguration.familyName));
                        }
                        tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                        transactionContainer.transaction = tx;
                        return this.execute(tx, transactionContainer, closure);
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    BetaTransaction suspendedTransaction = tx;
                    tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                    transactionContainer.transaction = tx;
                    try {
                        boolean bl = this.execute(tx, transactionContainer, closure);
                        return bl;
                    }
                    finally {
                        transactionContainer.transaction = suspendedTransaction;
                    }
                }
                case Supports: {
                    if (!___TracingEnabled) return closure.execute(tx);
                    if (tx != null) {
                        if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                        logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        return closure.execute(tx);
                    }
                    if (!this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) return closure.execute(tx);
                    logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    return closure.execute(tx);
                }
            }
            throw new IllegalStateException();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean execute(BetaTransaction tx, ThreadLocalTransaction.Container transactionContainer, AtomicBooleanClosure closure) throws Exception {
        try {
            boolean abort = true;
            while (true) {
                boolean bl;
                block17: {
                    try {
                        TransactionSensor sensor;
                        boolean result = closure.execute(tx);
                        tx.commit();
                        abort = false;
                        bl = result;
                        if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                            sensor.signalExecution(tx.getAttempt(), !abort);
                        }
                        if (!abort) break block17;
                    }
                    catch (Retry e) {
                        block18: {
                            try {
                                TransactionSensor sensor;
                                abort = false;
                                if (!___TracingEnabled || !this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) continue;
                                logger.info(String.format("[%s] Encountered a retry", this.transactionConfiguration.familyName));
                                continue;
                                catch (SpeculativeConfigurationError e2) {
                                    abort = false;
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a speculative configuration error", this.transactionConfiguration.familyName));
                                    }
                                    BetaTransaction old = tx;
                                    tx = this.transactionFactory.upgradeAfterSpeculativeFailure(tx, transactionContainer.transactionPool);
                                    transactionContainer.transactionPool.putBetaTransaction(old);
                                    transactionContainer.transaction = tx;
                                    continue;
                                }
                                catch (ReadWriteConflict e3) {
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a read or write conflict", this.transactionConfiguration.familyName));
                                    }
                                    this.backoffPolicy.delayedUninterruptible(tx.getAttempt());
                                }
                                if (tx.softReset()) continue;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (!abort) break block18;
                            }
                            catch (Throwable throwable) {
                                TransactionSensor sensor;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (abort) {
                                    tx.abort();
                                }
                                transactionContainer.transactionPool.putBetaTransaction(tx);
                                transactionContainer.transaction = null;
                                throw throwable;
                            }
                            tx.abort();
                        }
                        transactionContainer.transactionPool.putBetaTransaction(tx);
                        transactionContainer.transaction = null;
                        break;
                    }
                    tx.abort();
                }
                transactionContainer.transactionPool.putBetaTransaction(tx);
                transactionContainer.transaction = null;
                return bl;
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
            logger.info(String.format("[%s] Too many retries, a maximum of %s is allowed", this.transactionConfiguration.familyName, this.transactionConfiguration.getMaxRetries()));
        }
        throw new TooManyRetriesException(String.format("[%s] Maximum number of %s retries has been reached", this.transactionConfiguration.getFamilyName(), this.transactionConfiguration.getMaxRetries()));
    }

    @Override
    public void executeChecked(AtomicVoidClosure closure) throws Exception {
        try {
            this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(AtomicVoidClosure closure) {
        if (closure == null) {
            throw new NullPointerException();
        }
        ThreadLocalTransaction.Container transactionContainer = ThreadLocalTransaction.getThreadLocalTransactionContainer();
        BetaTransaction tx = (BetaTransaction)transactionContainer.transaction;
        if (tx == null || !tx.isAlive()) {
            tx = null;
        }
        try {
            switch (this.propagationLevel) {
                case Requires: {
                    if (tx == null) {
                        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                            logger.info(String.format("[%s] Has 'Requires' propagation level and no transaction found, starting a new transaction", this.transactionConfiguration.familyName));
                        }
                        tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                        transactionContainer.transaction = tx;
                        this.execute(tx, transactionContainer, closure);
                        return;
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Requires' propagation level, and existing transaction [%s] found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    closure.execute(tx);
                    return;
                }
                case Mandatory: {
                    if (tx == null) {
                        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                            logger.info(String.format("[%s] Has 'Mandatory' propagation level, and no transaction is found", this.transactionConfiguration.familyName));
                        }
                        throw new TransactionRequiredException(String.format("No transaction is found for atomicblock '%s' with 'Mandatory' propagation level", this.transactionConfiguration.familyName));
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Mandatory' propagation level and transaction [%s] found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    closure.execute(tx);
                    return;
                }
                case Never: {
                    if (tx != null) {
                        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                            logger.info(String.format("[%s] Has 'Never' propagation level, but transaction [%s] is found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        }
                        throw new TransactionNotAllowedException(String.format("No transaction is allowed for atomicblock '%s' with propagation level 'Never', but transaction '%s' was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'Never' propagation level and no transaction is found", this.transactionConfiguration.familyName));
                    }
                    closure.execute(null);
                    return;
                }
                case RequiresNew: {
                    if (tx == null) {
                        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                            logger.info(String.format("[%s] Has 'RequiresNew' propagation level and no transaction is found, starting new transaction", this.transactionConfiguration.familyName));
                        }
                        tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                        transactionContainer.transaction = tx;
                        this.execute(tx, transactionContainer, closure);
                        return;
                    }
                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                        logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                    }
                    BetaTransaction suspendedTransaction = tx;
                    tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
                    transactionContainer.transaction = tx;
                    try {
                        this.execute(tx, transactionContainer, closure);
                        return;
                    }
                    finally {
                        transactionContainer.transaction = suspendedTransaction;
                    }
                }
                case Supports: {
                    if (___TracingEnabled) {
                        if (tx != null) {
                            if (this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                            }
                        } else if (this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                            logger.info(String.format("[%s] Has 'RequiresNew' propagationLevel and existing transaction [%s] was found", this.transactionConfiguration.familyName, tx.getConfiguration().getFamilyName()));
                        }
                    }
                    closure.execute(tx);
                    return;
                }
            }
            throw new IllegalStateException();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(BetaTransaction tx, ThreadLocalTransaction.Container transactionContainer, AtomicVoidClosure closure) throws Exception {
        try {
            boolean abort = true;
            while (true) {
                block17: {
                    TransactionSensor sensor;
                    try {
                        closure.execute(tx);
                        tx.commit();
                        abort = false;
                        if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                            sensor.signalExecution(tx.getAttempt(), !abort);
                        }
                        if (!abort) break block17;
                    }
                    catch (Retry e) {
                        block18: {
                            try {
                                abort = false;
                                if (!___TracingEnabled || !this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) continue;
                                logger.info(String.format("[%s] Encountered a retry", this.transactionConfiguration.familyName));
                                continue;
                                catch (SpeculativeConfigurationError e2) {
                                    abort = false;
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a speculative configuration error", this.transactionConfiguration.familyName));
                                    }
                                    BetaTransaction old = tx;
                                    tx = this.transactionFactory.upgradeAfterSpeculativeFailure(tx, transactionContainer.transactionPool);
                                    transactionContainer.transactionPool.putBetaTransaction(old);
                                    transactionContainer.transaction = tx;
                                    continue;
                                }
                                catch (ReadWriteConflict e3) {
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a read or write conflict", this.transactionConfiguration.familyName));
                                    }
                                    this.backoffPolicy.delayedUninterruptible(tx.getAttempt());
                                }
                                if (tx.softReset()) continue;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (!abort) break block18;
                            }
                            catch (Throwable throwable) {
                                TransactionSensor sensor2;
                                if (___ProfilingEnabled && (sensor2 = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor2.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (abort) {
                                    tx.abort();
                                }
                                transactionContainer.transactionPool.putBetaTransaction(tx);
                                transactionContainer.transaction = null;
                                throw throwable;
                            }
                            tx.abort();
                        }
                        transactionContainer.transactionPool.putBetaTransaction(tx);
                        transactionContainer.transaction = null;
                        break;
                    }
                    tx.abort();
                }
                transactionContainer.transactionPool.putBetaTransaction(tx);
                transactionContainer.transaction = null;
                return;
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
            logger.info(String.format("[%s] Too many retries, a maximum of %s is allowed", this.transactionConfiguration.familyName, this.transactionConfiguration.getMaxRetries()));
        }
        throw new TooManyRetriesException(String.format("[%s] Maximum number of %s retries has been reached", this.transactionConfiguration.getFamilyName(), this.transactionConfiguration.getMaxRetries()));
    }
}

