/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta;

import java.util.logging.Logger;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.closures.AtomicBooleanClosure;
import org.multiverse.api.closures.AtomicClosure;
import org.multiverse.api.closures.AtomicDoubleClosure;
import org.multiverse.api.closures.AtomicIntClosure;
import org.multiverse.api.closures.AtomicLongClosure;
import org.multiverse.api.closures.AtomicVoidClosure;
import org.multiverse.api.exceptions.InvisibleCheckedException;
import org.multiverse.api.exceptions.ReadWriteConflict;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.api.exceptions.SpeculativeConfigurationError;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.sensors.TransactionSensor;
import org.multiverse.stms.beta.AbstractBetaAtomicBlock;
import org.multiverse.stms.beta.BetaTransactionFactory;
import org.multiverse.stms.beta.transactions.BetaTransaction;

public final class LeanBetaAtomicBlock
extends AbstractBetaAtomicBlock {
    private static final Logger logger = Logger.getLogger(LeanBetaAtomicBlock.class.getName());

    public LeanBetaAtomicBlock(BetaTransactionFactory transactionFactory) {
        super(transactionFactory);
    }

    @Override
    public BetaTransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    @Override
    public <E> E executeChecked(AtomicClosure<E> closure) throws Exception {
        try {
            return this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <E> E execute(AtomicClosure<E> closure) {
        if (closure == null) {
            throw new NullPointerException();
        }
        ThreadLocalTransaction.Container transactionContainer = ThreadLocalTransaction.getThreadLocalTransactionContainer();
        BetaTransaction tx = (BetaTransaction)transactionContainer.transaction;
        if (tx == null || !tx.isAlive()) {
            tx = null;
        }
        try {
            if (tx != null && tx.isAlive()) {
                return closure.execute(tx);
            }
            tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
            transactionContainer.transaction = tx;
            boolean abort = true;
            while (true) {
                E e;
                block20: {
                    try {
                        TransactionSensor sensor;
                        E result = closure.execute(tx);
                        tx.commit();
                        abort = false;
                        e = result;
                        if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                            sensor.signalExecution(tx.getAttempt(), !abort);
                        }
                        if (!abort) break block20;
                    }
                    catch (Retry e2) {
                        block21: {
                            try {
                                TransactionSensor sensor;
                                abort = false;
                                if (!___TracingEnabled || !this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) continue;
                                logger.info(String.format("[%s] Encountered a retry", this.transactionConfiguration.familyName));
                                continue;
                                catch (SpeculativeConfigurationError e3) {
                                    abort = false;
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a speculative configuration error", this.transactionConfiguration.familyName));
                                    }
                                    BetaTransaction old = tx;
                                    tx = this.transactionFactory.upgradeAfterSpeculativeFailure(tx, transactionContainer.transactionPool);
                                    transactionContainer.transactionPool.putBetaTransaction(old);
                                    transactionContainer.transaction = tx;
                                    continue;
                                }
                                catch (ReadWriteConflict e4) {
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a read or write conflict", this.transactionConfiguration.familyName));
                                    }
                                    this.backoffPolicy.delayedUninterruptible(tx.getAttempt());
                                }
                                if (tx.softReset()) continue;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (!abort) break block21;
                            }
                            catch (Throwable throwable) {
                                TransactionSensor sensor;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (abort) {
                                    tx.abort();
                                }
                                transactionContainer.transactionPool.putBetaTransaction(tx);
                                transactionContainer.transaction = null;
                                throw throwable;
                            }
                            tx.abort();
                        }
                        transactionContainer.transactionPool.putBetaTransaction(tx);
                        transactionContainer.transaction = null;
                        break;
                    }
                    tx.abort();
                }
                transactionContainer.transactionPool.putBetaTransaction(tx);
                transactionContainer.transaction = null;
                return e;
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
            logger.info(String.format("[%s] Too many retries, a maximum of %s is allowed", this.transactionConfiguration.familyName, this.transactionConfiguration.getMaxRetries()));
        }
        throw new TooManyRetriesException(String.format("[%s] Maximum number of %s retries has been reached", this.transactionConfiguration.getFamilyName(), this.transactionConfiguration.getMaxRetries()));
    }

    @Override
    public int executeChecked(AtomicIntClosure closure) throws Exception {
        try {
            return this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(AtomicIntClosure closure) {
        if (closure == null) {
            throw new NullPointerException();
        }
        ThreadLocalTransaction.Container transactionContainer = ThreadLocalTransaction.getThreadLocalTransactionContainer();
        BetaTransaction tx = (BetaTransaction)transactionContainer.transaction;
        if (tx == null || !tx.isAlive()) {
            tx = null;
        }
        try {
            if (tx != null && tx.isAlive()) {
                return closure.execute(tx);
            }
            tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
            transactionContainer.transaction = tx;
            boolean abort = true;
            while (true) {
                int n;
                block20: {
                    try {
                        TransactionSensor sensor;
                        int result = closure.execute(tx);
                        tx.commit();
                        abort = false;
                        n = result;
                        if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                            sensor.signalExecution(tx.getAttempt(), !abort);
                        }
                        if (!abort) break block20;
                    }
                    catch (Retry e) {
                        block21: {
                            try {
                                TransactionSensor sensor;
                                abort = false;
                                if (!___TracingEnabled || !this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) continue;
                                logger.info(String.format("[%s] Encountered a retry", this.transactionConfiguration.familyName));
                                continue;
                                catch (SpeculativeConfigurationError e2) {
                                    abort = false;
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a speculative configuration error", this.transactionConfiguration.familyName));
                                    }
                                    BetaTransaction old = tx;
                                    tx = this.transactionFactory.upgradeAfterSpeculativeFailure(tx, transactionContainer.transactionPool);
                                    transactionContainer.transactionPool.putBetaTransaction(old);
                                    transactionContainer.transaction = tx;
                                    continue;
                                }
                                catch (ReadWriteConflict e3) {
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a read or write conflict", this.transactionConfiguration.familyName));
                                    }
                                    this.backoffPolicy.delayedUninterruptible(tx.getAttempt());
                                }
                                if (tx.softReset()) continue;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (!abort) break block21;
                            }
                            catch (Throwable throwable) {
                                TransactionSensor sensor;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (abort) {
                                    tx.abort();
                                }
                                transactionContainer.transactionPool.putBetaTransaction(tx);
                                transactionContainer.transaction = null;
                                throw throwable;
                            }
                            tx.abort();
                        }
                        transactionContainer.transactionPool.putBetaTransaction(tx);
                        transactionContainer.transaction = null;
                        break;
                    }
                    tx.abort();
                }
                transactionContainer.transactionPool.putBetaTransaction(tx);
                transactionContainer.transaction = null;
                return n;
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
            logger.info(String.format("[%s] Too many retries, a maximum of %s is allowed", this.transactionConfiguration.familyName, this.transactionConfiguration.getMaxRetries()));
        }
        throw new TooManyRetriesException(String.format("[%s] Maximum number of %s retries has been reached", this.transactionConfiguration.getFamilyName(), this.transactionConfiguration.getMaxRetries()));
    }

    @Override
    public long executeChecked(AtomicLongClosure closure) throws Exception {
        try {
            return this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long execute(AtomicLongClosure closure) {
        if (closure == null) {
            throw new NullPointerException();
        }
        ThreadLocalTransaction.Container transactionContainer = ThreadLocalTransaction.getThreadLocalTransactionContainer();
        BetaTransaction tx = (BetaTransaction)transactionContainer.transaction;
        if (tx == null || !tx.isAlive()) {
            tx = null;
        }
        try {
            if (tx != null && tx.isAlive()) {
                return closure.execute(tx);
            }
            tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
            transactionContainer.transaction = tx;
            boolean abort = true;
            while (true) {
                long l;
                block20: {
                    try {
                        TransactionSensor sensor;
                        long result = closure.execute(tx);
                        tx.commit();
                        abort = false;
                        l = result;
                        if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                            sensor.signalExecution(tx.getAttempt(), !abort);
                        }
                        if (!abort) break block20;
                    }
                    catch (Retry e) {
                        block21: {
                            try {
                                TransactionSensor sensor;
                                abort = false;
                                if (!___TracingEnabled || !this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) continue;
                                logger.info(String.format("[%s] Encountered a retry", this.transactionConfiguration.familyName));
                                continue;
                                catch (SpeculativeConfigurationError e2) {
                                    abort = false;
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a speculative configuration error", this.transactionConfiguration.familyName));
                                    }
                                    BetaTransaction old = tx;
                                    tx = this.transactionFactory.upgradeAfterSpeculativeFailure(tx, transactionContainer.transactionPool);
                                    transactionContainer.transactionPool.putBetaTransaction(old);
                                    transactionContainer.transaction = tx;
                                    continue;
                                }
                                catch (ReadWriteConflict e3) {
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a read or write conflict", this.transactionConfiguration.familyName));
                                    }
                                    this.backoffPolicy.delayedUninterruptible(tx.getAttempt());
                                }
                                if (tx.softReset()) continue;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (!abort) break block21;
                            }
                            catch (Throwable throwable) {
                                TransactionSensor sensor;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (abort) {
                                    tx.abort();
                                }
                                transactionContainer.transactionPool.putBetaTransaction(tx);
                                transactionContainer.transaction = null;
                                throw throwable;
                            }
                            tx.abort();
                        }
                        transactionContainer.transactionPool.putBetaTransaction(tx);
                        transactionContainer.transaction = null;
                        break;
                    }
                    tx.abort();
                }
                transactionContainer.transactionPool.putBetaTransaction(tx);
                transactionContainer.transaction = null;
                return l;
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
            logger.info(String.format("[%s] Too many retries, a maximum of %s is allowed", this.transactionConfiguration.familyName, this.transactionConfiguration.getMaxRetries()));
        }
        throw new TooManyRetriesException(String.format("[%s] Maximum number of %s retries has been reached", this.transactionConfiguration.getFamilyName(), this.transactionConfiguration.getMaxRetries()));
    }

    @Override
    public double executeChecked(AtomicDoubleClosure closure) throws Exception {
        try {
            return this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public double execute(AtomicDoubleClosure closure) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean executeChecked(AtomicBooleanClosure closure) throws Exception {
        try {
            return this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(AtomicBooleanClosure closure) {
        if (closure == null) {
            throw new NullPointerException();
        }
        ThreadLocalTransaction.Container transactionContainer = ThreadLocalTransaction.getThreadLocalTransactionContainer();
        BetaTransaction tx = (BetaTransaction)transactionContainer.transaction;
        if (tx == null || !tx.isAlive()) {
            tx = null;
        }
        try {
            if (tx != null && tx.isAlive()) {
                return closure.execute(tx);
            }
            tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
            transactionContainer.transaction = tx;
            boolean abort = true;
            while (true) {
                boolean bl;
                block20: {
                    try {
                        TransactionSensor sensor;
                        boolean result = closure.execute(tx);
                        tx.commit();
                        abort = false;
                        bl = result;
                        if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                            sensor.signalExecution(tx.getAttempt(), !abort);
                        }
                        if (!abort) break block20;
                    }
                    catch (Retry e) {
                        block21: {
                            try {
                                TransactionSensor sensor;
                                abort = false;
                                if (!___TracingEnabled || !this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) continue;
                                logger.info(String.format("[%s] Encountered a retry", this.transactionConfiguration.familyName));
                                continue;
                                catch (SpeculativeConfigurationError e2) {
                                    abort = false;
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a speculative configuration error", this.transactionConfiguration.familyName));
                                    }
                                    BetaTransaction old = tx;
                                    tx = this.transactionFactory.upgradeAfterSpeculativeFailure(tx, transactionContainer.transactionPool);
                                    transactionContainer.transactionPool.putBetaTransaction(old);
                                    transactionContainer.transaction = tx;
                                    continue;
                                }
                                catch (ReadWriteConflict e3) {
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a read or write conflict", this.transactionConfiguration.familyName));
                                    }
                                    this.backoffPolicy.delayedUninterruptible(tx.getAttempt());
                                }
                                if (tx.softReset()) continue;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (!abort) break block21;
                            }
                            catch (Throwable throwable) {
                                TransactionSensor sensor;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (abort) {
                                    tx.abort();
                                }
                                transactionContainer.transactionPool.putBetaTransaction(tx);
                                transactionContainer.transaction = null;
                                throw throwable;
                            }
                            tx.abort();
                        }
                        transactionContainer.transactionPool.putBetaTransaction(tx);
                        transactionContainer.transaction = null;
                        break;
                    }
                    tx.abort();
                }
                transactionContainer.transactionPool.putBetaTransaction(tx);
                transactionContainer.transaction = null;
                return bl;
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
            logger.info(String.format("[%s] Too many retries, a maximum of %s is allowed", this.transactionConfiguration.familyName, this.transactionConfiguration.getMaxRetries()));
        }
        throw new TooManyRetriesException(String.format("[%s] Maximum number of %s retries has been reached", this.transactionConfiguration.getFamilyName(), this.transactionConfiguration.getMaxRetries()));
    }

    @Override
    public void executeChecked(AtomicVoidClosure closure) throws Exception {
        try {
            this.execute(closure);
        }
        catch (InvisibleCheckedException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(AtomicVoidClosure closure) {
        if (closure == null) {
            throw new NullPointerException();
        }
        ThreadLocalTransaction.Container transactionContainer = ThreadLocalTransaction.getThreadLocalTransactionContainer();
        BetaTransaction tx = (BetaTransaction)transactionContainer.transaction;
        if (tx == null || !tx.isAlive()) {
            tx = null;
        }
        try {
            if (tx != null && tx.isAlive()) {
                closure.execute(tx);
                return;
            }
            tx = this.transactionFactory.newTransaction(transactionContainer.transactionPool);
            transactionContainer.transaction = tx;
            boolean abort = true;
            while (true) {
                block20: {
                    TransactionSensor sensor;
                    try {
                        closure.execute(tx);
                        tx.commit();
                        abort = false;
                        if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                            sensor.signalExecution(tx.getAttempt(), !abort);
                        }
                        if (!abort) break block20;
                    }
                    catch (Retry e) {
                        block21: {
                            try {
                                abort = false;
                                if (!___TracingEnabled || !this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) continue;
                                logger.info(String.format("[%s] Encountered a retry", this.transactionConfiguration.familyName));
                                continue;
                                catch (SpeculativeConfigurationError e2) {
                                    abort = false;
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a speculative configuration error", this.transactionConfiguration.familyName));
                                    }
                                    BetaTransaction old = tx;
                                    tx = this.transactionFactory.upgradeAfterSpeculativeFailure(tx, transactionContainer.transactionPool);
                                    transactionContainer.transactionPool.putBetaTransaction(old);
                                    transactionContainer.transaction = tx;
                                    continue;
                                }
                                catch (ReadWriteConflict e3) {
                                    if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
                                        logger.info(String.format("[%s] Encountered a read or write conflict", this.transactionConfiguration.familyName));
                                    }
                                    this.backoffPolicy.delayedUninterruptible(tx.getAttempt());
                                }
                                if (tx.softReset()) continue;
                                if (___ProfilingEnabled && (sensor = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (!abort) break block21;
                            }
                            catch (Throwable throwable) {
                                TransactionSensor sensor2;
                                if (___ProfilingEnabled && (sensor2 = this.transactionConfiguration.transactionSensor) != null) {
                                    sensor2.signalExecution(tx.getAttempt(), !abort);
                                }
                                if (abort) {
                                    tx.abort();
                                }
                                transactionContainer.transactionPool.putBetaTransaction(tx);
                                transactionContainer.transaction = null;
                                throw throwable;
                            }
                            tx.abort();
                        }
                        transactionContainer.transactionPool.putBetaTransaction(tx);
                        transactionContainer.transaction = null;
                        break;
                    }
                    tx.abort();
                }
                transactionContainer.transactionPool.putBetaTransaction(tx);
                transactionContainer.transaction = null;
                return;
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvisibleCheckedException(e);
        }
        if (___TracingEnabled && this.transactionConfiguration.getTraceLevel().isLogableFrom(TraceLevel.Course)) {
            logger.info(String.format("[%s] Too many retries, a maximum of %s is allowed", this.transactionConfiguration.familyName, this.transactionConfiguration.getMaxRetries()));
        }
        throw new TooManyRetriesException(String.format("[%s] Maximum number of %s retries has been reached", this.transactionConfiguration.getFamilyName(), this.transactionConfiguration.getMaxRetries()));
    }
}

