/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactions;

import org.multiverse.stms.beta.transactions.BetaTransaction;
import org.multiverse.stms.beta.transactions.FatArrayBetaTransaction;
import org.multiverse.stms.beta.transactions.FatArrayTreeBetaTransaction;
import org.multiverse.stms.beta.transactions.FatMonoBetaTransaction;
import org.multiverse.stms.beta.transactions.LeanArrayBetaTransaction;
import org.multiverse.stms.beta.transactions.LeanArrayTreeBetaTransaction;
import org.multiverse.stms.beta.transactions.LeanMonoBetaTransaction;

public final class BetaTransactionPool {
    private static final boolean ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm,beta.transactions.BetaTransactionPool.enabled", "true"));
    private final boolean enabled;
    private final LeanMonoBetaTransaction[] poolLeanMonoBetaTransaction = new LeanMonoBetaTransaction[10];
    private int poolLeanMonoBetaTransactionIndex = -1;
    private final FatMonoBetaTransaction[] poolFatMonoBetaTransaction = new FatMonoBetaTransaction[10];
    private int poolFatMonoBetaTransactionIndex = -1;
    private final LeanArrayBetaTransaction[] poolLeanArrayBetaTransaction = new LeanArrayBetaTransaction[10];
    private int poolLeanArrayBetaTransactionIndex = -1;
    private final FatArrayBetaTransaction[] poolFatArrayBetaTransaction = new FatArrayBetaTransaction[10];
    private int poolFatArrayBetaTransactionIndex = -1;
    private final LeanArrayTreeBetaTransaction[] poolLeanArrayTreeBetaTransaction = new LeanArrayTreeBetaTransaction[10];
    private int poolLeanArrayTreeBetaTransactionIndex = -1;
    private final FatArrayTreeBetaTransaction[] poolFatArrayTreeBetaTransaction = new FatArrayTreeBetaTransaction[10];
    private int poolFatArrayTreeBetaTransactionIndex = -1;

    public BetaTransactionPool() {
        this.enabled = ENABLED;
    }

    public LeanMonoBetaTransaction takeLeanMonoBetaTransaction() {
        if (!this.enabled || this.poolLeanMonoBetaTransactionIndex == -1) {
            return null;
        }
        LeanMonoBetaTransaction tx = this.poolLeanMonoBetaTransaction[this.poolLeanMonoBetaTransactionIndex];
        this.poolLeanMonoBetaTransaction[this.poolLeanMonoBetaTransactionIndex] = null;
        --this.poolLeanMonoBetaTransactionIndex;
        return tx;
    }

    public FatMonoBetaTransaction takeFatMonoBetaTransaction() {
        if (!this.enabled || this.poolFatMonoBetaTransactionIndex == -1) {
            return null;
        }
        FatMonoBetaTransaction tx = this.poolFatMonoBetaTransaction[this.poolFatMonoBetaTransactionIndex];
        this.poolFatMonoBetaTransaction[this.poolFatMonoBetaTransactionIndex] = null;
        --this.poolFatMonoBetaTransactionIndex;
        return tx;
    }

    public LeanArrayBetaTransaction takeLeanArrayBetaTransaction() {
        if (!this.enabled || this.poolLeanArrayBetaTransactionIndex == -1) {
            return null;
        }
        LeanArrayBetaTransaction tx = this.poolLeanArrayBetaTransaction[this.poolLeanArrayBetaTransactionIndex];
        this.poolLeanArrayBetaTransaction[this.poolLeanArrayBetaTransactionIndex] = null;
        --this.poolLeanArrayBetaTransactionIndex;
        return tx;
    }

    public FatArrayBetaTransaction takeFatArrayBetaTransaction() {
        if (!this.enabled || this.poolFatArrayBetaTransactionIndex == -1) {
            return null;
        }
        FatArrayBetaTransaction tx = this.poolFatArrayBetaTransaction[this.poolFatArrayBetaTransactionIndex];
        this.poolFatArrayBetaTransaction[this.poolFatArrayBetaTransactionIndex] = null;
        --this.poolFatArrayBetaTransactionIndex;
        return tx;
    }

    public LeanArrayTreeBetaTransaction takeLeanArrayTreeBetaTransaction() {
        if (!this.enabled || this.poolLeanArrayTreeBetaTransactionIndex == -1) {
            return null;
        }
        LeanArrayTreeBetaTransaction tx = this.poolLeanArrayTreeBetaTransaction[this.poolLeanArrayTreeBetaTransactionIndex];
        this.poolLeanArrayTreeBetaTransaction[this.poolLeanArrayTreeBetaTransactionIndex] = null;
        --this.poolLeanArrayTreeBetaTransactionIndex;
        return tx;
    }

    public FatArrayTreeBetaTransaction takeFatArrayTreeBetaTransaction() {
        if (!this.enabled || this.poolFatArrayTreeBetaTransactionIndex == -1) {
            return null;
        }
        FatArrayTreeBetaTransaction tx = this.poolFatArrayTreeBetaTransaction[this.poolFatArrayTreeBetaTransactionIndex];
        this.poolFatArrayTreeBetaTransaction[this.poolFatArrayTreeBetaTransactionIndex] = null;
        --this.poolFatArrayTreeBetaTransactionIndex;
        return tx;
    }

    public void putBetaTransaction(BetaTransaction tx) {
        if (!this.enabled) {
            return;
        }
        if (tx == null) {
            throw new NullPointerException();
        }
        switch (tx.getPoolTransactionType()) {
            case 0: {
                if (this.poolLeanMonoBetaTransactionIndex == this.poolLeanMonoBetaTransaction.length - 1) {
                    return;
                }
                ++this.poolLeanMonoBetaTransactionIndex;
                this.poolLeanMonoBetaTransaction[this.poolLeanMonoBetaTransactionIndex] = (LeanMonoBetaTransaction)tx;
                break;
            }
            case 1: {
                if (this.poolFatMonoBetaTransactionIndex == this.poolFatMonoBetaTransaction.length - 1) {
                    return;
                }
                ++this.poolFatMonoBetaTransactionIndex;
                this.poolFatMonoBetaTransaction[this.poolFatMonoBetaTransactionIndex] = (FatMonoBetaTransaction)tx;
                break;
            }
            case 2: {
                if (this.poolLeanArrayBetaTransactionIndex == this.poolLeanArrayBetaTransaction.length - 1) {
                    return;
                }
                ++this.poolLeanArrayBetaTransactionIndex;
                this.poolLeanArrayBetaTransaction[this.poolLeanArrayBetaTransactionIndex] = (LeanArrayBetaTransaction)tx;
                break;
            }
            case 3: {
                if (this.poolFatArrayBetaTransactionIndex == this.poolFatArrayBetaTransaction.length - 1) {
                    return;
                }
                ++this.poolFatArrayBetaTransactionIndex;
                this.poolFatArrayBetaTransaction[this.poolFatArrayBetaTransactionIndex] = (FatArrayBetaTransaction)tx;
                break;
            }
            case 4: {
                if (this.poolLeanArrayTreeBetaTransactionIndex == this.poolLeanArrayTreeBetaTransaction.length - 1) {
                    return;
                }
                ++this.poolLeanArrayTreeBetaTransactionIndex;
                this.poolLeanArrayTreeBetaTransaction[this.poolLeanArrayTreeBetaTransactionIndex] = (LeanArrayTreeBetaTransaction)tx;
                break;
            }
            case 5: {
                if (this.poolFatArrayTreeBetaTransactionIndex == this.poolFatArrayTreeBetaTransaction.length - 1) {
                    return;
                }
                ++this.poolFatArrayTreeBetaTransactionIndex;
                this.poolFatArrayTreeBetaTransaction[this.poolFatArrayTreeBetaTransactionIndex] = (FatArrayTreeBetaTransaction)tx;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

