/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf;

import java.util.Optional;
import java.util.function.Consumer;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;

@FunctionalInterface
public interface TemplateEngineCustomizer
extends Consumer<TemplateEngine> {
    @Override
    default public void accept(TemplateEngine templateEngine) {
        this.customize(templateEngine);
    }

    public void customize(TemplateEngine var1);

    public static <T extends ITemplateResolver> Optional<T> extractTemplateResolver(TemplateEngine templateEngine, Class<T> type) {
        return templateEngine.getTemplateResolvers().stream().filter(type::isInstance).map(type::cast).findFirst();
    }

    public static enum BuiltIn implements TemplateEngineCustomizer
    {
        DO_NOTHING{

            @Override
            public void customize(TemplateEngine defaultTemplateEngine) {
            }
        };

    }
}

