/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf.processor;

import java.lang.reflect.Array;
import java.util.Collection;
import org.mybatis.scripting.thymeleaf.MyBatisBindingContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.EngineEventUtils;
import org.thymeleaf.engine.IterationStatusVar;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.templatemode.TemplateMode;

public class MyBatisParamTagProcessor
extends AbstractAttributeTagProcessor {
    private static final int PRECEDENCE = 1400;
    private static final String ATTR_NAME = "p";
    private final StandardExpressionExecutionContext expressionExecutionContext;

    public MyBatisParamTagProcessor(TemplateMode templateMode, String prefix) {
        super(templateMode, prefix, null, false, ATTR_NAME, true, 1400, true);
        this.expressionExecutionContext = templateMode == TemplateMode.TEXT ? StandardExpressionExecutionContext.RESTRICTED : StandardExpressionExecutionContext.NORMAL;
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        String body;
        Pair parameterAndOptionPair = Pair.parse(attributeValue, ',');
        String parameterPath = parameterAndOptionPair.left;
        String options = parameterAndOptionPair.right;
        Pair objectNameAndPropertyPathPair = Pair.parse(parameterPath, '.');
        String objectName = objectNameAndPropertyPathPair.left;
        String nestedPropertyPath = objectNameAndPropertyPathPair.right;
        String iterationObjectName = objectName + "Stat";
        if (context.containsVariable(iterationObjectName)) {
            Object value;
            IterationStatusVar iterationStatus;
            String iterationObjectVariableName;
            MyBatisBindingContext bindingContext = MyBatisBindingContext.load((IContext)context);
            if (!bindingContext.containsCustomBindVariable(iterationObjectVariableName = bindingContext.generateUniqueName(objectName, iterationStatus = (IterationStatusVar)context.getVariable(iterationObjectName)))) {
                bindingContext.setCustomBindVariable(iterationObjectVariableName, iterationStatus.getCurrent());
            }
            body = nestedPropertyPath.isEmpty() ? "#{" + iterationObjectVariableName + options + "}" : (this.isCollectionOrArray(value = this.getExpressionEvaluatedValue(context, tag, attributeName, parameterPath)) ? this.generateCollectionBindVariables(value, iterationObjectVariableName + nestedPropertyPath, options) : "#{" + iterationObjectVariableName + nestedPropertyPath + options + "}");
        } else {
            Object value = nestedPropertyPath.isEmpty() ? context.getVariable(objectName) : this.getExpressionEvaluatedValue(context, tag, attributeName, parameterPath);
            body = this.isCollectionOrArray(value) ? this.generateCollectionBindVariables(value, parameterPath, options) : "#{" + attributeValue + "}";
        }
        structureHandler.setBody((CharSequence)body, false);
    }

    private Object getExpressionEvaluatedValue(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String parameterValue) {
        IStandardExpression expression = EngineEventUtils.computeAttributeExpression((ITemplateContext)context, (IProcessableElementTag)tag, (AttributeName)attributeName, (String)("${" + parameterValue + "}"));
        return expression.execute((IExpressionContext)context, this.expressionExecutionContext);
    }

    private boolean isCollectionOrArray(Object value) {
        return value != null && (Collection.class.isAssignableFrom(value.getClass()) || value.getClass().isArray());
    }

    private String generateCollectionBindVariables(Object value, String parameterPath, String options) {
        int size;
        int n = size = value.getClass().isArray() ? Array.getLength(value) : ((Collection)value).size();
        if (size == 0) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("#{").append(parameterPath).append("[").append(i).append("]").append(options).append("}");
        }
        return sb.toString();
    }

    private static class Pair {
        private final String left;
        private final String right;

        private Pair(String left, String right) {
            this.left = left;
            this.right = right;
        }

        private static Pair parse(String value, char separator) {
            String right;
            String left;
            int separatorIndex = value.indexOf(separator);
            if (separatorIndex == -1) {
                left = value;
                right = "";
            } else {
                left = value.substring(0, separatorIndex);
                right = value.substring(separatorIndex);
            }
            return new Pair(left, right);
        }
    }
}

