/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.planner.logical.steps;

import org.neo4j.cypher.internal.compiler.v3_3.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.v3_3.planner.logical.PlanTransformer;
import org.neo4j.cypher.internal.compiler.v3_3.spi.PlanContext;
import org.neo4j.cypher.internal.frontend.v3_3.HintException;
import org.neo4j.cypher.internal.frontend.v3_3.HintException$;
import org.neo4j.cypher.internal.frontend.v3_3.IndexHintException;
import org.neo4j.cypher.internal.frontend.v3_3.InternalException;
import org.neo4j.cypher.internal.frontend.v3_3.InternalException$;
import org.neo4j.cypher.internal.frontend.v3_3.JoinHintException;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Hint;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_3.ast.PropertyKeyName;
import org.neo4j.cypher.internal.frontend.v3_3.ast.UsingIndexHint;
import org.neo4j.cypher.internal.frontend.v3_3.ast.UsingJoinHint;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_3.notification.IndexHintUnfulfillableNotification;
import org.neo4j.cypher.internal.frontend.v3_3.notification.InternalNotification;
import org.neo4j.cypher.internal.frontend.v3_3.notification.JoinHintUnfulfillableNotification;
import org.neo4j.cypher.internal.ir.v3_3.PlannerQuery;
import org.neo4j.cypher.internal.v3_3.logical.plans.LogicalPlan;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class verifyBestPlan$
implements PlanTransformer<PlannerQuery> {
    public static final verifyBestPlan$ MODULE$;

    static {
        new verifyBestPlan$();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LogicalPlan apply(LogicalPlan plan2, PlannerQuery expected, LogicalPlanningContext context) {
        PlannerQuery expectedWithoutHints;
        PlannerQuery constructed = plan2.solved();
        PlannerQuery plannerQuery = expected;
        PlannerQuery plannerQuery2 = constructed;
        if (!(plannerQuery == null ? plannerQuery2 != null : !plannerQuery.equals(plannerQuery2))) return plan2;
        Seq<UsingIndexHint> unfulfillableIndexHints = this.findUnfulfillableIndexHints(expected, context.planContext());
        Seq<UsingJoinHint> unfulfillableJoinHints = this.findUnfulfillableJoinHints(expected, context.planContext());
        PlannerQuery plannerQuery3 = expectedWithoutHints = expected.withoutHints((GenSeq)unfulfillableIndexHints.$plus$plus(unfulfillableJoinHints, Seq$.MODULE$.canBuildFrom()));
        PlannerQuery plannerQuery4 = constructed;
        if (!(plannerQuery3 != null ? !plannerQuery3.equals(plannerQuery4) : plannerQuery4 != null)) {
            this.processUnfulfilledIndexHints(context, unfulfillableIndexHints);
            this.processUnfulfilledJoinHints(context, unfulfillableJoinHints);
            return plan2;
        } else {
            PlannerQuery a = expected.withoutHints((GenSeq)expected.allHints());
            PlannerQuery b = constructed.withoutHints((GenSeq)constructed.allHints());
            PlannerQuery plannerQuery5 = a;
            PlannerQuery plannerQuery6 = b;
            if (plannerQuery5 != null ? !plannerQuery5.equals(plannerQuery6) : plannerQuery6 != null) void var4_4;
            throw new InternalException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected \\n", " \\n\\n\\nInstead, got: \\n", "\\nPlan: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, var4_4, plan2})), InternalException$.MODULE$.$lessinit$greater$default$2());
            Seq expectedHints = expected.allHints();
            Seq actualHints = constructed.allHints();
            Seq missing = (Seq)expectedHints.diff((GenSeq)actualHints);
            Seq solvedInAddition = (Seq)actualHints.diff((GenSeq)expectedHints);
            boolean inventedHintsAndThenSolvedThem = solvedInAddition.exists((Function1)new Serializable(expectedHints){
                public static final long serialVersionUID = 0L;
                private final Seq expectedHints$1;

                public final boolean apply(Hint x$1) {
                    return !this.expectedHints$1.contains((Object)x$1);
                }
                {
                    this.expectedHints$1 = expectedHints$1;
                }
            });
            if (!missing.nonEmpty() && !inventedHintsAndThenSolvedThem) return plan2;
            String details = missing.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected:\n                 |", "\n                 |\n               |Instead, got:\n                 |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.out$1(expectedHints), this.out$1(actualHints)})))).stripMargin() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not solve these hints: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.out$1(missing)}));
            String message = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to fulfil the hints of the query.\n                 |", "\n                 |\n               |Plan ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{details, plan2})))).stripMargin();
            throw new HintException(message, HintException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private void processUnfulfilledIndexHints(LogicalPlanningContext context, Seq<UsingIndexHint> hints) {
        if (hints.nonEmpty()) {
            if (context.useErrorsOverWarnings()) {
                UsingIndexHint firstIndexHint = (UsingIndexHint)hints.head();
                throw new IndexHintException(firstIndexHint.variable().name(), firstIndexHint.label().name(), (Seq)firstIndexHint.properties().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(PropertyKeyName x$2) {
                        return x$2.name();
                    }
                }, Seq$.MODULE$.canBuildFrom()), "No such index");
            }
            hints.foreach((Function1)new Serializable(context){
                public static final long serialVersionUID = 0L;
                private final LogicalPlanningContext context$1;

                public final void apply(UsingIndexHint hint) {
                    this.context$1.notificationLogger().log((InternalNotification)new IndexHintUnfulfillableNotification(hint.label().name(), (Seq)hint.properties().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(PropertyKeyName x$3) {
                            return x$3.name();
                        }
                    }, Seq$.MODULE$.canBuildFrom())));
                }
                {
                    this.context$1 = context$1;
                }
            });
        }
    }

    private void processUnfulfilledJoinHints(LogicalPlanningContext context, Seq<UsingJoinHint> hints) {
        if (hints.nonEmpty()) {
            if (context.useErrorsOverWarnings()) {
                UsingJoinHint firstJoinHint = (UsingJoinHint)hints.head();
                throw new JoinHintException((String)firstJoinHint.variables().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Variable x$4) {
                        return x$4.name();
                    }
                }).reduceLeft((Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$5, String x$6) {
                        return new StringBuilder().append((Object)x$5).append((Object)", ").append((Object)x$6).toString();
                    }
                }), "Unable to plan hash join");
            }
            hints.foreach((Function1)new Serializable(context){
                public static final long serialVersionUID = 0L;
                private final LogicalPlanningContext context$2;

                public final void apply(UsingJoinHint hint) {
                    this.context$2.notificationLogger().log((InternalNotification)new JoinHintUnfulfillableNotification(hint.variables().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Variable x$7) {
                            return x$7.name();
                        }
                    }).toIndexedSeq()));
                }
                {
                    this.context$2 = context$2;
                }
            });
        }
    }

    private Seq<UsingIndexHint> findUnfulfillableIndexHints(PlannerQuery query, PlanContext planContext) {
        return (Seq)query.allHints().flatMap((Function1)new Serializable(planContext){
            public static final long serialVersionUID = 0L;
            private final PlanContext planContext$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Iterable<UsingIndexHint> apply(Hint x0$1) {
                boolean bl = false;
                UsingIndexHint usingIndexHint = null;
                Hint hint = x0$1;
                if (hint instanceof UsingIndexHint) {
                    bl = true;
                    usingIndexHint = (UsingIndexHint)hint;
                    LabelName labelName = usingIndexHint.label();
                    Seq properties = usingIndexHint.properties();
                    if (labelName != null) {
                        String label = labelName.name();
                        if (this.planContext$1.indexGet(label, (Seq<String>)((Seq)properties.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(PropertyKeyName x$8) {
                                return x$8.name();
                            }
                        }, Seq$.MODULE$.canBuildFrom()))).isDefined()) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        if (this.planContext$1.uniqueIndexGet(label, (Seq<String>)((Seq)properties.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(PropertyKeyName x$9) {
                                return x$9.name();
                            }
                        }, Seq$.MODULE$.canBuildFrom()))).isDefined()) {
                            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                    }
                }
                if (!bl) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)usingIndexHint));
            }
            {
                this.planContext$1 = planContext$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<UsingJoinHint> findUnfulfillableJoinHints(PlannerQuery query, PlanContext planContext) {
        return (Seq)query.allHints().collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Hint, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof UsingJoinHint) {
                    UsingJoinHint usingJoinHint = (UsingJoinHint)A1;
                    object = usingJoinHint;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Hint x1) {
                Hint hint = x1;
                boolean bl = hint instanceof UsingJoinHint;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final String out$1(Seq h) {
        return h.mkString("`", ", ", "`");
    }

    private verifyBestPlan$() {
        MODULE$ = this;
    }
}

