/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.shiro;

import java.io.Reader;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.nutz.integration.shiro.CaptchaUsernamePasswordToken;
import org.nutz.integration.shiro.NutShiro;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionFilter;
import org.nutz.mvc.View;

public class CaptchaFormAuthenticationFilter
extends FormAuthenticationFilter
implements ActionFilter {
    protected String JsonParams_KEY = "CaptchaFormAuthenticationFilter_JsonParams";
    private String captchaParam = "captcha";

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    public String getCleanParams(ServletRequest request, String name) {
        HttpServletRequest req = (HttpServletRequest)request;
        NutMap jsonParams = (NutMap)req.getAttribute(this.JsonParams_KEY);
        if (jsonParams != null && jsonParams.containsKey((Object)name)) {
            return StringUtils.clean((String)jsonParams.getString(name));
        }
        return WebUtils.getCleanParam((ServletRequest)request, (String)name);
    }

    protected String getCaptcha(ServletRequest request) {
        return this.getCleanParams(request, this.getCaptchaParam());
    }

    protected String getUsername(ServletRequest request) {
        return this.getCleanParams(request, this.getUsernameParam());
    }

    protected String getPassword(ServletRequest request) {
        return this.getCleanParams(request, this.getPasswordParam());
    }

    protected boolean isRememberMe(ServletRequest request) {
        String value = this.getCleanParams(request, this.getRememberMeParam());
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("enabled") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        Object _expected;
        String captcha = this.getCaptcha(request);
        if (Strings.isBlank((CharSequence)captcha)) {
            return this.onCaptchaError(request, response);
        }
        Subject subject = this.getSubject(request, response);
        Session session = subject.getSession(false);
        if (session == null) {
            return this.onCaptchaError(request, response);
        }
        HttpServletRequest req = (HttpServletRequest)request;
        if (req.getHeader("Content-Type") != null && req.getHeader("Content-Type").contains("json")) {
            NutMap jsonParams = (NutMap)Json.fromJson(NutMap.class, (Reader)req.getReader());
            req.setAttribute(this.JsonParams_KEY, (Object)jsonParams);
        }
        if ((_expected = session.getAttribute((Object)this.captchaParam)) == null) {
            _expected = session.getAttribute((Object)"nutz_captcha");
        }
        if (_expected == null) {
            return this.onCaptchaError(request, response);
        }
        if (!captcha.equalsIgnoreCase(String.valueOf(_expected))) {
            return this.onCaptchaError(request, response);
        }
        String username = this.getUsername(request);
        String password = this.getPassword(request);
        boolean rememberMe = this.isRememberMe(request);
        String host = this.getHost(request);
        CaptchaUsernamePasswordToken token = new CaptchaUsernamePasswordToken(username, password, rememberMe, host, captcha);
        try {
            subject.login((AuthenticationToken)token);
            return this.onLoginSuccess((AuthenticationToken)token, subject, request, response);
        }
        catch (AuthenticationException e) {
            return this.onLoginFailure((AuthenticationToken)token, e, request, response);
        }
    }

    protected boolean onCaptchaError(ServletRequest req, ServletResponse resp) {
        if (NutShiro.isAjax(req)) {
            NutMap re = new NutMap().setv("ok", (Object)false).setv("msg", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            NutShiro.rendAjaxResp(req, resp, re);
            return false;
        }
        return super.onLoginFailure(null, new AuthenticationException("\u9a8c\u8bc1\u7801\u9519\u8bef"), req, resp);
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest req, ServletResponse resp) {
        if (NutShiro.isAjax(req)) {
            NutMap re = new NutMap().setv("ok", (Object)false).setv("msg", (Object)"\u767b\u9646\u5931\u8d25");
            NutShiro.rendAjaxResp(req, resp, re);
            return false;
        }
        return super.onLoginFailure(token, e, req, resp);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest req, ServletResponse resp) throws Exception {
        subject.getSession().setAttribute((Object)NutShiro.SessionKey, subject.getPrincipal());
        if (NutShiro.isAjax(req)) {
            NutShiro.rendAjaxResp(req, resp, new NutMap().setv("ok", (Object)true));
            return false;
        }
        return super.onLoginSuccess(token, subject, req, resp);
    }

    public View match(ActionContext ac) {
        HttpServletRequest request = ac.getRequest();
        AuthenticationToken authenticationToken = this.createToken((ServletRequest)request, (ServletResponse)ac.getResponse());
        request.setAttribute("loginToken", (Object)authenticationToken);
        return null;
    }
}

