/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.shiro;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.nutz.json.JsonFormat;
import org.nutz.mvc.view.UTF8JsonView;
import org.nutz.resource.Scans;

public class NutShiro {
    public static String DefaultLoginURL = "/user/login";
    public static String DefaultNoAuthURL;
    public static String SessionKey;
    public static String AjaxEncode;
    public static final String DEFAULT_CAPTCHA_PARAM = "captcha";

    public static boolean isAjax(ServletRequest req) {
        String value = ((HttpServletRequest)req).getHeader("X-Requested-With");
        return value != null && "XMLHttpRequest".equalsIgnoreCase(value.trim());
    }

    public static void rendAjaxResp(ServletRequest req, ServletResponse resp, Object re) {
        try {
            if (AjaxEncode != null) {
                ((HttpServletResponse)resp).setCharacterEncoding(AjaxEncode);
            }
            new UTF8JsonView(JsonFormat.compact()).render((HttpServletRequest)req, (HttpServletResponse)resp, re);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean match(Method method) {
        return method.getAnnotation(RequiresRoles.class) != null || method.getAnnotation(RequiresAuthentication.class) != null || method.getAnnotation(RequiresGuest.class) != null || method.getAnnotation(RequiresPermissions.class) != null || method.getAnnotation(RequiresUser.class) != null;
    }

    public static Set<String>[] scanRolePermissionInPackage(String pkg, boolean publicOnly) {
        HashSet<String> roles = new HashSet<String>();
        HashSet<String> permissions = new HashSet<String>();
        for (Class klass : Scans.me().scanPackage(pkg)) {
            Method[] methods;
            for (Method method : methods = publicOnly ? klass.getMethods() : klass.getDeclaredMethods()) {
                RequiresPermissions pr;
                RequiresRoles rr = method.getAnnotation(RequiresRoles.class);
                if (rr != null && rr.value().length > 0) {
                    for (String role : rr.value()) {
                        roles.add(role);
                    }
                }
                if ((pr = method.getAnnotation(RequiresPermissions.class)) == null || pr.value().length <= 0) continue;
                for (String permission : pr.value()) {
                    permissions.add(permission);
                }
            }
        }
        return new Set[]{roles, permissions};
    }

    static {
        SessionKey = "me";
        AjaxEncode = "UTF-8";
    }
}

