/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.shiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.nutz.integration.shiro.NutShiro;
import org.nutz.integration.shiro.NutShiroInterceptor;
import org.nutz.integration.shiro.NutShiroMethodInterceptor;
import org.nutz.lang.util.NutMap;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.View;
import org.nutz.mvc.impl.processor.AbstractProcessor;
import org.nutz.mvc.view.ServerRedirectView;

public class NutShiroProcessor
extends AbstractProcessor {
    protected NutShiroMethodInterceptor interceptor = new NutShiroMethodInterceptor();
    protected String loginUri;
    protected String noAuthUri;
    protected boolean match;
    protected boolean init;

    public void init(NutConfig config, ActionInfo ai) throws Throwable {
        if (this.init) {
            throw new IllegalStateException("this Processor have bean inited!!");
        }
        super.init(config, ai);
        this.match = NutShiro.match(ai.getMethod());
        this.init = true;
    }

    public void process(ActionContext ac) throws Throwable {
        if (this.match) {
            try {
                this.interceptor.assertAuthorized(new NutShiroInterceptor(ac));
            }
            catch (Exception e) {
                this.whenException(ac, e);
                return;
            }
        }
        this.doNext(ac);
    }

    protected void whenException(ActionContext ac, Exception e) throws Throwable {
        Object val = ac.getRequest().getAttribute("shiro_auth_error");
        if (val != null && val instanceof View) {
            ((View)val).render(ac.getRequest(), ac.getResponse(), null);
            return;
        }
        if (e instanceof UnauthenticatedException) {
            this.whenUnauthenticated(ac, (UnauthenticatedException)e);
        } else if (e instanceof UnauthorizedException) {
            this.whenUnauthorized(ac, (UnauthorizedException)e);
        } else {
            this.whenOtherException(ac, e);
        }
    }

    protected void whenUnauthenticated(ActionContext ac, UnauthenticatedException e) throws Exception {
        if (NutShiro.isAjax((ServletRequest)ac.getRequest())) {
            NutShiro.rendAjaxResp((ServletRequest)ac.getRequest(), (ServletResponse)ac.getResponse(), this.ajaxFail("user.require.login", "user.require.login"));
        } else {
            new ServerRedirectView(this.loginUri()).render(ac.getRequest(), ac.getResponse(), null);
        }
    }

    protected NutMap ajaxFail(String msg, String type) {
        return new NutMap().setv("ok", (Object)false).setv("msg", (Object)msg).setv("type", (Object)type);
    }

    protected void whenUnauthorized(ActionContext ac, UnauthorizedException e) throws Exception {
        if (NutShiro.isAjax((ServletRequest)ac.getRequest())) {
            NutShiro.rendAjaxResp((ServletRequest)ac.getRequest(), (ServletResponse)ac.getResponse(), this.ajaxFail("user.require.auth", "user.require.auth"));
        } else {
            new ServerRedirectView(this.noAuthUri()).render(ac.getRequest(), ac.getResponse(), null);
        }
    }

    protected void whenOtherException(ActionContext ac, Exception e) throws Exception {
        if (NutShiro.isAjax((ServletRequest)ac.getRequest())) {
            NutShiro.rendAjaxResp((ServletRequest)ac.getRequest(), (ServletResponse)ac.getResponse(), this.ajaxFail("user.require.login", "user.require.login"));
        } else {
            new ServerRedirectView(this.loginUri()).render(ac.getRequest(), ac.getResponse(), null);
        }
    }

    protected String loginUri() {
        if (this.loginUri == null) {
            return NutShiro.DefaultLoginURL;
        }
        return this.loginUri;
    }

    protected String noAuthUri() {
        if (this.noAuthUri == null) {
            return NutShiro.DefaultNoAuthURL == null ? NutShiro.DefaultLoginURL : NutShiro.DefaultNoAuthURL;
        }
        return this.noAuthUri;
    }
}

