/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.shiro.realm;

import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.nutz.integration.shiro.realm.NutShiroUserService;
import org.nutz.ioc.Ioc;
import org.nutz.mvc.Mvcs;

public class NutUserServiceRealm
extends AuthorizingRealm {
    protected String ctxName = "nutz";

    public NutUserServiceRealm() {
    }

    public NutUserServiceRealm(CacheManager cacheManager, CredentialsMatcher matcher) {
        super(cacheManager, matcher);
    }

    public NutUserServiceRealm(CacheManager cacheManager) {
        super(cacheManager);
    }

    public NutUserServiceRealm(CredentialsMatcher matcher) {
        super(matcher);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        List<String> permissions;
        if (principals == null) {
            throw new AuthorizationException("PrincipalCollection method argument cannot be null.");
        }
        String username = principals.getPrimaryPrincipal().toString();
        if (!this.us().hasUser(username)) {
            return null;
        }
        if (this.us().isLocked(username)) {
            throw new LockedAccountException("Account [" + username + "] is locked.");
        }
        if (this.us().isCredentialsExpired(username)) {
            String msg = "The credentials for account [" + username + "] are expired";
            throw new ExpiredCredentialsException(msg);
        }
        SimpleAuthorizationInfo auth = new SimpleAuthorizationInfo();
        List<String> roles = this.us().listRoles(username);
        if (roles != null) {
            auth.addRoles(roles);
        }
        if ((permissions = this.us().listPermissions(username)) != null) {
            auth.addStringPermissions(permissions);
        }
        return auth;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        String username = upToken.getUsername();
        if (!this.us().hasUser(username)) {
            return null;
        }
        if (this.us().isLocked(username)) {
            throw new LockedAccountException("Account [" + upToken.getUsername() + "] is locked.");
        }
        if (this.us().isCredentialsExpired(username)) {
            String msg = "The credentials for account [" + username + "] are expired";
            throw new ExpiredCredentialsException(msg);
        }
        String[] ps = this.us().ps(username);
        if (ps == null) {
            return null;
        }
        SimpleAccount account = new SimpleAccount((Object)username, (Object)ps[0], this.getName());
        if (ps.length > 1) {
            account.setCredentialsSalt(ByteSource.Util.bytes((String)ps[1]));
        }
        return account;
    }

    protected NutShiroUserService us() {
        Ioc ioc = (Ioc)Mvcs.ctx().iocs.get(this.ctxName);
        if (ioc == null) {
            ioc = Mvcs.ctx().getDefaultIoc();
        }
        return (NutShiroUserService)ioc.get(NutShiroUserService.class);
    }

    public void setCtxName(String ctxName) {
        this.ctxName = ctxName;
    }
}

