/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.shiro.realm.bean;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.ManyMany;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.integration.shiro.realm.bean.AbstractShiroBean;
import org.nutz.integration.shiro.realm.bean.Permission;
import org.nutz.integration.shiro.realm.bean.Role;

@Table(value="users")
public class User
extends AbstractShiroBean {
    @Column
    private transient String passwd;
    @Column
    private transient String salt;
    @ManyMany(from="uid", relation="user_role", target=Role.class, to="role_id")
    private List<Role> roles;
    @ManyMany(from="uid", relation="user_permission", target=Permission.class, to="permission_id")
    private List<Permission> permissions;

    public User() {
    }

    public User(String name, String passwd, String slat) {
        this.setName(name);
        this.passwd = passwd;
        this.salt = slat;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public Set<String> getRoleStrSet() {
        HashSet<String> roleStrs = new HashSet<String>();
        if (this.roles != null) {
            for (Role role : this.roles) {
                roleStrs.add(role.getName());
            }
        }
        return roleStrs;
    }

    public Set<String> getPermissionStrSet() {
        HashSet<String> permissionStrs = new HashSet<String>();
        if (this.permissions != null) {
            for (Permission permission : this.permissions) {
                permissionStrs.add(permission.getName());
            }
        }
        return permissionStrs;
    }

    public Set<String> getRolePermissionStrSet() {
        HashSet<String> permissionStrs = new HashSet<String>();
        if (this.roles != null) {
            for (Role role : this.roles) {
                if (role.getPermissions() == null) continue;
                for (Permission permission : role.getPermissions()) {
                    permissionStrs.add(permission.getName());
                }
            }
        }
        return permissionStrs;
    }
}

