/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class DevTools
extends HttpBase {
    public DevTools(String security) {
        super(security);
    }

    public String getAliasesOf(String packageName, String regId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to get all aliases of the device."));
            }
            boolean bl = tryAgain = (result = this.getAliasesNoRetry(packageName, regId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not get all aliases of the device after " + attempt + " attempts");
        }
        return result;
    }

    public String getTopicsOf(String packageName, String regId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to get all topics of the device."));
            }
            boolean bl = tryAgain = (result = this.getTopicsNoRetry(packageName, regId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not get all topics of the device after " + attempt + " attempts");
        }
        return result;
    }

    public String getAccountsOf(String packageName, String regId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to get all topics of the device."));
            }
            boolean bl = tryAgain = (result = this.getAccountsNoRetry(packageName, regId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not get all user accounts of the device after " + attempt + " attempts");
        }
        return result;
    }

    protected String getAliasesNoRetry(String packageName, String regId) throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            StringBuilder sb = DevTools.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
            DevTools.addParameter(sb, "registration_id", URLEncoder.encode(regId, "UTF-8"));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("get from: " + Constants.XMPUSH_GET_ALIASES_OF_DEVICE));
            }
            conn = this.doGet(Constants.XMPUSH_GET_ALIASES_OF_DEVICE, sb.toString());
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.warn((Object)"IOException while get from XmPush", (Throwable)e);
            return null;
        }
        if (status / 100 == 5) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("XmPush service is unavailable (status " + status + ")"));
            }
            return null;
        }
        if (status != 200) {
            try {
                responseBody = DevTools.getAndClose(conn.getErrorStream());
                logger.debug((Object)("Plain get error response: " + responseBody));
            }
            catch (IOException e) {
                responseBody = "N/A";
                logger.warn((Object)"Exception reading response: ", (Throwable)e);
            }
            throw new InvalidRequestException(status, responseBody);
        }
        try {
            responseBody = DevTools.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.warn((Object)"Exception reading response: ", (Throwable)e);
            return null;
        }
        return responseBody;
    }

    protected String getTopicsNoRetry(String packageName, String regId) throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            StringBuilder sb = DevTools.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
            DevTools.addParameter(sb, "registration_id", URLEncoder.encode(regId, "UTF-8"));
            logger.info((Object)("get from: " + Constants.XMPUSH_GET_TOPICS_OF_DEVICE));
            conn = this.doGet(Constants.XMPUSH_GET_TOPICS_OF_DEVICE, sb.toString());
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.warn((Object)"IOException while get from XmPush", (Throwable)e);
            return null;
        }
        if (status / 100 == 5) {
            logger.info((Object)("XmPush service is unavailable (status " + status + ")"));
            return null;
        }
        if (status != 200) {
            try {
                responseBody = DevTools.getAndClose(conn.getErrorStream());
                logger.info((Object)("Plain get error response: " + responseBody));
            }
            catch (IOException e) {
                responseBody = "N/A";
                logger.warn((Object)"Exception reading response: ", (Throwable)e);
            }
            throw new InvalidRequestException(status, responseBody);
        }
        try {
            responseBody = DevTools.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.warn((Object)"Exception reading response: ", (Throwable)e);
            return null;
        }
        return responseBody;
    }

    protected String getAccountsNoRetry(String packageName, String regId) throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            StringBuilder sb = DevTools.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
            DevTools.addParameter(sb, "registration_id", URLEncoder.encode(regId, "UTF-8"));
            logger.info((Object)("get from: " + Constants.XMPUSH_GET_ACCOUNTS_OF_DEVICE));
            conn = this.doGet(Constants.XMPUSH_GET_ACCOUNTS_OF_DEVICE, sb.toString());
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.warn((Object)"IOException while get from XmPush", (Throwable)e);
            return null;
        }
        if (status / 100 == 5) {
            logger.info((Object)("XmPush service is unavailable (status " + status + ")"));
            return null;
        }
        if (status != 200) {
            try {
                responseBody = DevTools.getAndClose(conn.getErrorStream());
                logger.debug((Object)("Plain get error response: " + responseBody));
            }
            catch (IOException e) {
                responseBody = "N/A";
                logger.warn((Object)"Exception reading response: ", (Throwable)e);
            }
            throw new InvalidRequestException(status, responseBody);
        }
        try {
            responseBody = DevTools.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.warn((Object)"Exception reading response: ", (Throwable)e);
            return null;
        }
        return responseBody;
    }
}

