/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import java.io.IOException;
import java.net.HttpURLConnection;

public class Feedback
extends HttpBase {
    public Feedback(String security) {
        super(Feedback.nonNull(security));
    }

    public String getInvalidRegIds(int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to get invalid registration ids"));
            }
            boolean bl = tryAgain = (result = this.getInvalidRegIdsNoRetry()) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not get invalid registration ids after " + attempt + " attempts");
        }
        return result;
    }

    protected String getInvalidRegIdsNoRetry() throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            logger.info((Object)("get from: " + Constants.XMPUSH_FETCH_INVALID_REGIDS));
            conn = this.doGet(Constants.XMPUSH_FETCH_INVALID_REGIDS, "");
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.warn((Object)"IOException while get from XmPush", (Throwable)e);
            return null;
        }
        if (status / 100 == 5) {
            logger.info((Object)("XmPush service is unavailable (status " + status + ")"));
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Feedback.getAndClose(conn.getErrorStream());
                logger.debug((Object)("Plain get error response: " + responseBody2));
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.warn((Object)"Exception reading response: ", (Throwable)e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Feedback.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.warn((Object)"Exception reading response: ", (Throwable)e);
            return null;
        }
        return responseBody;
    }
}

