/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Result;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MessageTool
extends HttpBase {
    public MessageTool(String security) {
        super(MessageTool.nonNull(security));
    }

    public Result deleteTopic(String jobId, int retries) throws IOException, ParseException {
        StringBuilder body = MessageTool.newBody("id", URLEncoder.encode(jobId, "UTF-8"));
        return this.sendMessage(Constants.XMPUSH_ENDPOINT_DELETE_TOPIC, body, retries);
    }

    public Result deleteTopic(String jobId) throws IOException, ParseException {
        return this.deleteTopic(jobId, 1);
    }

    protected Result sendMessage(String url, StringBuilder body, int retries) throws IOException, ParseException {
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        boolean tryAgain = false;
        do {
            String bodyStr;
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to send " + body + " to url " + url));
            }
            if ((bodyStr = body.toString()).charAt(0) == '&') {
                bodyStr = body.toString().substring(1);
            }
            boolean bl = tryAgain = (result = this.sendMessage(url, bodyStr)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not  send after " + attempt + " attempts");
        }
        return result;
    }

    protected Result sendMessage(String url, String message) throws IOException, ParseException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            logger.info((Object)("post to: " + url));
            conn = this.doPost(url, message);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.warn((Object)"IOException posting to XmPush", (Throwable)e);
            return null;
        }
        if (status / 100 == 5) {
            logger.info((Object)("XmPush service is unavailable (status " + status + ")"));
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = MessageTool.getAndClose(conn.getErrorStream());
                logger.debug((Object)("Plain post error response: " + responseBody2));
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.info((Object)"Exception reading response: ", (Throwable)e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = MessageTool.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.warn((Object)"Exception reading response: ", (Throwable)e);
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(responseBody);
            return new Result.Builder().fromJson(json);
        }
        catch (ParseException e) {
            logger.warn((Object)"Exception parsing response: ", (Throwable)e);
            throw new IOException("Invalid response from XmPush: " + responseBody);
        }
    }
}

