/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Tracer
extends HttpBase {
    protected static final Logger logger = Logger.getLogger(Tracer.class.getName());

    public Tracer(String security) {
        super(Tracer.nonNull(security));
    }

    public String getMessageGroupStatus(String jobKey, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get status of message group " + jobKey);
            }
            boolean bl = tryAgain = (result = this.getMessageGroupStatusNoRetry(jobKey)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not get message group status after " + attempt + " attempts");
        }
        return result;
    }

    public String getMessageStatus(String msgId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get status of message " + msgId);
            }
            boolean bl = tryAgain = (result = this.getMessageStatusNoRetry(msgId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not get message status after " + attempt + " attempts");
        }
        return result;
    }

    public String getMessageStatus(long beginTime, long endTime, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get messages status between " + beginTime + " and " + endTime);
            }
            boolean bl = tryAgain = (result = this.getMessageStatusNoRetry(beginTime, endTime)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not get messages status after " + attempt + " attempts");
        }
        return result;
    }

    public String getMessageGroupStatusNoRetry(String jobKey) throws UnsupportedEncodingException, InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        StringBuilder parameter = Tracer.newBody("job_key", URLEncoder.encode(jobKey, "UTF-8"));
        String parameterString = parameter.toString();
        try {
            logger.fine("get from: " + Constants.XMPUSH_MESSAGE_TRACE);
            conn = this.doGet(Constants.XMPUSH_MESSAGE_TRACE, parameterString);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "IOException while get from XmPush", e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Tracer.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Tracer.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: ", e);
            return null;
        }
        return responseBody;
    }

    public String getMessageStatusNoRetry(String msgId) throws UnsupportedEncodingException, InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        StringBuilder parameter = Tracer.newBody("msg_id", URLEncoder.encode(msgId, "UTF-8"));
        String parameterString = parameter.toString();
        try {
            logger.fine("get from: " + Constants.XMPUSH_MESSAGE_TRACE);
            conn = this.doGet(Constants.XMPUSH_MESSAGE_TRACE, parameterString);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "IOException while get from XmPush", e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Tracer.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Tracer.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: ", e);
            return null;
        }
        return responseBody;
    }

    public String getMessageStatusNoRetry(long beginTime, long endTime) throws UnsupportedEncodingException, InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        StringBuilder parameter = Tracer.newBody("begin_time", URLEncoder.encode("" + beginTime, "UTF-8"));
        Tracer.addParameter(parameter, "end_time", URLEncoder.encode("" + endTime, "UTF-8"));
        String parameterString = parameter.toString();
        try {
            logger.fine("get from: " + Constants.XMPUSH_MESSAGES_TRACE);
            conn = this.doGet(Constants.XMPUSH_MESSAGES_TRACE, parameterString);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "IOException while get from XmPush", e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Tracer.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Tracer.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: ", e);
            return null;
        }
        return responseBody;
    }
}

