/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.nutz.json.Json;
import org.nutz.lang.Encoding;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.CmdParams;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.web.NutOnlyWebServer;
import org.nutz.web.WebConfig;
import org.nutz.web.WebServer;

public class WebLauncher {
    private static final Log log = Logs.get();

    public static void main(String[] args) {
        WebLauncher.start(args);
    }

    public static void start(String ... args) {
        WebConfig conf = null;
        String self = WebLauncher.selfPath();
        if (self != null && WebLauncher.checkWebXml(self)) {
            InputStream ins = WebLauncher.class.getClassLoader().getResourceAsStream("web.properties");
            if (ins == null) {
                log.info((Object)"web.properties not found , using cmdline args");
                conf = new WebConfig(new StringReader(""));
            } else {
                log.info((Object)"web.properties found");
                try {
                    conf = new WebConfig(new InputStreamReader(ins, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw Lang.impossible();
                }
            }
            conf.put("war", self);
            conf.put("web-xml", self + "/WEB-INF/web.xml");
            CmdParams params = CmdParams.parse((String[])args, null);
            conf.put("app-port", params.get("port", conf.get("app-port", "8080")));
            conf.put("bind-address", params.get("bind", conf.get("bind-address", "0.0.0.0")));
            conf.put("app-classpath", params.get("cp", conf.get("app-classpath", "./conf/")));
        }
        if (conf == null) {
            String path = Strings.sBlank((Object)Lang.first((Object)args), (String)"web.properties");
            File f = Files.findFile((String)path);
            if (f == null) {
                throw new RuntimeException(new FileNotFoundException(path));
            }
            log.infof("launch by '%s'", new Object[]{f});
            Reader r = Streams.fileInr((File)f);
            conf = new WebConfig(r);
        }
        WebServer server = new WebServer(conf);
        server.run();
        log.info((Object)"Server is down!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkWebXml(String self) {
        boolean bl;
        File f = new File(self);
        ZipFile zip = null;
        try {
            zip = new ZipFile(f);
            bl = null != zip.getEntry("WEB-INF/web.xml");
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                Streams.safeClose(zip);
                throw throwable;
            }
            Streams.safeClose((Closeable)zip);
            return bl2;
        }
        Streams.safeClose((Closeable)zip);
        return bl;
    }

    public static void startNutOnlyWebapp(String ... args) {
        String path = Strings.sBlank((Object)Lang.first((Object)args), (String)"web.properties");
        log.infof("launch by '%s'", new Object[]{path});
        NutOnlyWebServer server = new NutOnlyWebServer(new WebConfig(path));
        server.run();
        log.info((Object)"Server is down!");
    }

    public static void printHelp() {
        log.warn((Object)"web.properties not found");
    }

    public static void exec(String ... args) {
        log.debug((Object)Json.toJson((Object)args));
        CmdParams params = CmdParams.parse((String[])args, (String)"debug");
        if (params.has("inject")) {
            String src = params.get("inject");
            String self = null;
            self = params.has("self") ? params.get("self") : WebLauncher.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            String dst = params.get("output");
            if (dst == null) {
                dst = src.substring(0, src.lastIndexOf(46)) + "-nutzweb.war";
            }
            WebLauncher.merge(params, src, self, dst);
            return;
        }
        if (params.has("war")) {
            WebConfig conf = new WebConfig(new StringReader(""));
            conf.set("war", params.check("war"));
            WebServer server = new WebServer(conf);
            server.run();
        }
    }

    public static void merge(CmdParams params, String srcA, String srcB, String target) {
        try {
            ZipEntry en;
            Files.createFileIfNoExists((String)target);
            ZipInputStream zin_a = new ZipInputStream((InputStream)new FileInputStream(srcA), Encoding.CHARSET_UTF8);
            ZipInputStream zin_b = new ZipInputStream((InputStream)new FileInputStream(srcB), Encoding.CHARSET_UTF8);
            ZipOutputStream zout = new ZipOutputStream((OutputStream)new FileOutputStream(target), Encoding.CHARSET_UTF8);
            zout.setLevel(0);
            while ((en = zin_a.getNextEntry()) != null) {
                if (en.getName().equals("META-INF/MANIFEST.MF")) continue;
                if (params.is("debug")) {
                    log.debug((Object)("add " + en.getName()));
                }
                zout.putNextEntry(new ZipEntry(en.getName()));
                Streams.write((OutputStream)zout, (InputStream)zin_a);
                zout.closeEntry();
            }
            while ((en = zin_b.getNextEntry()) != null) {
                String name = en.getName();
                if (!name.contains("/") || name.startsWith("org/nutz/dao") || name.startsWith("org/nutz/aop")) continue;
                if (params.is("debug")) {
                    log.debug((Object)("add " + en.getName()));
                }
                try {
                    zout.putNextEntry(new ZipEntry(en.getName()));
                    Streams.write((OutputStream)zout, (InputStream)zin_b);
                    zout.closeEntry();
                }
                catch (Exception e) {
                    if (en.getName().endsWith("/")) continue;
                    log.info((Object)("dup ? " + en.getName()));
                }
            }
            zout.flush();
            zout.finish();
            zout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String selfPath() {
        try {
            ProtectionDomain domain = WebLauncher.class.getProtectionDomain();
            URL location = domain.getCodeSource().getLocation();
            return location.getFile();
        }
        catch (Exception e) {
            return "";
        }
    }
}

