/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.ServerContainer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.nutz.http.Http;
import org.nutz.http.Response;
import org.nutz.lang.Each;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.socket.SocketAction;
import org.nutz.lang.socket.SocketContext;
import org.nutz.lang.socket.Sockets;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.web.WebConfig;
import org.nutz.web.Webs;

public class WebServer {
    private static final Log log = Logs.get();
    protected WebConfig dc;
    protected Server server;
    boolean websocketEnable = false;
    WebAppContext wac;

    public WebServer(WebConfig config) {
        this.dc = config;
        Webs.setProp(config);
    }

    protected void prepare() throws IOException {
        if (this.dc.getAppPort() <= 0) {
            this.dc.set("app-port", "80");
        }
        if (!this.dc.has("bind-address")) {
            this.dc.set("bind-address", "0.0.0.0");
        }
        this.server = new Server(InetSocketAddress.createUnresolved(this.dc.get("bind-address"), this.dc.getAppPort()));
        String warUrlString = null;
        if (this.dc.has("war")) {
            warUrlString = this.dc.get("war");
        } else {
            String rootPath = this.dc.getAppRoot();
            File root = Files.findFile((String)rootPath);
            if (root == null || !root.exists()) {
                log.warnf("root: '%s' not exist!", new Object[]{this.dc.get("app-root")});
                warUrlString = Lang.runRootPath();
            } else {
                warUrlString = root.toURI().toURL().toExternalForm();
            }
        }
        log.debugf("++war path : %s", new Object[]{warUrlString});
        this.wac = new WebAppContext(warUrlString, this.dc.getAppContextPath());
        if (warUrlString.endsWith(".war") || this.dc.has("war")) {
            this.wac.setExtractWAR(false);
            this.wac.setCopyWebInf(true);
            this.wac.setProtectedTargets(new String[]{"/java", "/javax", "/org", "/net", "/WEB-INF", "/META-INF"});
            this.wac.setTempDirectory(new File("./tmp").getAbsoluteFile());
            this.wac.setServerClasses(new String[]{"org.objectweb.asm.", "org.eclipse.jdt.", "org.nutz"});
            InputStream ins = this.getClass().getClassLoader().getResourceAsStream("web.allows");
            if (ins != null) {
                log.info((Object)"found web.allows");
                final HashSet<String> allowPaths = new HashSet<String>();
                Streams.eachLine((Reader)new InputStreamReader(ins), (Each)new Each<String>(){

                    public void invoke(int index, String ele, int length) {
                        allowPaths.add(ele);
                    }
                });
                this.wac.addFilter(new FilterHolder((Filter)new WebAllowFilter(allowPaths)), "/*", EnumSet.of(DispatcherType.REQUEST));
            }
        } else {
            if (this.dc.hasAppDefaultsDescriptor()) {
                this.wac.setDefaultsDescriptor(this.dc.getAppDefaultsDescriptor());
            }
            this.wac.setClassLoader(this.getClass().getClassLoader());
        }
        this.wac.setExtraClasspath(this.dc.getAppClasspath());
        this.wac.setConfigurationDiscovered(true);
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            this.wac.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        }
        this.server.setHandler((Handler)this.wac);
        try {
            Class<?> _klass = Class.forName("org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer", false, this.getClass().getClassLoader());
            Class.forName("javax.annotation.security.RunAs", false, this.getClass().getClassLoader());
            Configuration.ClassList list = Configuration.ClassList.serverDefault((Server)this.server);
            list.add("org.eclipse.jetty.annotations.AnnotationConfiguration");
            this.wac.setConfigurationClasses((List)list);
            if (this.dc.has("war")) {
                _klass.getMethod("configureContext", ServletContextHandler.class).invoke(null, this.wac);
            }
            log.info((Object)"init websocket context success");
            this.websocketEnable = true;
        }
        catch (Exception e) {
            log.info((Object)"miss some websocket class, skip websocket init", (Throwable)e);
        }
    }

    public void run() {
        block13: {
            try {
                Response resp;
                this.prepare();
                this.server.start();
                if (this.websocketEnable) {
                    List websockets = this.dc.getList("websockets");
                    try {
                        ServerContainer sc = (ServerContainer)this.wac.getAttribute(ServerContainer.class.getName());
                        if (websockets != null) {
                            for (String className : websockets) {
                                sc.addEndpoint(Class.forName(className));
                            }
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)"enable websocket fail", (Throwable)e);
                    }
                }
                if (this.dc.has("app-jsp-extpath")) {
                    String[] ss;
                    WebAppContext wac = (WebAppContext)this.server.getHandler();
                    ArrayList<Resource> rs = new ArrayList<Resource>();
                    rs.add(wac.getBaseResource());
                    for (String s : ss = Strings.splitIgnoreBlank((String)this.dc.trim("app-jsp-extpath"), (String)"[,\n]")) {
                        Resource r;
                        File d = Files.findFile((String)s);
                        if (null != d && (r = Resource.newResource((URI)d.getCanonicalFile().toURI())).exists()) {
                            log.debug((Object)("app-jsp-extpath OK >> " + s));
                            rs.add(r);
                            continue;
                        }
                        log.debug((Object)("app-jsp-extpath FAIL >> " + s));
                    }
                    wac.setBaseResource((Resource)new ResourceCollection(rs.toArray(new Resource[rs.size()])));
                }
                if ((resp = Http.get((String)("http://127.0.0.1:" + this.dc.getAppPort()))) == null || resp.getStatus() >= 500) {
                    log.error((Object)"Self-Testing fail !!Server start fail?!!");
                    this.server.stop();
                    return;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Server is up!");
                }
                if (log.isInfoEnabled()) {
                    log.infof("Create admin port at %d", new Object[]{this.dc.getAdminPort()});
                }
                Sockets.localListenOne((int)this.dc.getAdminPort(), (String)"stop", (SocketAction)new SocketAction(){

                    public void run(SocketContext context) {
                        block3: {
                            if (null != WebServer.this.server) {
                                try {
                                    WebServer.this.server.stop();
                                }
                                catch (Exception e4stop) {
                                    if (!log.isErrorEnabled()) break block3;
                                    log.error((Object)"Fail to stop!", (Throwable)e4stop);
                                }
                            }
                        }
                        Sockets.close();
                    }
                });
            }
            catch (Throwable e) {
                if (!log.isWarnEnabled()) break block13;
                log.warn((Object)"Unknow error", e);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (null != this.server) {
            try {
                this.server.stop();
            }
            catch (Throwable e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Fail to stop!", e);
                }
                throw e;
            }
        }
        super.finalize();
    }

    public static class WebAllowFilter
    implements Filter {
        protected Set<String> allowPaths;

        public WebAllowFilter(Set<String> allowPaths) {
            this.allowPaths = allowPaths;
        }

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest req = (HttpServletRequest)request;
            String uri = req.getRequestURI();
            if (uri != null && uri.length() > 1) {
                uri = uri.substring(1);
                URL u = this.getClass().getClassLoader().getResource(uri);
                if (u != null && !this.allowPaths.contains(uri)) {
                    ((HttpServletResponse)response).setStatus(404);
                    return;
                }
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

