/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.nutz.mvc;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.nutz.boot.AppContext;
import org.nutz.boot.starter.WebFilterFace;
import org.nutz.boot.starter.WebServletFace;
import org.nutz.boot.starter.nutz.mvc.NbMainModule;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.mvc.NutFilter;

@IocBean
public class NutFilterStarter
implements WebFilterFace {
    @Inject(value="refer:$ioc")
    protected Ioc ioc;
    @Inject
    protected PropertiesProxy conf;
    @Inject
    protected AppContext appContext;

    public String getName() {
        return "nutz";
    }

    public String getPathSpec() {
        return "/*";
    }

    public EnumSet<DispatcherType> getDispatches() {
        return EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.INCLUDE);
    }

    @IocBean(name="nutFilter")
    public NutFilter createNutFilter() {
        return new NutFilter();
    }

    public Filter getFilter() {
        return (Filter)this.ioc.get(NutFilter.class, "nutFilter");
    }

    public Map<String, String> getInitParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("modules", NbMainModule.class.getName());
        if (this.conf.has("nutz.mvc.ignore")) {
            params.put("ignore", this.conf.get("nutz.mvc.ignore"));
        }
        StringBuilder sb = new StringBuilder();
        for (WebServletFace face : this.appContext.getBeans(WebServletFace.class)) {
            for (String pathSpec : face.getPathSpecs()) {
                sb.append(',').append(pathSpec);
            }
        }
        params.put("exclusions", this.conf.get("nutz.mvc.exclusions", "") + sb);
        return params;
    }

    public int getOrder() {
        return this.conf.getInt("web.filter.order.nutz", 50);
    }
}

