/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nutz.castor.Castors;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.http.sender.FilePostSender;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.weixin.bean.WxArticle;
import org.nutz.weixin.bean.WxGroup;
import org.nutz.weixin.bean.WxMenu;
import org.nutz.weixin.bean.WxOutMsg;
import org.nutz.weixin.bean.WxTemplateData;
import org.nutz.weixin.impl.AbstractWxApi2;
import org.nutz.weixin.spi.WXAccountApi;
import org.nutz.weixin.spi.WxResp;
import org.nutz.weixin.util.Wxs;

public class WxApi2Impl
extends AbstractWxApi2 {
    private static final Log log = Logs.get().setTag("weixin");
    public static final String ShakeUrlBase = "https://api.weixin.qq.com/shakearound";

    @Override
    public WxResp send(WxOutMsg out) {
        if (out.getFromUserName() == null) {
            out.setFromUserName(this.openid);
        }
        String str = Wxs.asJson(out);
        if (Wxs.DEV_MODE) {
            log.debug((Object)("api out msg>\n" + str));
        }
        return this.call("/message/custom/send", Request.METHOD.POST, str);
    }

    @Override
    public WxResp user_info(String openid, String lang) {
        return this.get("/user/info", "openid", openid, "lang", lang);
    }

    @Override
    public WxResp user_info_updatemark(String openid, String remark) {
        return this.postJson("/user/info/updateremark", "openid", openid, "remark", remark);
    }

    @Override
    public void user_get(Each<String> each) {
        String next_openid = null;
        WxResp map = null;
        int count = 0;
        int total = 0;
        int index = 0;
        block4: while ((count = ((Number)(map = next_openid == null ? this.call("/user/get", Request.METHOD.GET, null) : this.call("/user/get?next_openid=" + next_openid, Request.METHOD.GET, null)).get("count")).intValue()) >= 1) {
            total = ((Number)map.get("total")).intValue();
            next_openid = Strings.sNull((Object)map.get("next_openid"));
            if (next_openid.length() == 0) {
                next_openid = null;
            }
            List openids = (List)((Map)map.get("data")).get("openid");
            Iterator iterator = openids.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block4;
                String openid = (String)iterator.next();
                try {
                    each.invoke(index, (Object)openid, total);
                }
                catch (ExitLoop e) {
                    return;
                }
                catch (ContinueLoop e) {
                    continue;
                }
                catch (LoopException e) {
                    throw e;
                }
                ++index;
            }
            break;
        }
        return;
    }

    @Override
    public WxResp groups_create(WxGroup group) {
        return this.postJson("/groups/create", "group", group);
    }

    @Override
    public WxResp groups_get() {
        return this.call("/groups/get", Request.METHOD.GET, null);
    }

    @Override
    public WxResp groups_getid(String openid) {
        return this.postJson("/groups/getid", "openid", openid);
    }

    @Override
    public WxResp groups_update(WxGroup group) {
        return this.postJson("/groups/update", "group", group);
    }

    @Override
    public WxResp groups_member_update(String openid, String to_groupid) {
        return this.postJson("/groups/member/update", "openid", openid, "to_groupid", to_groupid);
    }

    @Override
    public WxResp qrcode_create(Object scene_id, int expire_seconds) {
        NutMap scene;
        NutMap params = new NutMap();
        if (expire_seconds > 0) {
            params.put((Object)"action_name", (Object)"QR_SCENE");
            params.put((Object)"expire_seconds", (Object)expire_seconds);
            scene = Lang.map((String)"scene_id", (Object)Castors.me().castTo(scene_id, Integer.class));
        } else if (scene_id instanceof Number) {
            params.put((Object)"action_name", (Object)"QR_LIMIT_SCENE");
            scene = Lang.map((String)"scene_id", (Object)Castors.me().castTo(scene_id, Integer.class));
        } else {
            params.put((Object)"action_name", (Object)"QR_LIMIT_STR_SCENE");
            scene = Lang.map((String)"scene_str", (Object)scene_id.toString());
        }
        params.put((Object)"action_info", (Object)Lang.map((String)"scene", (Object)scene));
        return this.postJson("/qrcode/create", params);
    }

    @Override
    public String qrcode_show(String ticket) {
        return "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + ticket;
    }

    @Override
    public WxResp template_api_set_industry(String industry_id1, String industry_id2) {
        return this.postJson("/template/api_set_industry", "industry_id1", industry_id1, "industry_id2", industry_id2);
    }

    @Override
    public WxResp template_api_add_template(String template_id_short) {
        return this.postJson("/template/api_add_template", "template_id_short", template_id_short);
    }

    @Override
    public WxResp template_api_del_template(String template_id) {
        return this.postJson("/template/del_private_template", "template_id", template_id);
    }

    @Override
    public WxResp template_send(String touser, String template_id, String url, Map<String, WxTemplateData> data) {
        return this.postJson("/message/template/send", "touser", touser, "template_id", template_id, "url", url, "data", data);
    }

    @Override
    public WxResp menu_create(NutMap map) {
        return this.postJson("/menu/create", map);
    }

    @Override
    public WxResp menu_create(List<WxMenu> button) {
        return this.postJson("/menu/create", "button", button);
    }

    @Override
    public WxResp menu_get() {
        return this.call("/menu/get", Request.METHOD.GET, null);
    }

    @Override
    public WxResp menu_delete() {
        return this.call("/menu/delete", Request.METHOD.GET, null);
    }

    @Override
    public WxResp media_upload(String type, File f) {
        if (type == null) {
            throw new NullPointerException("media type is NULL");
        }
        if (f == null) {
            throw new NullPointerException("meida file is NULL");
        }
        String url = String.format("http://file.api.weixin.qq.com/cgi-bin/media/upload?access_token=%s&type=%s", this.getAccessToken(), type);
        Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
        req.getParams().put("media", f);
        Response resp = new FilePostSender(req).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("media upload file, resp code=" + resp.getStatus());
        }
        return null;
    }

    @Override
    public NutResource media_get(String mediaId) {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/get";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", this.getAccessToken());
        params.put("media_id", mediaId);
        final Response resp = Sender.create((Request)Request.create((String)url, (Request.METHOD)Request.METHOD.GET)).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("download media file, resp code=" + resp.getStatus());
        }
        final String disposition = resp.getHeader().get("Content-disposition");
        return new NutResource(){

            public String getName() {
                if (disposition == null) {
                    return "file.data";
                }
                for (String str : disposition.split(";")) {
                    if (!(str = str.trim()).startsWith("filename=")) continue;
                    if ((str = str.substring("filename=".length())).startsWith("\"")) {
                        str = str.substring(1);
                    }
                    if (str.endsWith("\"")) {
                        str = str.substring(0, str.length() - 1);
                    }
                    return str.trim().intern();
                }
                return "file.data";
            }

            public InputStream getInputStream() throws IOException {
                return resp.getStream();
            }
        };
    }

    @Override
    public WxResp mass_uploadnews(List<WxArticle> articles) {
        return this.postJson("/message/mass/uploadnews", "articles", articles);
    }

    public WxResp _mass_send(NutMap filter, List<String> to_user, String touser, WxOutMsg msg) {
        NutMap params = new NutMap();
        if (filter != null) {
            params.setv("filter", (Object)filter);
        } else if (to_user != null) {
            params.setv("touser", to_user);
        } else {
            params.put((Object)"touser", (Object)touser);
        }
        if ("text".equals(msg.getMsgType())) {
            params.put((Object)"text", (Object)new NutMap().setv("content", (Object)msg.getContent()));
        } else {
            params.put((Object)msg.getMsgType(), (Object)new NutMap().setv("media_id", (Object)msg.getMedia_id()));
        }
        params.setv("msgtype", (Object)msg.getMsgType());
        if (filter != null) {
            return this.postJson("/message/mass/sendall", params);
        }
        if (to_user != null) {
            return this.postJson("/message/mass/send", params);
        }
        return this.postJson("/message/mass/preview", params);
    }

    @Override
    public WxResp mass_sendall(boolean is_to_all, String group_id, WxOutMsg msg) {
        NutMap filter = new NutMap();
        filter.put((Object)"is_to_all", (Object)is_to_all);
        if (!is_to_all) {
            filter.put((Object)"group_id", (Object)group_id);
        }
        return this._mass_send(filter, null, null, msg);
    }

    @Override
    public WxResp mass_send(List<String> to_user, WxOutMsg msg) {
        return this._mass_send(null, to_user, null, msg);
    }

    @Override
    public WxResp mass_del(String msg_id) {
        return this.postJson("/message/mass/del", "msg_id", msg_id);
    }

    @Override
    public WxResp mass_get(String msg_id) {
        return this.postJson("/message/mass/get", "msg_id", msg_id);
    }

    @Override
    public WxResp mass_preview(String touser, WxOutMsg msg) {
        return this._mass_send(null, null, touser, msg);
    }

    @Override
    public WxResp applyId(int quantity, String apply_reason, String comment, int poi_id) {
        return this.postJson("https://api.weixin.qq.com/shakearound/device/applyid", "quantity", quantity, "apply_reason", apply_reason, "comment", comment);
    }

    @Override
    public WxResp applyStatus(String apply_id) {
        return this.postJson("https://api.weixin.qq.com/shakearound/device/applystatus", "apply_id", apply_id);
    }

    @Override
    public WxResp update(int device_id, String comment) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("device_id", (Object)device_id));
        params.put((Object)"comment", (Object)comment);
        return this.postJson("https://api.weixin.qq.com/shakearound/device/update", params);
    }

    @Override
    public WxResp update(String uuid, int major, int minor, String comment) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("uuid", (Object)uuid).setv("major", (Object)major).setv("minor", (Object)minor));
        params.put((Object)"comment", (Object)comment);
        return this.postJson("https://api.weixin.qq.com/shakearound/device/update", params);
    }

    @Override
    public WxResp bindLocation(int device_id, int poi_id) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("device_id", (Object)device_id));
        params.put((Object)"poi_id", (Object)poi_id);
        return this.postJson("https://api.weixin.qq.com/shakearound/device/bindlocation", params);
    }

    @Override
    public WxResp bindLocation(String uuid, int major, int minor, int poi_id) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("uuid", (Object)uuid).setv("major", (Object)major).setv("minor", (Object)minor));
        params.put((Object)"poi_id", (Object)poi_id);
        return this.postJson("https://api.weixin.qq.com/shakearound/device/bindlocation", params);
    }

    @Override
    public WxResp search(int device_id) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("device_id", (Object)device_id));
        return this.postJson("https://api.weixin.qq.com/shakearound/device/search", params);
    }

    @Override
    public WxResp search(String uuid, int major, int minor) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("uuid", (Object)uuid).setv("major", (Object)major).setv("minor", (Object)minor));
        return this.postJson("https://api.weixin.qq.com/shakearound/device/search", params);
    }

    @Override
    public WxResp search(int begin, int count) {
        return this.postJson("https://api.weixin.qq.com/shakearound/device/search", "begin", begin, "count", count);
    }

    @Override
    public WxResp search(int apply_id, int begin, int count) {
        return this.postJson("https://api.weixin.qq.com/shakearound/device/search", "apply_id", apply_id, "begin", begin, "count", count);
    }

    @Override
    public WxResp getShakeInfo(String ticket, int need_poi) {
        return this.postJson("https://api.weixin.qq.com/shakearound/user/getshakeinfo", "ticket", ticket, "need_poi", need_poi);
    }

    @Override
    public WxResp createQRTicket(long expire, WXAccountApi.Type type, int id) {
        NutMap json = NutMap.NEW();
        json.put((Object)"expire_seconds", (Object)expire);
        json.put((Object)"action_name", (Object)type.getValue());
        NutMap action = NutMap.NEW();
        NutMap scene = NutMap.NEW();
        scene.put((Object)"scene_id", (Object)id);
        action.put((Object)"scene", (Object)scene);
        json.put((Object)"action_info", (Object)action);
        return this.postJson("/qrcode/create", json);
    }

    @Override
    public WxResp createQRTicket(long expire, WXAccountApi.Type type, String str) {
        NutMap json = NutMap.NEW();
        json.put((Object)"expire_seconds", (Object)expire);
        json.put((Object)"action_name", (Object)type.getValue());
        NutMap action = NutMap.NEW();
        NutMap scene = NutMap.NEW();
        scene.put((Object)"scene_str", (Object)str);
        action.put((Object)"scene", (Object)scene);
        json.put((Object)"action_info", (Object)action);
        return this.postJson("/qrcode/create", json);
    }

    @Override
    public String qrURL(String ticket) {
        return String.format("https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=%s", ticket);
    }

    @Override
    public WxResp get_all_private_template() {
        return this.postJson("/template/get_all_private_template", NutMap.NEW());
    }

    @Override
    public WxResp get_industry() {
        return this.postJson("/template/get_industry", NutMap.NEW());
    }
}

