/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nutz.http.Http;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.http.sender.FilePostSender;
import org.nutz.json.Json;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.weixin.bean.WxGroup;
import org.nutz.weixin.bean.WxMaster;
import org.nutz.weixin.bean.WxMenu;
import org.nutz.weixin.bean.WxOutMsg;
import org.nutz.weixin.bean.WxTemplateData;
import org.nutz.weixin.bean.WxUser;
import org.nutz.weixin.spi.WxAPI;
import org.nutz.weixin.util.Wxs;

@Deprecated
public class WxApiImpl
implements WxAPI {
    private static final Log log = Logs.get();
    protected String base = "https://api.weixin.qq.com/cgi-bin";
    protected WxMaster master;

    public WxApiImpl(WxMaster master) {
        this.master = master;
    }

    @Override
    public void send(WxOutMsg out) {
        if (out.getFromUserName() == null) {
            out.setFromUserName(this.master.getOpenid());
        }
        String str = Wxs.asJson(out);
        if (Wxs.DEV_MODE) {
            log.debug((Object)("api out msg>\n" + str));
        }
        this.call("/message/custom/send", Request.METHOD.POST, str);
    }

    @Override
    public WxGroup createGroup(WxGroup group) {
        Map<String, Object> map = this.call("/groups/create", Request.METHOD.POST, Json.toJson((Object)new NutMap().setv("group", (Object)group)));
        return (WxGroup)Lang.map2Object((Map)((Map)map.get("group")), WxGroup.class);
    }

    @Override
    public List<WxGroup> listGroup() {
        Map<String, Object> map = this.call("/groups/get", Request.METHOD.GET, null);
        List list = (List)map.get("groups");
        ArrayList<WxGroup> groups = new ArrayList<WxGroup>();
        for (Map e : list) {
            groups.add((WxGroup)Lang.map2Object((Map)e, WxGroup.class));
        }
        return groups;
    }

    @Override
    public int userGroup(String openid) {
        Map<String, Object> map = this.call("/groups/getid", Request.METHOD.POST, Json.toJson((Object)new NutMap().setv("openid", (Object)openid)));
        return ((Number)map.get("groupid")).intValue();
    }

    @Override
    public void renameGroup(WxGroup group) {
        this.call("/groups/update", Request.METHOD.POST, Json.toJson((Object)group));
    }

    @Override
    public void moveUser2Group(String openid, String groupid) {
        this.call("/groups/members/update", Request.METHOD.POST, Json.toJson((Object)new NutMap().setv("openid", (Object)openid).setv("groupid", (Object)groupid)));
    }

    @Override
    public WxUser fetchUser(String openid, String lang) {
        if (lang == null) {
            lang = "zh_CN";
        }
        Map<String, Object> map = this.call("/user/info?openid=" + openid + "&lang=" + openid, Request.METHOD.GET, null);
        return (WxUser)Lang.map2Object(map, WxUser.class);
    }

    @Override
    public void listWatcher(Each<String> each) {
        String next_openid = null;
        Map<String, Object> map = null;
        int count = 0;
        int total = 0;
        int index = 0;
        block4: while ((count = ((Number)(map = next_openid == null ? this.call("/user/get", Request.METHOD.GET, null) : this.call("/user/get?next_openid=" + next_openid, Request.METHOD.GET, null)).get("count")).intValue()) >= 1) {
            total = ((Number)map.get("total")).intValue();
            next_openid = Strings.sNull((Object)map.get("next_openid"));
            if (next_openid.length() == 0) {
                next_openid = null;
            }
            List openids = (List)((Map)map.get("data")).get("openid");
            Iterator iterator = openids.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block4;
                String openid = (String)iterator.next();
                try {
                    each.invoke(index, (Object)openid, total);
                }
                catch (ExitLoop e) {
                    return;
                }
                catch (ContinueLoop e) {
                    continue;
                }
                catch (LoopException e) {
                    throw e;
                }
                ++index;
            }
            break;
        }
        return;
    }

    @Override
    public void creatMenu(WxMenu menu) {
        this.call("/menu/create", Request.METHOD.POST, Json.toJson((Object)menu));
    }

    @Override
    public WxMenu fetchMenu() {
        Map<String, Object> map = this.call("/menu/get", Request.METHOD.GET, null);
        return (WxMenu)Lang.map2Object((Map)((Map)map.get("menu")), WxMenu.class);
    }

    @Override
    public void clearMenu() {
        this.call("/menu/clear", Request.METHOD.GET, null);
    }

    @Override
    public String tmpQr(int expire_seconds, String scene_id) {
        NutMap map = new NutMap().setv("expire_seconds", (Object)expire_seconds).setv("action_name", (Object)"QR_SCENE").setv("scene", (Object)new NutMap().setv("scene_id", (Object)scene_id));
        return this.call("", Request.METHOD.POST, Json.toJson((Object)map)).get("ticket").toString();
    }

    @Override
    public String godQr(int scene_id) {
        NutMap map = new NutMap().setv("action_name", (Object)"QR_LIMIT_SCENE").setv("scene", (Object)new NutMap().setv("scene_id", (Object)scene_id));
        return this.call("", Request.METHOD.POST, Json.toJson((Object)map)).get("ticket").toString();
    }

    @Override
    public String qrUrl(String ticket) {
        return this.base + "/showqrcode?ticket=" + ticket;
    }

    public void reflushAccessToken() {
        String url = String.format("%s/token?grant_type=client_credential&appid=%s&secret=%s", this.base, this.master.getAppid(), this.master.getAppsecret());
        Response resp = Http.get((String)url);
        if (!resp.isOK()) {
            throw new IllegalArgumentException("reflushAccessToken FAIL , openid=" + this.master.getOpenid());
        }
        String str = resp.getContent();
        Map map = (Map)Json.fromJson((CharSequence)str);
        this.master.setAccess_token(map.get("token").toString());
        this.master.setAccess_token_expires(System.currentTimeMillis() + (long)((((Number)map.get("expires_in")).intValue() - 60) * 1000));
    }

    protected Map<String, Object> call(String URL2, Request.METHOD method, String body) {
        Response resp;
        String token = this.getAccessToken();
        URL2 = URL2.contains("?") ? this.base + URL2 + "&access_token=" + token : this.base + URL2 + "?access_token=" + token;
        Request req = Request.create((String)URL2, (Request.METHOD)method);
        if (body != null) {
            req.setData(body);
        }
        if (!(resp = Sender.create((Request)req).send()).isOK()) {
            throw new IllegalArgumentException("resp code=" + resp.getStatus());
        }
        Map map = (Map)Json.fromJson((Reader)resp.getReader());
        if (map != null && map.containsKey("errcode") && ((Number)map.get("errcode")).intValue() != 0) {
            throw new IllegalArgumentException(map.toString());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken() {
        String token = this.master.getAccess_token();
        if (token == null || this.master.getAccess_token_expires() < System.currentTimeMillis()) {
            WxMaster wxMaster = this.master;
            synchronized (wxMaster) {
                if (token == null || this.master.getAccess_token_expires() < System.currentTimeMillis()) {
                    this.reflushAccessToken();
                    token = this.master.getAccess_token();
                }
            }
        }
        return token;
    }

    @Override
    public String mediaUpload(String type, File f) {
        if (type == null) {
            throw new NullPointerException("media type is NULL");
        }
        if (f == null) {
            throw new NullPointerException("meida file is NULL");
        }
        String url = String.format("http://file.api.weixin.qq.com/cgi-bin/media/upload?token=%s&type=%s", this.getAccessToken(), type);
        Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
        req.getParams().put("media", f);
        Response resp = new FilePostSender(req).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("media upload file, resp code=" + resp.getStatus());
        }
        Map map = (Map)Json.fromJson((Reader)resp.getReader());
        if (map != null && map.containsKey("errcode") && ((Number)map.get("errcode")).intValue() != 0) {
            throw new IllegalArgumentException(map.toString());
        }
        return map.get("media_id").toString();
    }

    @Override
    public NutResource mediaGet(String mediaId) {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/get";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", this.getAccessToken());
        params.put("media_id", mediaId);
        final Response resp = Sender.create((Request)Request.create((String)url, (Request.METHOD)Request.METHOD.GET)).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("download media file, resp code=" + resp.getStatus());
        }
        final String disposition = resp.getHeader().get("Content-disposition");
        return new NutResource(){

            public String getName() {
                if (disposition == null) {
                    return "file.data";
                }
                for (String str : disposition.split(";")) {
                    if (!str.startsWith("filename=")) continue;
                    if ((str = str.substring("filename=".length())).startsWith("\"")) {
                        str = str.substring(1);
                    }
                    if (str.endsWith("\"")) {
                        str = str.substring(0, str.length() - 1);
                    }
                    return str.trim().intern();
                }
                return "file.data";
            }

            public InputStream getInputStream() throws IOException {
                return resp.getStream();
            }
        };
    }

    @Override
    public String sendTemplateMsg(String touser, String template_id, String topcolor, Map<String, WxTemplateData> data) {
        if (Strings.isBlank((CharSequence)topcolor)) {
            topcolor = "#173177";
        }
        NutMap map = new NutMap();
        map.put((Object)"touser", (Object)touser);
        map.put((Object)"template_id", (Object)template_id);
        map.put((Object)"topcolor", (Object)topcolor);
        map.put((Object)"data", data);
        return this.call("/message/template/send", Request.METHOD.POST, Json.toJson((Object)map)).get("msgid").toString();
    }

    @Override
    public void userRemark(String openid, String remark) {
        NutMap map = new NutMap();
        map.put((Object)"openid", (Object)openid);
        map.put((Object)"remark", (Object)remark);
        this.call("/user/info/updateremark", Request.METHOD.POST, Json.toJson((Object)map));
    }
}

