/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nutz.http.Http;
import org.nutz.http.Response;
import org.nutz.json.Json;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.MapKeyConvertor;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.Xmls;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.View;
import org.nutz.mvc.view.HttpStatusView;
import org.nutz.mvc.view.RawView;
import org.nutz.mvc.view.ViewWrapper;
import org.nutz.weixin.bean.WxArticle;
import org.nutz.weixin.bean.WxEventType;
import org.nutz.weixin.bean.WxImage;
import org.nutz.weixin.bean.WxInMsg;
import org.nutz.weixin.bean.WxMsgType;
import org.nutz.weixin.bean.WxMusic;
import org.nutz.weixin.bean.WxOutMsg;
import org.nutz.weixin.bean.WxVideo;
import org.nutz.weixin.bean.WxVoice;
import org.nutz.weixin.mvc.WxView;
import org.nutz.weixin.spi.WxHandler;
import org.w3c.dom.Element;

public class Wxs {
    private static final Log log = Logs.get();
    public static boolean DEV_MODE = false;

    public static void enableDevMode() {
        DEV_MODE = true;
        log.warn((Object)"nutzwx DevMode=true now");
    }

    public static String genPaySign(Map<String, Object> map, String key, String signType) {
        Object[] nms = map.keySet().toArray(new String[map.size()]);
        Arrays.sort(nms);
        StringBuilder sb = new StringBuilder();
        signType = signType == null ? "MD5" : signType.toUpperCase();
        boolean isMD5 = "MD5".equals(signType);
        for (Object nm : nms) {
            String s;
            Object v = map.get(nm);
            if (null == v) continue;
            if (isMD5 && "timestamp".equals(nm)) {
                nm = "timeStamp";
            }
            if (Strings.isBlank((CharSequence)(s = v.toString()))) continue;
            sb.append((String)nm).append('=').append(s).append('&');
        }
        sb.append("key=").append(key);
        return Lang.digest((String)signType, (CharSequence)sb).toUpperCase();
    }

    public static String genPaySignMD5(Map<String, Object> map, String key) {
        return Wxs.genPaySign(map, key, "MD5");
    }

    public static void fillPayMap(Map<String, Object> map, String key) {
        map.put("nonce_str", "" + R.random((int)10000000, (int)100000000));
        String sign = Wxs.genPaySignMD5(map, key);
        map.put("sign", sign);
    }

    public static NutMap checkPayReturn(String xml, String key) {
        String sign2;
        NutMap map = Xmls.xmlToMap((String)xml);
        if (!map.containsKey((Object)"sign")) {
            throw Lang.makeThrow((String)"e.wx.pay.re.error : %s", (Object[])new Object[]{xml});
        }
        String sign = map.remove((Object)"sign").toString();
        if (!sign.equals(sign2 = Wxs.genPaySignMD5((Map<String, Object>)map, key))) {
            throw Lang.makeThrow((String)"e.wx.pay.re.sign.invalid : expect '%s' but '%s'", (Object[])new Object[]{sign2, sign});
        }
        return map;
    }

    public static WxInMsg convert(InputStream in) {
        NutMap map = Xmls.asMap((Element)Xmls.xml((InputStream)in).getDocumentElement());
        Lang.convertMapKey((Object)map, (MapKeyConvertor)new MapKeyConvertor(){

            public String convertKey(String key) {
                return Strings.lowerFirst((CharSequence)key);
            }
        }, (boolean)true);
        if (DEV_MODE) {
            log.debug((Object)("Income >> \n" + Json.toJson((Object)map)));
        }
        return (WxInMsg)Lang.map2Object((Map)map, WxInMsg.class);
    }

    public static WxInMsg convert(String data) {
        return Wxs.convert(new ByteArrayInputStream(data.getBytes()));
    }

    public static boolean check(String token, String signature, String timestamp, String nonce) {
        if (signature == null || signature.length() > 128 || timestamp == null || timestamp.length() > 128 || nonce == null || nonce.length() > 128) {
            log.warnf("bad check : signature=%s,timestamp=%s,nonce=%s", new Object[]{signature, timestamp, nonce});
            return false;
        }
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(token);
        tmp.add(timestamp);
        tmp.add(nonce);
        Collections.sort(tmp);
        String key = Lang.concat((Object)"", tmp).toString();
        return Lang.sha1((CharSequence)key).equalsIgnoreCase(signature);
    }

    public static WxOutMsg handle(WxInMsg msg, WxHandler handler) {
        WxOutMsg out = null;
        switch (WxMsgType.valueOf(msg.getMsgType())) {
            case text: {
                out = handler.text(msg);
                break;
            }
            case image: {
                out = handler.image(msg);
                break;
            }
            case voice: {
                out = handler.voice(msg);
                break;
            }
            case video: {
                out = handler.video(msg);
                break;
            }
            case location: {
                out = handler.location(msg);
                break;
            }
            case link: {
                out = handler.link(msg);
                break;
            }
            case event: {
                out = Wxs.handleEvent(msg, handler);
                break;
            }
            default: {
                log.infof("New MsyType=%s ? fallback to defaultMsg", new Object[]{msg.getMsgType()});
                out = handler.defaultMsg(msg);
            }
        }
        return out;
    }

    public static WxOutMsg handleEvent(WxInMsg msg, WxHandler handler) {
        WxOutMsg out = null;
        switch (WxEventType.valueOf(msg.getEvent())) {
            case subscribe: {
                out = handler.eventSubscribe(msg);
                break;
            }
            case unsubscribe: {
                out = handler.eventUnsubscribe(msg);
                break;
            }
            case LOCATION: {
                out = handler.eventLocation(msg);
                break;
            }
            case SCAN: {
                out = handler.eventScan(msg);
                break;
            }
            case CLICK: {
                out = handler.eventClick(msg);
                break;
            }
            case VIEW: {
                out = handler.eventView(msg);
                break;
            }
            case TEMPLATESENDJOBFINISH: {
                out = handler.eventTemplateJobFinish(msg);
                break;
            }
            default: {
                log.infof("New EventType=%s ? fallback to defaultMsg", new Object[]{msg.getMsgType()});
                out = handler.defaultMsg(msg);
            }
        }
        return out;
    }

    public static WxOutMsg fix(WxInMsg in, WxOutMsg out) {
        out.setFromUserName(in.getToUserName());
        out.setToUserName(in.getFromUserName());
        out.setCreateTime(System.currentTimeMillis() / 1000L);
        return out;
    }

    public static WxOutMsg respText(String to, String content) {
        WxOutMsg out = new WxOutMsg("text");
        out.setContent(content);
        if (to != null) {
            out.setToUserName(to);
        }
        return out;
    }

    public static WxOutMsg respImage(String to, String mediaId) {
        WxOutMsg out = new WxOutMsg("image");
        out.setImage(new WxImage(mediaId));
        if (to != null) {
            out.setToUserName(to);
        }
        return out;
    }

    public static WxOutMsg respVoice(String to, String mediaId) {
        WxOutMsg out = new WxOutMsg("voice");
        out.setVoice(new WxVoice(mediaId));
        if (to != null) {
            out.setToUserName(to);
        }
        return out;
    }

    public static WxOutMsg respVideo(String to, String mediaId, String title, String description) {
        WxOutMsg out = new WxOutMsg("video");
        out.setVideo(new WxVideo(mediaId, title, description));
        if (to != null) {
            out.setToUserName(to);
        }
        return out;
    }

    public static WxOutMsg respMusic(String to, String title, String description, String musicURL, String hQMusicUrl, String thumbMediaId) {
        WxOutMsg out = new WxOutMsg("music");
        out.setMusic(new WxMusic(title, description, musicURL, hQMusicUrl, thumbMediaId));
        if (to != null) {
            out.setToUserName(to);
        }
        return out;
    }

    public static WxOutMsg respNews(String to, WxArticle ... articles) {
        return Wxs.respNews(to, Arrays.asList(articles));
    }

    public static WxOutMsg respNews(String to, List<WxArticle> articles) {
        WxOutMsg out = new WxOutMsg("news");
        out.setArticles(articles);
        if (to != null) {
            out.setToUserName(to);
        }
        return out;
    }

    public static String cdata(String str) {
        if (Strings.isBlank((CharSequence)str)) {
            return "";
        }
        return "<![CDATA[" + str.replaceAll("]]", "__") + "]]>";
    }

    public static String tag(String key, String val) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(key).append(">");
        sb.append(val).append("");
        sb.append("</").append(key).append(">\n");
        return sb.toString();
    }

    public static String asXml(WxOutMsg msg) {
        StringWriter sw = new StringWriter();
        Wxs.asXml(sw, msg);
        return sw.toString();
    }

    public static void asXml(Writer writer, WxOutMsg msg) {
        try {
            Writer _out = writer;
            if (DEV_MODE) {
                writer = new StringWriter();
            }
            writer.write("<xml>\n");
            writer.write(Wxs.tag("ToUserName", Wxs.cdata(msg.getToUserName())));
            writer.write(Wxs.tag("FromUserName", Wxs.cdata(msg.getFromUserName())));
            writer.write(Wxs.tag("CreateTime", "" + msg.getCreateTime()));
            writer.write(Wxs.tag("MsgType", Wxs.cdata(msg.getMsgType())));
            switch (WxMsgType.valueOf(msg.getMsgType())) {
                case text: {
                    writer.write(Wxs.tag("Content", Wxs.cdata(msg.getContent())));
                    break;
                }
                case image: {
                    writer.write(Wxs.tag("Image", Wxs.tag("MediaId", msg.getImage().getMediaId())));
                    break;
                }
                case voice: {
                    writer.write(Wxs.tag("Voice", Wxs.tag("MediaId", msg.getVoice().getMediaId())));
                    break;
                }
                case video: {
                    writer.write("<Video>\n");
                    writer.write(Wxs.tag("MediaId", Wxs.cdata(msg.getVideo().getMediaId())));
                    if (msg.getVideo().getTitle() != null) {
                        writer.write(Wxs.tag("Title", Wxs.cdata(msg.getVideo().getTitle())));
                    }
                    if (msg.getVideo().getDescription() != null) {
                        writer.write(Wxs.tag("Description", Wxs.cdata(msg.getVideo().getDescription())));
                    }
                    writer.write("</Video>\n");
                    break;
                }
                case music: {
                    writer.write("<Music>\n");
                    WxMusic music = msg.getMusic();
                    if (music.getTitle() != null) {
                        writer.write(Wxs.tag("Title", Wxs.cdata(music.getTitle())));
                    }
                    if (music.getDescription() != null) {
                        writer.write(Wxs.tag("Description", Wxs.cdata(music.getDescription())));
                    }
                    if (music.getMusicUrl() != null) {
                        writer.write(Wxs.tag("MusicUrl", Wxs.cdata(music.getMusicUrl())));
                    }
                    if (music.getHQMusicUrl() != null) {
                        writer.write(Wxs.tag("HQMusicUrl", Wxs.cdata(music.getHQMusicUrl())));
                    }
                    writer.write(Wxs.tag("ThumbMediaId", Wxs.cdata(music.getThumbMediaId())));
                    writer.write("</Music>\n");
                    break;
                }
                case news: {
                    writer.write(Wxs.tag("ArticleCount", "" + msg.getArticles().size()));
                    writer.write("<Articles>\n");
                    for (WxArticle article : msg.getArticles()) {
                        writer.write("<item>\n");
                        if (article.getTitle() != null) {
                            writer.write(Wxs.tag("Title", Wxs.cdata(article.getTitle())));
                        }
                        if (article.getDescription() != null) {
                            writer.write(Wxs.tag("Description", Wxs.cdata(article.getDescription())));
                        }
                        if (article.getPicUrl() != null) {
                            writer.write(Wxs.tag("PicUrl", Wxs.cdata(article.getPicUrl())));
                        }
                        if (article.getUrl() != null) {
                            writer.write(Wxs.tag("Url", Wxs.cdata(article.getUrl())));
                        }
                        writer.write("</item>\n");
                    }
                    writer.write("</Articles>\n");
                    break;
                }
            }
            writer.write("</xml>");
            if (DEV_MODE) {
                String str = writer.toString();
                log.debug((Object)("Outcome >>\n" + str));
                _out.write(str);
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
    }

    public static String asJson(WxOutMsg msg) {
        StringWriter sw = new StringWriter();
        Wxs.asJson(sw, msg);
        return sw.toString();
    }

    public static void asJson(Writer writer, WxOutMsg msg) {
        NutMap map = new NutMap();
        map.put((Object)"touser", (Object)msg.getToUserName());
        map.put((Object)"msgtype", (Object)msg.getMsgType());
        switch (WxMsgType.valueOf(msg.getMsgType())) {
            case text: {
                map.put((Object)"text", (Object)new NutMap().setv("content", (Object)msg.getContent()));
                break;
            }
            case image: {
                map.put((Object)"image", (Object)new NutMap().setv("media_id", (Object)msg.getImage().getMediaId()));
                break;
            }
            case voice: {
                map.put((Object)"voice", (Object)new NutMap().setv("media_id", (Object)msg.getVoice().getMediaId()));
                break;
            }
            case video: {
                NutMap _video = new NutMap();
                _video.setv("media_id", (Object)msg.getVideo().getMediaId());
                if (msg.getVideo().getTitle() != null) {
                    _video.put((Object)"title", (Object)msg.getVideo().getTitle());
                }
                if (msg.getVideo().getDescription() != null) {
                    _video.put((Object)"description", (Object)msg.getVideo().getDescription());
                }
                map.put((Object)"video", (Object)_video);
                break;
            }
            case music: {
                NutMap _music = new NutMap();
                WxMusic music = msg.getMusic();
                if (music.getTitle() != null) {
                    _music.put((Object)"title", (Object)music.getTitle());
                }
                if (music.getDescription() != null) {
                    _music.put((Object)"description", (Object)music.getDescription());
                }
                if (music.getMusicUrl() != null) {
                    _music.put((Object)"musicurl", (Object)music.getMusicUrl());
                }
                if (music.getHQMusicUrl() != null) {
                    _music.put((Object)"hqmusicurl", (Object)music.getHQMusicUrl());
                }
                _music.put((Object)"thumb_media_id", (Object)music.getThumbMediaId());
                break;
            }
            case news: {
                NutMap _news = new NutMap();
                ArrayList<NutMap> list = new ArrayList<NutMap>();
                for (WxArticle article : msg.getArticles()) {
                    NutMap item = new NutMap();
                    if (article.getTitle() != null) {
                        item.put((Object)"title", (Object)article.getTitle());
                    }
                    if (article.getDescription() != null) {
                        item.put((Object)"description", (Object)article.getDescription());
                    }
                    if (article.getPicUrl() != null) {
                        item.put((Object)"picurl", (Object)article.getPicUrl());
                    }
                    if (article.getUrl() != null) {
                        item.put((Object)"url", (Object)article.getUrl());
                    }
                    list.add(item);
                }
                _news.put((Object)"articles", list);
                map.put((Object)"news", (Object)_news);
                break;
            }
        }
        Json.toJson((Writer)writer, (Object)map);
    }

    public static View handle(WxHandler wxHandler, HttpServletRequest req, String key) throws IOException {
        if (wxHandler == null) {
            log.info((Object)"WxHandler is NULL");
            return HttpStatusView.HTTP_502;
        }
        if (!wxHandler.check(req.getParameter("signature"), req.getParameter("timestamp"), req.getParameter("nonce"), key)) {
            log.info((Object)"token is invalid");
            return HttpStatusView.HTTP_502;
        }
        if ("GET".equalsIgnoreCase(req.getMethod())) {
            log.info((Object)("GET? return echostr=" + req.getParameter("echostr")));
            return new ViewWrapper((View)new RawView(null), (Object)req.getParameter("echostr"));
        }
        WxInMsg in = Wxs.convert((InputStream)req.getInputStream());
        in.setExtkey(key);
        WxOutMsg out = wxHandler.handle(in);
        if (out != null) {
            Wxs.fix(in, out);
        }
        return new ViewWrapper(WxView.me, (Object)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadMedia(String accessToken, String mediaId) {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/get?access_token=" + accessToken + "&media_id=" + mediaId;
        File mf = null;
        for (int i = 0; i < 3; ++i) {
            Response resp;
            FileOutputStream out;
            InputStream in;
            block7: {
                byte[] data;
                in = null;
                out = null;
                resp = Http.get((String)url, (int)60000);
                if (!resp.isOK()) break block7;
                in = resp.getStream();
                mf = File.createTempFile(mediaId, ".wxmedia");
                out = new FileOutputStream(mf);
                Streams.writeAndClose((OutputStream)out, (InputStream)in);
                if (mf.length() < 128L && (data = Files.readBytes((File)mf))[0] == 123) {
                    throw new IllegalArgumentException("mediaId=" + mediaId + "," + new String(data));
                }
                log.debugf("media download success mediaId=" + mediaId, new Object[0]);
                Streams.safeClose((Closeable)in);
                Streams.safeClose((Closeable)out);
                break;
            }
            try {
                log.debugf("download %s fail, code=%s, content=%s", new Object[]{mediaId, resp.getStatus(), resp.getContent()});
            }
            catch (Throwable e) {
                try {
                    log.infof("download %s fail", new Object[]{mediaId, e});
                }
                catch (Throwable throwable) {
                    Streams.safeClose(in);
                    Streams.safeClose(out);
                    throw throwable;
                }
                Streams.safeClose((Closeable)in);
                Streams.safeClose((Closeable)out);
                continue;
            }
            Streams.safeClose((Closeable)in);
            Streams.safeClose((Closeable)out);
            continue;
        }
        return mf;
    }
}

