/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8819.model.api;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8819.model.api.ModuleTagConstants;
import org.opendaylight.yangtools.rfc8819.model.api.ModuleTagEffectiveStatement;
import org.opendaylight.yangtools.rfc8819.model.api.ModuleTagStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;

@Beta
public enum ModuleTagStatements implements StatementDefinition
{
    MODULE_TAG(ModuleTagStatement.class, ModuleTagEffectiveStatement.class, "module-tag", "tag");

    private final @NonNull Class<? extends DeclaredStatement<?>> type;
    private final @NonNull Class<? extends EffectiveStatement<?, ?>> effectiveType;
    private final @NonNull QName name;
    private final @NonNull ArgumentDefinition argument;

    private ModuleTagStatements(Class<? extends DeclaredStatement<?>> declared, Class<? extends EffectiveStatement<?, ?>> effective, String statementName, String argumentName) {
        this.type = Objects.requireNonNull(declared);
        this.effectiveType = Objects.requireNonNull(effective);
        this.name = ModuleTagStatements.createQName(statementName);
        this.argument = ArgumentDefinition.of((QName)ModuleTagStatements.createQName(argumentName), (boolean)false);
    }

    private static @NonNull QName createQName(String localName) {
        return QName.create((QNameModule)ModuleTagConstants.RFC8819_MODULE, (String)localName).intern();
    }

    public QName getStatementName() {
        return this.name;
    }

    public Optional<ArgumentDefinition> getArgumentDefinition() {
        return Optional.of(this.argument);
    }

    public Class<? extends EffectiveStatement<?, ?>> getEffectiveRepresentationClass() {
        return this.effectiveType;
    }

    public Class<? extends DeclaredStatement<?>> getDeclaredRepresentationClass() {
        return this.type;
    }
}

