/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle;

import java.util.Locale;
import org.openrewrite.tools.checkstyle.AuditEventFormatter;
import org.openrewrite.tools.checkstyle.api.AuditEvent;
import org.openrewrite.tools.checkstyle.api.SeverityLevel;

public class AuditEventDefaultFormatter
implements AuditEventFormatter {
    private static final int LENGTH_OF_ALL_SEPARATORS = 10;
    private static final String SUFFIX = "Check";

    @Override
    public String format(AuditEvent event) {
        String fileName = event.getFileName();
        String message = event.getMessage();
        SeverityLevel severityLevel = event.getSeverityLevel();
        String severityLevelName = severityLevel == SeverityLevel.WARNING ? "WARN" : severityLevel.getName().toUpperCase(Locale.US);
        int bufLen = AuditEventDefaultFormatter.calculateBufferLength(event, severityLevelName.length());
        StringBuilder sb = new StringBuilder(bufLen);
        sb.append('[').append(severityLevelName).append("] ").append(fileName).append(':').append(event.getLine());
        if (event.getColumn() > 0) {
            sb.append(':').append(event.getColumn());
        }
        sb.append(": ").append(message).append(" [");
        if (event.getModuleId() == null) {
            String checkShortName = AuditEventDefaultFormatter.getCheckShortName(event);
            sb.append(checkShortName);
        } else {
            sb.append(event.getModuleId());
        }
        sb.append(']');
        return sb.toString();
    }

    private static int calculateBufferLength(AuditEvent event, int severityLevelNameLength) {
        return 10 + event.getFileName().length() + event.getMessage().length() + severityLevelNameLength + AuditEventDefaultFormatter.getCheckShortName(event).length();
    }

    private static String getCheckShortName(AuditEvent event) {
        String checkFullName = event.getSourceName();
        String checkShortName = checkFullName.substring(checkFullName.lastIndexOf(46) + 1);
        if (checkShortName.endsWith(SUFFIX)) {
            int endIndex = checkShortName.length() - SUFFIX.length();
            checkShortName = checkShortName.substring(0, endIndex);
        }
        return checkShortName;
    }
}

