/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.openrewrite.tools.checkstyle.AuditEventDefaultFormatter;
import org.openrewrite.tools.checkstyle.AuditEventFormatter;
import org.openrewrite.tools.checkstyle.api.AuditEvent;
import org.openrewrite.tools.checkstyle.api.AuditListener;
import org.openrewrite.tools.checkstyle.api.AutomaticBean;
import org.openrewrite.tools.checkstyle.api.SeverityLevel;
import org.openrewrite.tools.checkstyle.api.Violation;

public class DefaultLogger
extends AutomaticBean
implements AuditListener {
    public static final String ADD_EXCEPTION_MESSAGE = "DefaultLogger.addException";
    public static final String AUDIT_STARTED_MESSAGE = "DefaultLogger.auditStarted";
    public static final String AUDIT_FINISHED_MESSAGE = "DefaultLogger.auditFinished";
    private final PrintWriter infoWriter;
    private final boolean closeInfo;
    private final PrintWriter errorWriter;
    private final boolean closeError;
    private final AuditEventFormatter formatter;

    public DefaultLogger(OutputStream outputStream, AutomaticBean.OutputStreamOptions outputStreamOptions) {
        this(outputStream, outputStreamOptions, outputStream, AutomaticBean.OutputStreamOptions.NONE);
    }

    public DefaultLogger(OutputStream infoStream, AutomaticBean.OutputStreamOptions infoStreamOptions, OutputStream errorStream, AutomaticBean.OutputStreamOptions errorStreamOptions) {
        this(infoStream, infoStreamOptions, errorStream, errorStreamOptions, new AuditEventDefaultFormatter());
    }

    public DefaultLogger(OutputStream infoStream, AutomaticBean.OutputStreamOptions infoStreamOptions, OutputStream errorStream, AutomaticBean.OutputStreamOptions errorStreamOptions, AuditEventFormatter messageFormatter) {
        if (infoStreamOptions == null) {
            throw new IllegalArgumentException("Parameter infoStreamOptions can not be null");
        }
        boolean bl = this.closeInfo = infoStreamOptions == AutomaticBean.OutputStreamOptions.CLOSE;
        if (errorStreamOptions == null) {
            throw new IllegalArgumentException("Parameter errorStreamOptions can not be null");
        }
        this.closeError = errorStreamOptions == AutomaticBean.OutputStreamOptions.CLOSE;
        OutputStreamWriter infoStreamWriter = new OutputStreamWriter(infoStream, StandardCharsets.UTF_8);
        this.infoWriter = new PrintWriter(infoStreamWriter);
        if (infoStream == errorStream) {
            this.errorWriter = this.infoWriter;
        } else {
            OutputStreamWriter errorStreamWriter = new OutputStreamWriter(errorStream, StandardCharsets.UTF_8);
            this.errorWriter = new PrintWriter(errorStreamWriter);
        }
        this.formatter = messageFormatter;
    }

    @Override
    protected void finishLocalSetup() {
    }

    @Override
    public void addError(AuditEvent event) {
        SeverityLevel severityLevel = event.getSeverityLevel();
        if (severityLevel != SeverityLevel.IGNORE) {
            String errorMessage = this.formatter.format(event);
            this.errorWriter.println(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        PrintWriter printWriter = this.errorWriter;
        synchronized (printWriter) {
            LocalizedMessage exceptionMessage = new LocalizedMessage(ADD_EXCEPTION_MESSAGE, event.getFileName());
            this.errorWriter.println(exceptionMessage.getMessage());
            throwable.printStackTrace(this.errorWriter);
        }
    }

    @Override
    public void auditStarted(AuditEvent event) {
        LocalizedMessage auditStartMessage = new LocalizedMessage(AUDIT_STARTED_MESSAGE);
        this.infoWriter.println(auditStartMessage.getMessage());
        this.infoWriter.flush();
    }

    @Override
    public void auditFinished(AuditEvent event) {
        LocalizedMessage auditFinishMessage = new LocalizedMessage(AUDIT_FINISHED_MESSAGE);
        this.infoWriter.println(auditFinishMessage.getMessage());
        this.closeStreams();
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
        this.infoWriter.flush();
    }

    private void closeStreams() {
        this.infoWriter.flush();
        if (this.closeInfo) {
            this.infoWriter.close();
        }
        this.errorWriter.flush();
        if (this.closeError) {
            this.errorWriter.close();
        }
    }

    private static final class LocalizedMessage {
        private static final Map<String, ResourceBundle> BUNDLE_CACHE = Collections.synchronizedMap(new HashMap());
        private static final Locale LOCALE = Locale.getDefault();
        private final String key;
        private final String[] args;

        LocalizedMessage(String key) {
            this.key = key;
            this.args = null;
        }

        LocalizedMessage(String key, String ... args) {
            this.key = key;
            this.args = args == null ? null : Arrays.copyOf(args, args.length);
        }

        private String getMessage() {
            String bundle = "org.openrewrite.tools.checkstyle.messages";
            ResourceBundle resourceBundle = LocalizedMessage.getBundle("org.openrewrite.tools.checkstyle.messages");
            String pattern = resourceBundle.getString(this.key);
            MessageFormat formatter = new MessageFormat(pattern, Locale.ROOT);
            return formatter.format(this.args);
        }

        private static ResourceBundle getBundle(String bundleName) {
            return BUNDLE_CACHE.computeIfAbsent(bundleName, name -> ResourceBundle.getBundle(name, LOCALE, LocalizedMessage.class.getClassLoader(), new Violation.Utf8Control()));
        }
    }
}

