/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.coding;

import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.CheckUtil;

@FileStatefulCheck
public final class NestedIfDepthCheck
extends AbstractCheck {
    public static final String MSG_KEY = "nested.if.depth";
    private int max = 1;
    private int depth;

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{83};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.depth = 0;
    }

    @Override
    public void visitToken(DetailAST literalIf) {
        if (!CheckUtil.isElseIf(literalIf)) {
            if (this.depth > this.max) {
                this.log(literalIf, MSG_KEY, this.depth, this.max);
            }
            ++this.depth;
        }
    }

    @Override
    public void leaveToken(DetailAST literalIf) {
        if (!CheckUtil.isElseIf(literalIf)) {
            --this.depth;
        }
    }
}

