/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.coding;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.CheckUtil;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@FileStatefulCheck
public final class ParameterAssignmentCheck
extends AbstractCheck {
    public static final String MSG_KEY = "parameter.assignment";
    private final Deque<Set<String>> parameterNamesStack = new ArrayDeque<Set<String>>();
    private Set<String> parameterNames;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{8, 9, 80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 129, 25, 130, 26, 181};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.parameterNamesStack.clear();
        this.parameterNames = Collections.emptySet();
    }

    @Override
    public void visitToken(DetailAST ast) {
        int type = ast.getType();
        if (TokenUtil.isOfType(type, 8, 9)) {
            this.visitMethodDef(ast);
        } else if (type == 181) {
            if (ast.getParent().getType() != 208) {
                this.visitLambda(ast);
            }
        } else {
            this.checkNestedIdent(ast);
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        int type = ast.getType();
        if (TokenUtil.isOfType(type, 8, 9) || type == 181 && ast.getParent().getType() != 208) {
            this.parameterNames = this.parameterNamesStack.pop();
        }
    }

    private void checkNestedIdent(DetailAST ast) {
        DetailAST identAST = ast.getFirstChild();
        if (identAST != null && identAST.getType() == 58 && this.parameterNames.contains(identAST.getText())) {
            this.log(ast, MSG_KEY, identAST.getText());
        }
    }

    private void visitMethodDef(DetailAST ast) {
        this.parameterNamesStack.push(this.parameterNames);
        this.parameterNames = new HashSet<String>();
        this.visitMethodParameters(ast.findFirstToken(20));
    }

    private void visitLambda(DetailAST lambdaAst) {
        this.parameterNamesStack.push(this.parameterNames);
        this.parameterNames = new HashSet<String>();
        DetailAST parameterAst = lambdaAst.findFirstToken(20);
        if (parameterAst == null) {
            parameterAst = lambdaAst.getFirstChild();
        }
        this.visitLambdaParameters(parameterAst);
    }

    private void visitMethodParameters(DetailAST ast) {
        this.visitParameters(ast);
    }

    private void visitLambdaParameters(DetailAST ast) {
        if (ast.getType() == 58) {
            this.parameterNames.add(ast.getText());
        } else {
            this.visitParameters(ast);
        }
    }

    private void visitParameters(DetailAST parametersAst) {
        for (DetailAST parameterDefAST = parametersAst.findFirstToken(21); parameterDefAST != null; parameterDefAST = parameterDefAST.getNextSibling()) {
            if (parameterDefAST.getType() != 21 || CheckUtil.isReceiverParameter(parameterDefAST)) continue;
            DetailAST param = parameterDefAST.findFirstToken(58);
            this.parameterNames.add(param.getText());
        }
    }
}

