/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.json.format.AutoFormatVisitor;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;

public class JsonVisitor<P>
extends TreeVisitor<Json, P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Json.Document;
    }

    public String getLanguage() {
        return "json";
    }

    public <Y2 extends Json> Y2 maybeAutoFormat(Y2 before, Y2 after, P p) {
        return this.maybeAutoFormat(before, after, p, this.getCursor());
    }

    public <Y2 extends Json> Y2 maybeAutoFormat(Y2 before, Y2 after, P p, Cursor cursor) {
        return this.maybeAutoFormat(before, after, null, p, cursor);
    }

    public <Y2 extends Json> Y2 maybeAutoFormat(Y2 before, Y2 after, @Nullable Json stopAfter, P p, Cursor cursor) {
        if (before != after) {
            return (Y2)((Json)new AutoFormatVisitor(stopAfter).visit(after, p, cursor));
        }
        return after;
    }

    public <Y2 extends Json> Y2 autoFormat(Y2 y, P p) {
        return this.autoFormat(y, p, this.getCursor());
    }

    public <Y2 extends Json> Y2 autoFormat(Y2 y, P p, Cursor cursor) {
        return this.autoFormat(y, null, p, cursor);
    }

    public <Y2 extends Json> Y2 autoFormat(Y2 y, @Nullable Json stopAfter, P p, Cursor cursor) {
        return (Y2)((Json)new AutoFormatVisitor(stopAfter).visit(y, p, cursor));
    }

    public Json visitArray(Json.Array array, P p) {
        Json.Array a = array;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), p));
        return a.withValues(ListUtils.map(a.getValues(), v -> (JsonValue)this.visit((Tree)v, p)));
    }

    public Json visitDocument(Json.Document document, P p) {
        Json.Document d = document;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), p));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withValue((JsonValue)this.visit(d.getValue(), p));
        return d.withEof(this.visitSpace(d.getEof(), p));
    }

    public Json visitEmpty(Json.Empty empty, P p) {
        Json.Empty e = empty;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        return e.withMarkers(this.visitMarkers(e.getMarkers(), p));
    }

    public Json visitIdentifier(Json.Identifier identifier, P p) {
        Json.Identifier i = identifier;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        return i.withMarkers(this.visitMarkers(i.getMarkers(), p));
    }

    public Json visitLiteral(Json.Literal literal, P p) {
        Json.Literal l = literal;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), p));
        return l.withMarkers(this.visitMarkers(l.getMarkers(), p));
    }

    public Json visitMember(Json.Member member, P p) {
        Json.Member m = member;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), p));
        m = m.getPadding().withKey(this.visitRightPadded(m.getPadding().getKey(), p));
        return m.withValue((JsonValue)this.visit(m.getValue(), p));
    }

    public Json visitObject(Json.JsonObject obj, P p) {
        Json.JsonObject o = obj;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), p));
        o = o.withMarkers(this.visitMarkers(o.getMarkers(), p));
        return o.withMembers(ListUtils.map(o.getMembers(), m -> (Json)this.visit((Tree)m, p)));
    }

    public Space visitSpace(Space space, P p) {
        return space;
    }

    public <T extends Json> @Nullable JsonRightPadded<T> visitRightPadded(@Nullable JsonRightPadded<T> right, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof Json) {
            t = (Json)this.visit((Tree)right.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), p);
        return after == right.getAfter() && t == right.getElement() ? right : new JsonRightPadded<T>(t, after, right.getMarkers());
    }
}

