/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

class RemoteProgressMessage {
    private static final String EOM = "__EOM__";
    private static final int PACKET_LENGTH = 128;
    private final UUID id;
    private Type type;
    private final Map<Integer, String> fragments = new TreeMap<Integer, String>();
    private int fragmentTotal = Integer.MAX_VALUE;

    RemoteProgressMessage(UUID id) {
        this.id = id;
    }

    public @Nullable String getMessage() {
        return this.fragments.isEmpty() ? null : String.join((CharSequence)"", this.fragments.values());
    }

    public static @Nullable RemoteProgressMessage receive(DatagramSocket socket, Map<UUID, RemoteProgressMessage> incompleteMessages) throws IOException {
        byte[] buf = new byte[128];
        DatagramPacket packet = new DatagramPacket(buf, 128);
        try {
            socket.receive(packet);
            return RemoteProgressMessage.read(buf, packet.getLength(), incompleteMessages);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return null;
        }
    }

    public static @Nullable RemoteProgressMessage read(byte[] packet, int length, Map<UUID, RemoteProgressMessage> incompleteMessages) {
        if (length < 42) {
            return null;
        }
        byte[] preambleBytes = new byte[42];
        System.arraycopy(packet, 0, preambleBytes, 0, 42);
        String preamble = new String(preambleBytes);
        if (!preamble.startsWith("v2")) {
            return null;
        }
        UUID messageId = UUID.fromString(preamble.substring(2, 38));
        RemoteProgressMessage message = incompleteMessages.computeIfAbsent(messageId, RemoteProgressMessage::new);
        int typeOrdinal = Integer.parseInt(preamble.substring(38, 39));
        for (Type t : Type.values()) {
            if (typeOrdinal != t.ordinal()) continue;
            message.type = t;
            break;
        }
        int index = Integer.parseInt(preamble.substring(39, 42));
        byte[] messageFragmentBytes = new byte[length - 42];
        System.arraycopy(packet, 42, messageFragmentBytes, 0, length - 42);
        String messageFragment = new String(messageFragmentBytes);
        if (EOM.equals(messageFragment)) {
            message.fragmentTotal = index;
        } else {
            message.fragments.put(index, messageFragment);
        }
        if (message.fragments.size() == message.fragmentTotal) {
            incompleteMessages.remove(messageId);
            return message;
        }
        return null;
    }

    public static List<byte[]> toPackets(Type type, @Nullable String message) {
        String messageId = UUID.randomUUID().toString();
        int index = 0;
        ArrayList<byte[]> packets = new ArrayList<byte[]>();
        if (message != null) {
            byte[] messageBytes = message.getBytes();
            int i = 0;
            while (i < messageBytes.length) {
                byte[] preamble = ("v2" + messageId + type.ordinal() + RemoteProgressMessage.encodeIndex(index)).getBytes(StandardCharsets.UTF_8);
                int packetMessageLength = Math.min(128 - preamble.length, Math.min(messageBytes.length - i, 128));
                byte[] packetBytes = new byte[packetMessageLength + preamble.length];
                System.arraycopy(preamble, 0, packetBytes, 0, preamble.length);
                System.arraycopy(messageBytes, i, packetBytes, preamble.length, packetMessageLength);
                i += packetMessageLength;
                packets.add(packetBytes);
                ++index;
            }
        }
        packets.add(("v2" + messageId + type.ordinal() + RemoteProgressMessage.encodeIndex(index) + EOM).getBytes(StandardCharsets.UTF_8));
        return packets;
    }

    private static String encodeIndex(int index) {
        String indexStr = Integer.toString(index);
        if (index < 10) {
            indexStr = "0" + indexStr;
        }
        if (index < 100) {
            indexStr = "0" + indexStr;
        }
        return indexStr;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    static enum Type {
        IntermediateResult,
        Step,
        SetExtraMessage,
        SetMax,
        Exception;

    }
}

