/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.style.Style;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.format.IndentsVisitor;
import org.openrewrite.yaml.style.Autodetect;
import org.openrewrite.yaml.style.IndentsStyle;
import org.openrewrite.yaml.style.YamlDefaultStyles;
import org.openrewrite.yaml.tree.Yaml;

public class Indents
extends Recipe {
    public String getDisplayName() {
        return "YAML indent";
    }

    public String getDescription() {
        return "Format tabs and indents in YAML.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TabsAndIndentsFromCompilationUnitStyle();
    }

    private static class TabsAndIndentsFromCompilationUnitStyle
    extends YamlIsoVisitor<ExecutionContext> {
        private TabsAndIndentsFromCompilationUnitStyle() {
        }

        @Override
        public Yaml.Documents visitDocuments(Yaml.Documents docs, ExecutionContext ctx) {
            IndentsStyle style = (IndentsStyle)Style.from(IndentsStyle.class, (SourceFile)docs, () -> Autodetect.tabsAndIndents(docs, YamlDefaultStyles.indents()));
            this.doAfterVisit(new IndentsVisitor(style, null));
            return docs;
        }
    }
}

