/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import org.openrewrite.jgit.annotations.Nullable;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.ObjectChecker;
import org.openrewrite.jgit.lib.ObjectId;

public class CorruptObjectException
extends IOException {
    private static final long serialVersionUID = 1L;
    private ObjectChecker.ErrorType errorType;

    public CorruptObjectException(ObjectChecker.ErrorType type, AnyObjectId id, String why) {
        super(MessageFormat.format(JGitText.get().objectIsCorrupt3, type.getMessageId(), id.name(), why));
        this.errorType = type;
    }

    public CorruptObjectException(AnyObjectId id, String why) {
        super(MessageFormat.format(JGitText.get().objectIsCorrupt, id.name(), why));
    }

    public CorruptObjectException(ObjectId id, String why) {
        super(MessageFormat.format(JGitText.get().objectIsCorrupt, id.name(), why));
    }

    public CorruptObjectException(String why) {
        super(why);
    }

    public CorruptObjectException(String why, Throwable cause) {
        super(why);
        this.initCause(cause);
    }

    @Nullable
    public ObjectChecker.ErrorType getErrorType() {
        return this.errorType;
    }
}

