/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.revwalk.filter;

import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.filter.PatternMatchRevFilter;
import org.openrewrite.jgit.revwalk.filter.RevFilter;
import org.openrewrite.jgit.revwalk.filter.SubStringRevFilter;
import org.openrewrite.jgit.util.RawCharSequence;
import org.openrewrite.jgit.util.RawParseUtils;

public class MessageRevFilter {
    public static RevFilter create(String pattern) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        if (SubStringRevFilter.safe(pattern)) {
            return new SubStringSearch(pattern);
        }
        return new PatternSearch(pattern);
    }

    private MessageRevFilter() {
    }

    static RawCharSequence textFor(RevCommit cmit) {
        byte[] raw = cmit.getRawBuffer();
        int b = RawParseUtils.commitMessage(raw, 0);
        if (b < 0) {
            return RawCharSequence.EMPTY;
        }
        return new RawCharSequence(raw, b, raw.length);
    }

    private static class SubStringSearch
    extends SubStringRevFilter {
        SubStringSearch(String patternText) {
            super(patternText);
        }

        @Override
        protected RawCharSequence text(RevCommit cmit) {
            return MessageRevFilter.textFor(cmit);
        }
    }

    private static class PatternSearch
    extends PatternMatchRevFilter {
        PatternSearch(String patternText) {
            super(patternText, true, true, 34);
        }

        @Override
        protected CharSequence text(RevCommit cmit) {
            return MessageRevFilter.textFor(cmit);
        }

        @Override
        public RevFilter clone() {
            return new PatternSearch(this.pattern());
        }
    }
}

