/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.transport;

import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.jgit.annotations.Nullable;
import org.openrewrite.jgit.internal.storage.file.LazyObjectIdSetFile;
import org.openrewrite.jgit.lib.Config;
import org.openrewrite.jgit.lib.ObjectChecker;
import org.openrewrite.jgit.lib.ObjectIdSet;
import org.openrewrite.jgit.lib.Ref;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.transport.RefFilter;
import org.openrewrite.jgit.util.StringUtils;
import org.openrewrite.jgit.util.SystemReader;

public class TransferConfig {
    private static final String FSCK = "fsck";
    public static final Config.SectionParser<TransferConfig> KEY = TransferConfig::new;
    private final boolean fetchFsck;
    private final boolean receiveFsck;
    private final String fsckSkipList;
    private final EnumSet<ObjectChecker.ErrorType> ignore;
    private final boolean allowInvalidPersonIdent;
    private final boolean safeForWindows;
    private final boolean safeForMacOS;
    private final boolean allowRefInWant;
    private final boolean allowTipSha1InWant;
    private final boolean allowReachableSha1InWant;
    private final boolean allowFilter;
    private final boolean allowSidebandAll;
    private final boolean advertiseSidebandAll;
    private final boolean advertiseWaitForDone;
    private final boolean advertiseObjectInfo;
    @Nullable
    final ProtocolVersion protocolVersion;
    final String[] hideRefs;

    public TransferConfig(Repository db) {
        this(db.getConfig());
    }

    public TransferConfig(Config rc) {
        boolean fsck = rc.getBoolean("transfer", "fsckobjects", false);
        this.fetchFsck = rc.getBoolean("fetch", "fsckobjects", fsck);
        this.receiveFsck = rc.getBoolean("receive", "fsckobjects", fsck);
        this.fsckSkipList = rc.getString(FSCK, null, "skipList");
        this.allowInvalidPersonIdent = rc.getBoolean(FSCK, "allowInvalidPersonIdent", false);
        this.safeForWindows = rc.getBoolean(FSCK, "safeForWindows", SystemReader.getInstance().isWindows());
        this.safeForMacOS = rc.getBoolean(FSCK, "safeForMacOS", SystemReader.getInstance().isMacOS());
        this.ignore = EnumSet.noneOf(ObjectChecker.ErrorType.class);
        EnumSet<ObjectChecker.ErrorType> set = EnumSet.noneOf(ObjectChecker.ErrorType.class);
        for (String key : rc.getNames(FSCK)) {
            ObjectChecker.ErrorType id;
            if (StringUtils.equalsIgnoreCase(key, "skipList") || StringUtils.equalsIgnoreCase(key, "allowLeadingZeroFileMode") || StringUtils.equalsIgnoreCase(key, "allowInvalidPersonIdent") || StringUtils.equalsIgnoreCase(key, "safeForWindows") || StringUtils.equalsIgnoreCase(key, "safeForMacOS") || (id = FsckKeyNameHolder.parse(key)) == null) continue;
            switch (rc.getEnum(FSCK, null, key, FsckMode.ERROR)) {
                case ERROR: {
                    this.ignore.remove((Object)id);
                    break;
                }
                case WARN: 
                case IGNORE: {
                    this.ignore.add(id);
                }
            }
            set.add(id);
        }
        if (!set.contains((Object)ObjectChecker.ErrorType.ZERO_PADDED_FILEMODE) && rc.getBoolean(FSCK, "allowLeadingZeroFileMode", false)) {
            this.ignore.add(ObjectChecker.ErrorType.ZERO_PADDED_FILEMODE);
        }
        this.allowRefInWant = rc.getBoolean("uploadpack", "allowrefinwant", false);
        this.allowTipSha1InWant = rc.getBoolean("uploadpack", "allowtipsha1inwant", false);
        this.allowReachableSha1InWant = rc.getBoolean("uploadpack", "allowreachablesha1inwant", false);
        this.allowFilter = rc.getBoolean("uploadpack", "allowfilter", false);
        this.protocolVersion = ProtocolVersion.parse(rc.getString("protocol", null, "version"));
        this.hideRefs = rc.getStringList("uploadpack", null, "hiderefs");
        this.allowSidebandAll = rc.getBoolean("uploadpack", "allowsidebandall", false);
        this.advertiseSidebandAll = rc.getBoolean("uploadpack", "advertisesidebandall", false);
        this.advertiseWaitForDone = rc.getBoolean("uploadpack", "advertisewaitfordone", false);
        this.advertiseObjectInfo = rc.getBoolean("uploadpack", "advertiseobjectinfo", false);
    }

    @Nullable
    public ObjectChecker newObjectChecker() {
        return this.newObjectChecker(this.fetchFsck);
    }

    @Nullable
    public ObjectChecker newReceiveObjectChecker() {
        return this.newObjectChecker(this.receiveFsck);
    }

    private ObjectChecker newObjectChecker(boolean check) {
        if (!check) {
            return null;
        }
        return new ObjectChecker().setIgnore(this.ignore).setAllowInvalidPersonIdent(this.allowInvalidPersonIdent).setSafeForWindows(this.safeForWindows).setSafeForMacOS(this.safeForMacOS).setSkipList(this.skipList());
    }

    private ObjectIdSet skipList() {
        if (this.fsckSkipList != null && !this.fsckSkipList.isEmpty()) {
            return new LazyObjectIdSetFile(new File(this.fsckSkipList));
        }
        return null;
    }

    public boolean isAllowTipSha1InWant() {
        return this.allowTipSha1InWant;
    }

    public boolean isAllowReachableSha1InWant() {
        return this.allowReachableSha1InWant;
    }

    public boolean isAllowFilter() {
        return this.allowFilter;
    }

    public boolean isAllowRefInWant() {
        return this.allowRefInWant;
    }

    public boolean isAllowSidebandAll() {
        return this.allowSidebandAll;
    }

    public boolean isAdvertiseSidebandAll() {
        return this.advertiseSidebandAll && this.allowSidebandAll;
    }

    public boolean isAdvertiseWaitForDone() {
        return this.advertiseWaitForDone;
    }

    public boolean isAdvertiseObjectInfo() {
        return this.advertiseObjectInfo;
    }

    public RefFilter getRefFilter() {
        if (this.hideRefs.length == 0) {
            return RefFilter.DEFAULT;
        }
        return new RefFilter(){

            @Override
            public Map<String, Ref> filter(Map<String, Ref> refs) {
                HashMap<String, Ref> result = new HashMap<String, Ref>();
                for (Map.Entry<String, Ref> e : refs.entrySet()) {
                    boolean add = true;
                    for (String hide : TransferConfig.this.hideRefs) {
                        if (!e.getKey().equals(hide) && !this.prefixMatch(hide, e.getKey())) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    result.put(e.getKey(), e.getValue());
                }
                return result;
            }

            private boolean prefixMatch(String p, String s) {
                return p.charAt(p.length() - 1) == '/' && s.startsWith(p);
            }
        };
    }

    boolean hasDefaultRefFilter() {
        return this.hideRefs.length == 0;
    }

    static class FsckKeyNameHolder {
        private static final Map<String, ObjectChecker.ErrorType> errors = new HashMap<String, ObjectChecker.ErrorType>();

        @Nullable
        static ObjectChecker.ErrorType parse(String key) {
            return errors.get(StringUtils.toLowerCase(key));
        }

        private static String keyNameFor(String name) {
            StringBuilder r = new StringBuilder(name.length());
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '_') continue;
                r.append(c);
            }
            return StringUtils.toLowerCase(r.toString());
        }

        private FsckKeyNameHolder() {
        }

        static {
            for (ObjectChecker.ErrorType m : ObjectChecker.ErrorType.values()) {
                errors.put(FsckKeyNameHolder.keyNameFor(m.name()), m);
            }
        }
    }

    public static enum ProtocolVersion {
        V0("0"),
        V2("2");

        final String name;

        private ProtocolVersion(String name) {
            this.name = name;
        }

        public String version() {
            return this.name;
        }

        @Nullable
        static ProtocolVersion parse(@Nullable String name) {
            if (name == null) {
                return null;
            }
            for (ProtocolVersion v : ProtocolVersion.values()) {
                if (!v.name.equals(name)) continue;
                return v;
            }
            if ("1".equals(name)) {
                return V0;
            }
            return null;
        }
    }

    public static enum FsckMode {
        ERROR,
        WARN,
        IGNORE;

    }
}

