/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.util;

import java.text.MessageFormat;
import java.util.Date;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.util.SystemReader;

public class RelativeDateFormatter {
    static final long SECOND_IN_MILLIS = 1000L;
    static final long MINUTE_IN_MILLIS = 60000L;
    static final long HOUR_IN_MILLIS = 3600000L;
    static final long DAY_IN_MILLIS = 86400000L;
    static final long WEEK_IN_MILLIS = 604800000L;
    static final long MONTH_IN_MILLIS = 2592000000L;
    static final long YEAR_IN_MILLIS = 31536000000L;

    public static String format(Date when) {
        long ageMillis = SystemReader.getInstance().getCurrentTime() - when.getTime();
        if (ageMillis < 0L) {
            return JGitText.get().inTheFuture;
        }
        if (ageMillis < RelativeDateFormatter.upperLimit(60000L)) {
            return MessageFormat.format(JGitText.get().secondsAgo, RelativeDateFormatter.round(ageMillis, 1000L));
        }
        if (ageMillis < RelativeDateFormatter.upperLimit(3600000L)) {
            return MessageFormat.format(JGitText.get().minutesAgo, RelativeDateFormatter.round(ageMillis, 60000L));
        }
        if (ageMillis < RelativeDateFormatter.upperLimit(86400000L)) {
            return MessageFormat.format(JGitText.get().hoursAgo, RelativeDateFormatter.round(ageMillis, 3600000L));
        }
        if (ageMillis < 1209600000L) {
            return MessageFormat.format(JGitText.get().daysAgo, RelativeDateFormatter.round(ageMillis, 86400000L));
        }
        if (ageMillis < 6048000000L) {
            return MessageFormat.format(JGitText.get().weeksAgo, RelativeDateFormatter.round(ageMillis, 604800000L));
        }
        if (ageMillis < 31536000000L) {
            return MessageFormat.format(JGitText.get().monthsAgo, RelativeDateFormatter.round(ageMillis, 2592000000L));
        }
        if (ageMillis < 157680000000L) {
            long years = RelativeDateFormatter.round(ageMillis, 2592000000L) / 12L;
            String yearLabel = years > 1L ? JGitText.get().years : JGitText.get().year;
            long months = RelativeDateFormatter.round(ageMillis - years * 31536000000L, 2592000000L);
            String monthLabel = months > 1L ? JGitText.get().months : (months == 1L ? JGitText.get().month : "");
            return MessageFormat.format(months == 0L ? JGitText.get().years0MonthsAgo : JGitText.get().yearsMonthsAgo, years, yearLabel, months, monthLabel);
        }
        return MessageFormat.format(JGitText.get().yearsAgo, RelativeDateFormatter.round(ageMillis, 31536000000L));
    }

    private static long upperLimit(long unit) {
        long limit = unit + unit / 2L;
        return limit;
    }

    private static long round(long n, long unit) {
        long rounded = (n + unit / 2L) / unit;
        return rounded;
    }
}

