/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.ops4j.pax.logging.log4j2.internal.PaxAppenderProxy;
import org.ops4j.pax.logging.log4j2.internal.PaxLoggingEventImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Plugin(name="PaxOsgi", category="Core", elementType="appender", printObject=true)
public class PaxOsgiAppender
implements Appender {
    private final String name;
    private final String filter;
    private final Object lifeCycleLock = new Object();
    private PaxAppenderProxy proxy;
    private volatile boolean started;

    public PaxOsgiAppender(String name, String filter) {
        this.name = name;
        this.filter = filter == null || filter.isEmpty() ? "*" : filter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Layout<? extends Serializable> getLayout() {
        return null;
    }

    @Override
    public boolean ignoreExceptions() {
        return true;
    }

    @Override
    public ErrorHandler getHandler() {
        return null;
    }

    @Override
    public void setHandler(ErrorHandler handler) {
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lifeCycleLock;
        synchronized (object) {
            if (this.isStarted()) {
                return;
            }
            BundleContext bundleContext = null;
            if (bundleContext == null) {
                Bundle bundle = FrameworkUtil.getBundle(this.getClass());
                if (bundle != null) {
                    bundleContext = bundle.getBundleContext();
                }
                if (bundleContext == null) {
                    throw new IllegalArgumentException("missing BundleContext, expected in org.ops4j.pax.logging.log4j2.bundlecontext");
                }
            }
            this.started = true;
            this.proxy = new PaxAppenderProxy(bundleContext, this.filter);
            this.proxy.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lifeCycleLock;
        synchronized (object) {
            if (!this.isStarted()) {
                return;
            }
            if (this.proxy != null) {
                this.proxy.close();
                this.proxy = null;
            }
            this.started = false;
        }
    }

    @Override
    public void append(LogEvent event) {
        PaxAppenderProxy p = this.proxy;
        if (p != null) {
            p.doAppend(new PaxLoggingEventImpl(event));
        }
    }

    @PluginFactory
    public static PaxOsgiAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="filter") String filter, @PluginConfiguration Configuration config) {
        if (name == null) {
            StatusLogger.getLogger().error("No name provided for PaxOsgiAppender");
            return null;
        }
        return new PaxOsgiAppender(name, filter);
    }
}

