/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import org.ops4j.pax.logging.log4j2.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

public class FrameworkHandler
implements SynchronousBundleListener,
FrameworkListener,
ServiceListener {
    public static final String FRAMEWORK_EVENTS_LOG_LEVEL_PROP_NAME = "org.ops4j.pax.logging.service.frameworkEventsLogLevel";
    private final PaxLoggingServiceImpl m_service;
    private final int loggingLevel;

    public FrameworkHandler(PaxLoggingServiceImpl service) {
        this.m_service = service;
        String levelName = System.getProperty(FRAMEWORK_EVENTS_LOG_LEVEL_PROP_NAME, "DEBUG").trim();
        this.loggingLevel = FrameworkHandler.convertLevel(levelName);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        String message;
        Bundle bundle = bundleEvent.getBundle();
        int type = bundleEvent.getType();
        switch (type) {
            case 1: {
                message = "BundleEvent INSTALLED";
                break;
            }
            case 2: {
                message = "BundleEvent STARTED";
                break;
            }
            case 4: {
                message = "BundleEvent STOPPED";
                break;
            }
            case 8: {
                message = "BundleEvent UPDATED";
                break;
            }
            case 16: {
                message = "BundleEvent UNINSTALLED";
                break;
            }
            case 32: {
                message = "BundleEvent RESOLVED";
                break;
            }
            case 64: {
                message = "BundleEvent UNRESOLVED";
                break;
            }
            case 128: {
                message = "BundleEvent STARTING";
                break;
            }
            case 256: {
                message = "BundleEvent STOPPING";
                break;
            }
            default: {
                message = "BundleEvent [unknown:" + type + "]";
            }
        }
        if (bundle != null) {
            message = message + " - " + bundle.getSymbolicName();
        }
        if (this.loggingLevel > 0) {
            this.m_service.log(bundle, this.loggingLevel, message, null);
        }
    }

    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        String message;
        int type = frameworkEvent.getType();
        switch (type) {
            case 2: {
                message = "FrameworkEvent ERROR";
                break;
            }
            case 32: {
                message = "FrameworkEvent INFO";
                break;
            }
            case 4: {
                message = "FrameworkEvent PACKAGES REFRESHED";
                break;
            }
            case 1: {
                message = "FrameworkEvent STARTED";
                break;
            }
            case 8: {
                message = "FrameworkEvent STARTLEVEL CHANGED";
                break;
            }
            case 16: {
                message = "FrameworkEvent WARNING";
                break;
            }
            default: {
                message = "FrameworkEvent [unknown:" + type + "]";
            }
        }
        Bundle bundle = frameworkEvent.getBundle();
        Throwable exception = frameworkEvent.getThrowable();
        if (bundle != null) {
            message = message + " - " + bundle.getSymbolicName();
        }
        if (this.loggingLevel > 0) {
            this.m_service.log(bundle, this.loggingLevel, message, exception);
        }
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        String message;
        ServiceReference serviceRef = serviceEvent.getServiceReference();
        int type = serviceEvent.getType();
        switch (type) {
            case 2: {
                message = "ServiceEvent MODIFIED";
                break;
            }
            case 1: {
                message = "ServiceEvent REGISTERED";
                break;
            }
            case 4: {
                message = "ServiceEvent UNREGISTERING";
                break;
            }
            default: {
                message = "ServiceEvent [unknown:" + type + "]";
            }
        }
        message = message + " - " + serviceRef;
        Bundle bundle = serviceRef.getBundle();
        if (bundle != null) {
            message = message + " - " + bundle.getSymbolicName();
        }
        if (this.loggingLevel > 0) {
            this.m_service.log(serviceRef, this.loggingLevel, message);
        }
    }

    private static int convertLevel(String levelName) {
        if ("DEBUG".equals(levelName)) {
            return 4;
        }
        if ("INFO".equals(levelName)) {
            return 3;
        }
        if ("WARN".equals(levelName) || "WARNING".equals(levelName)) {
            return 2;
        }
        if ("ERROR".equals(levelName)) {
            return 1;
        }
        if ("DISABLED".equals(levelName)) {
            return 0;
        }
        return 4;
    }
}

