/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.status.StatusLogger;
import org.knopflerfish.service.log.LogService;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.log4j2.appender.PaxOsgiAppender;
import org.ops4j.pax.logging.log4j2.internal.LogEntryImpl;
import org.ops4j.pax.logging.log4j2.internal.LogReaderServiceImpl;
import org.ops4j.pax.logging.log4j2.internal.PaxLoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogEntry;

public class PaxLoggingServiceImpl
implements PaxLoggingService,
LogService,
ManagedService,
ServiceFactory {
    public static final String DEFAULT_SERVICE_LOG_LEVEL = "org.ops4j.pax.logging.DefaultServiceLog.level";
    public static final String MAX_ENTRIES = "pax.logging.entries.size";
    public static final String LOG4J2_CONFIG_FILE_KEY = "org.ops4j.pax.logging.log4j2.config.file";
    public static final String LOG4J2_ASYNC_KEY = "org.ops4j.pax.logging.log4j2.async";
    private final LogReaderServiceImpl m_logReader;
    private final EventAdminPoster m_eventAdmin;
    private final BundleContext m_bundleContext;
    private final PaxContext m_paxContext;
    private final String m_fqcn;
    private final ConcurrentMap<String, PaxLoggerImpl> m_loggers = new ConcurrentHashMap<String, PaxLoggerImpl>();
    private boolean m_async;
    private LoggerContext m_log4jContext;
    private int m_logLevel = 4;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaxLoggingServiceImpl(BundleContext bundleContext, LogReaderServiceImpl logReader, EventAdminPoster eventAdmin) {
        this.m_fqcn = this.getClass().getName();
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext cannot be null");
        }
        this.m_bundleContext = bundleContext;
        if (logReader == null) {
            throw new IllegalArgumentException("logReader cannot be null");
        }
        this.m_logReader = logReader;
        if (eventAdmin == null) {
            throw new IllegalArgumentException("eventAdmin cannot be null");
        }
        this.m_eventAdmin = eventAdmin;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.m_paxContext = new PaxContext();
            this.configureDefaults();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected synchronized void shutdown() {
        this.m_log4jContext.stop();
        this.closed = true;
    }

    public PaxLogger getLogger(Bundle bundle, String category, String fqcn) {
        String name = category == null ? "" : category;
        PaxLoggerImpl logger = (PaxLoggerImpl)this.m_loggers.get(name);
        if (logger == null) {
            logger = new PaxLoggerImpl(bundle, this.m_log4jContext.getLogger(name), fqcn, this);
            this.m_loggers.putIfAbsent(name, logger);
        }
        return (PaxLogger)this.m_loggers.get(name);
    }

    public synchronized void updated(Dictionary configuration) throws ConfigurationException {
        if (this.closed) {
            return;
        }
        if (configuration == null) {
            this.configureDefaults();
            return;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.doUpdate(configuration);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected void doUpdate(Dictionary configuration) throws ConfigurationException {
        boolean async = false;
        Object asyncObj = configuration.get(LOG4J2_ASYNC_KEY);
        if (asyncObj != null) {
            async = Boolean.parseBoolean(asyncObj.toString());
        }
        if (async) {
            try {
                this.getClass().getClassLoader().loadClass("com.lmax.disruptor.EventFactory");
            }
            catch (Exception e) {
                StatusLogger.getLogger().warn("Asynchronous loggers defined, but the disruptor library is not available.  Reverting to synchronous loggers.", (Throwable)e);
                async = false;
            }
        }
        if (async != this.m_async) {
            this.m_log4jContext.stop();
            this.m_log4jContext = new AsyncLoggerContext("pax-logging");
        }
        PluginManager.addPackage(PaxOsgiAppender.class.getPackage().getName());
        Configuration config = new DefaultConfiguration();
        Object configfile = configuration.get(LOG4J2_CONFIG_FILE_KEY);
        if (configfile != null) {
            config = ConfigurationFactory.getInstance().getConfiguration("pax-logging", new File(configfile.toString()).toURI());
        }
        this.m_log4jContext.start(config);
        if (async != this.m_async) {
            for (Map.Entry entry : this.m_loggers.entrySet()) {
                String name = (String)entry.getKey();
                PaxLoggerImpl logger = (PaxLoggerImpl)entry.getValue();
                logger.setDelegate(this.m_log4jContext.getLogger(name));
            }
            this.m_async = async;
        }
        this.configurePax(configuration);
        this.updateLevels(configuration);
        PaxLoggingServiceImpl.setLevelToJavaLogging(configuration);
    }

    private void updateLevels(Dictionary config) {
        Configuration configuration = this.m_log4jContext.getConfiguration();
        Enumeration keys = config.keys();
        while (keys.hasMoreElements()) {
            String loggerName;
            String name = (String)keys.nextElement();
            if (name.equals("log4j.rootLogger")) {
                loggerName = "";
            } else {
                if (!name.startsWith("log4j.logger.")) continue;
                loggerName = name.substring("log4j.logger.".length());
            }
            Level level = Level.toLevel((String)config.get(name));
            LoggerConfig loggerConfig = configuration.getLoggerConfig(loggerName);
            loggerConfig.setLevel(level);
        }
        this.m_log4jContext.updateLoggers();
    }

    private void configurePax(Dictionary config) {
        Object size = config.get(MAX_ENTRIES);
        if (null != size) {
            try {
                this.m_logReader.setMaxEntries(Integer.parseInt((String)size));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void configureDefaults() {
        this.m_log4jContext = new LoggerContext("pax-logging");
        this.m_log4jContext.start(new DefaultConfiguration());
        String levelName = this.m_bundleContext.getProperty(DEFAULT_SERVICE_LOG_LEVEL);
        levelName = levelName == null ? "DEBUG" : levelName.trim();
        this.m_logLevel = PaxLoggingServiceImpl.convertLevel(levelName);
    }

    public int getLogLevel() {
        return this.m_logLevel;
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable exception) {
        this.log(null, level, message, exception, this.m_fqcn);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(sr == null ? null : sr.getBundle(), level, message, null, this.m_fqcn);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.log(sr == null ? null : sr.getBundle(), level, message, exception, this.m_fqcn);
    }

    void log(Bundle bundle, int level, String message, Throwable exception) {
        this.log(bundle, level, message, exception, this.m_fqcn);
    }

    private void log(Bundle bundle, int level, String message, Throwable exception, String fqcn) {
        String category = "[undefined]";
        if (bundle != null && null == (category = bundle.getSymbolicName())) {
            category = "[bundle@" + bundle.getBundleId() + ']';
        }
        PaxLogger logger = this.getLogger(bundle, category, fqcn);
        switch (level) {
            case 1: {
                logger.error(message, exception);
                break;
            }
            case 2: {
                logger.warn(message, exception);
                break;
            }
            case 3: {
                logger.inform(message, exception);
                break;
            }
            case 4: {
                logger.debug(message, exception);
                break;
            }
            default: {
                logger.warn("Undefined Level: " + level + " : " + message, exception);
            }
        }
    }

    void handleEvents(Bundle bundle, ServiceReference sr, int level, String message, Throwable exception) {
        LogEntryImpl entry = new LogEntryImpl(bundle, sr, level, message, exception);
        this.m_logReader.fireEvent(entry);
        this.m_eventAdmin.postEvent(bundle, level, (LogEntry)entry, message, exception, sr, this.getPaxContext().getContext());
    }

    public Object getService(final Bundle bundle, ServiceRegistration registration) {
        class ManagedPaxLoggingService
        implements PaxLoggingService,
        LogService,
        ManagedService {
            private final String fqcn = this.getClass().getName();

            ManagedPaxLoggingService() {
            }

            public void log(int level, String message) {
                PaxLoggingServiceImpl.this.log(bundle, level, message, null, this.fqcn);
            }

            public void log(int level, String message, Throwable exception) {
                PaxLoggingServiceImpl.this.log(bundle, level, message, exception, this.fqcn);
            }

            public void log(ServiceReference sr, int level, String message) {
                Bundle b = bundle == null && sr != null ? sr.getBundle() : bundle;
                PaxLoggingServiceImpl.this.log(b, level, message, null, this.fqcn);
            }

            public void log(ServiceReference sr, int level, String message, Throwable exception) {
                Bundle b = bundle == null && sr != null ? sr.getBundle() : bundle;
                PaxLoggingServiceImpl.this.log(b, level, message, exception, this.fqcn);
            }

            public int getLogLevel() {
                return PaxLoggingServiceImpl.this.getLogLevel();
            }

            public PaxLogger getLogger(Bundle myBundle, String category, String fqcn) {
                return PaxLoggingServiceImpl.this.getLogger(myBundle, category, fqcn);
            }

            public void updated(Dictionary configuration) throws ConfigurationException {
                PaxLoggingServiceImpl.this.updated(configuration);
            }

            public PaxContext getPaxContext() {
                return PaxLoggingServiceImpl.this.getPaxContext();
            }
        }
        return new ManagedPaxLoggingService();
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public PaxContext getPaxContext() {
        return this.m_paxContext;
    }

    private static int convertLevel(String levelName) {
        if ("DEBUG".equals(levelName)) {
            return 4;
        }
        if ("INFO".equals(levelName)) {
            return 3;
        }
        if ("ERROR".equals(levelName)) {
            return 1;
        }
        if ("WARN".equals(levelName)) {
            return 2;
        }
        return 4;
    }

    private static void setLevelToJavaLogging(Dictionary configuration) {
        String name;
        Enumeration<String> enum_ = LogManager.getLogManager().getLoggerNames();
        while (enum_.hasMoreElements()) {
            name = enum_.nextElement();
            Logger.getLogger(name).setLevel(null);
        }
        Enumeration keys = configuration.keys();
        while (keys.hasMoreElements()) {
            name = (String)keys.nextElement();
            String value = (String)configuration.get(name);
            if (name.equals("log4j.rootLogger")) {
                PaxLoggingServiceImpl.setJULLevel(Logger.getLogger(""), value);
                PaxLoggingServiceImpl.setJULLevel(Logger.getLogger("global"), value);
            }
            if (!name.startsWith("log4j.logger.")) continue;
            String packageName = name.substring("log4j.logger.".length());
            Logger logger = Logger.getLogger(packageName);
            PaxLoggingServiceImpl.setJULLevel(logger, value);
        }
    }

    private static void setJULLevel(Logger logger, String log4jLevelConfig) {
        String[] crumb = log4jLevelConfig.split(",");
        if (crumb.length > 0) {
            java.util.logging.Level level = PaxLoggingServiceImpl.log4jLevelToJULLevel(crumb[0].trim());
            logger.setLevel(level);
        }
    }

    private static java.util.logging.Level log4jLevelToJULLevel(String levelProperty) {
        if (levelProperty.contains("OFF")) {
            return java.util.logging.Level.OFF;
        }
        if (levelProperty.contains("FATAL")) {
            return java.util.logging.Level.SEVERE;
        }
        if (levelProperty.contains("ERROR")) {
            return java.util.logging.Level.SEVERE;
        }
        if (levelProperty.contains("WARN")) {
            return java.util.logging.Level.WARNING;
        }
        if (levelProperty.contains("INFO")) {
            return java.util.logging.Level.INFO;
        }
        if (levelProperty.contains("DEBUG")) {
            return java.util.logging.Level.FINE;
        }
        if (levelProperty.contains("TRACE")) {
            return java.util.logging.Level.FINEST;
        }
        return java.util.logging.Level.INFO;
    }
}

