/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.io.IOException;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.parboiled.common.Preconditions;
import org.parboiled.support.Checks;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;

class ClassNodeInitializer
extends ClassVisitor {
    private ParserClassNode classNode;
    private Class<?> ownerClass;
    private boolean hasBuildParseTree;
    private boolean hasExplicitActionOnlyAnnotation;
    private boolean hasDontLabelAnnotation;
    private boolean hasSkipActionsInPredicates;

    public ClassNodeInitializer() {
        super(458752);
    }

    public void process(ParserClassNode parserClassNode) throws IOException {
        this.classNode = (ParserClassNode)((Object)Preconditions.checkArgNotNull((Object)((Object)parserClassNode), (String)"classNode"));
        this.ownerClass = parserClassNode.getParentClass();
        while (!Object.class.equals(this.ownerClass)) {
            this.hasExplicitActionOnlyAnnotation = false;
            this.hasDontLabelAnnotation = false;
            this.hasSkipActionsInPredicates = false;
            ClassReader classReader = AsmUtils.createClassReader(this.ownerClass);
            classReader.accept((ClassVisitor)this, 4);
            this.ownerClass = this.ownerClass.getSuperclass();
        }
        for (RuleMethod ruleMethod : parserClassNode.getRuleMethods().values()) {
            if (ruleMethod.isSuperMethod()) {
                RuleMethod ruleMethod2 = parserClassNode.getRuleMethods().get(ruleMethod.name.substring(1) + ruleMethod.desc);
                ruleMethod.moveFlagsTo(ruleMethod2);
                continue;
            }
            if (this.hasBuildParseTree) break;
            ruleMethod.suppressNode();
        }
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        if (this.ownerClass == this.classNode.getParentClass()) {
            Checks.ensure(((n2 & 2) == 0 ? 1 : 0) != 0, (String)"Parser class '%s' must not be private", (Object[])new Object[]{string});
            Checks.ensure(((n2 & 0x10) == 0 ? 1 : 0) != 0, (String)"Parser class '%s' must not be final.", (Object[])new Object[]{string});
            this.classNode.visit(51, 1, AsmUtils.getExtendedParserClassName(string), null, this.classNode.getParentType().getInternalName(), null);
        }
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (Types.EXPLICIT_ACTIONS_ONLY_DESC.equals(string)) {
            this.hasExplicitActionOnlyAnnotation = true;
            return null;
        }
        if (Types.DONT_LABEL_DESC.equals(string)) {
            this.hasDontLabelAnnotation = true;
            return null;
        }
        if (Types.SKIP_ACTIONS_IN_PREDICATES_DESC.equals(string)) {
            this.hasSkipActionsInPredicates = true;
            return null;
        }
        if (Types.BUILD_PARSE_TREE_DESC.equals(string)) {
            this.hasBuildParseTree = true;
            return null;
        }
        return bl && this.ownerClass == this.classNode.getParentClass() ? this.classNode.visitAnnotation(string, true) : null;
    }

    public void visitSource(String string, String string2) {
        this.classNode.visitSource(null, null);
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if ("<init>".equals(string)) {
            if (this.ownerClass != this.classNode.getParentClass() || (n & 2) > 0) {
                return null;
            }
            MethodNode methodNode = new MethodNode(n, string, string2, string3, stringArray);
            this.classNode.getConstructors().add(methodNode);
            return methodNode;
        }
        if (!Type.getReturnType((String)string2).equals((Object)Types.RULE) || (n & 0x500) > 0) {
            return null;
        }
        Checks.ensure(((n & 2) == 0 ? 1 : 0) != 0, (String)"Rule method '%s'must not be private.\nMark the method protected or package-private if you want to prevent public access!", (Object[])new Object[]{string});
        Checks.ensure(((n & 0x10) == 0 ? 1 : 0) != 0, (String)"Rule method '%s' must not be final.", (Object[])new Object[]{string});
        String string4 = string.concat(string2);
        while (this.classNode.getRuleMethods().containsKey(string4)) {
            string = '$' + string;
            string4 = string.concat(string2);
        }
        RuleMethod ruleMethod = new RuleMethod(this.ownerClass, n, string, string2, string3, stringArray, this.hasExplicitActionOnlyAnnotation, this.hasDontLabelAnnotation, this.hasSkipActionsInPredicates);
        this.classNode.getRuleMethods().put(string4, ruleMethod);
        return ruleMethod;
    }

    public void visitEnd() {
        this.classNode.visitEnd();
    }
}

