/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.reporter;

import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.misusing.MissingMethodInvocationException;
import org.mockito.internal.MockitoCore;
import org.powermock.api.extension.reporter.AbstractMockingFrameworkReporterFactory;
import org.powermock.core.reporter.MockingFrameworkReporter;
import org.powermock.reflect.Whitebox;
import org.powermock.utils.StringJoiner;

public class MockingFrameworkReporterFactoryImpl
extends AbstractMockingFrameworkReporterFactory {
    protected String getImplementerClassName() {
        return "org.powermock.api.extension.reporter.MockingFrameworkReporterFactoryImpl$MockitoMockingFrameworkReporter";
    }

    private static class PowerMockitoReporter
    extends Reporter {
        private PowerMockitoReporter() {
        }

        public void missingMethodInvocation() {
            throw new MissingMethodInvocationException(StringJoiner.join((String)"when() requires an argument which has to be 'a method call on a mock'.", (Object[])new Object[]{"For example:", "    when(mock.getArticles()).thenReturn(articles);", "Or 'a static method call on a prepared class`", "For example:", "    @PrepareForTest( { StaticService.class }) ", "    TestClass{", "       public void testMethod(){", "           PowerMockito.mockStatic(StaticService.class);", "           when(StaticService.say()).thenReturn(expected);", "       }", "    }", "", "Also, this error might show up because:", "1. inside when() you don't call method on mock but on some other object.", "2. inside when() you don't call static method, but class has not been prepared.", ""}));
        }
    }

    private static class MockitoMockingFrameworkReporter
    implements MockingFrameworkReporter {
        private Reporter mockitoReporter;
        private MockitoCore mockitoCore;

        private MockitoMockingFrameworkReporter() {
        }

        private Reporter getMockitoReporter(Object mockitoCore) {
            return (Reporter)Whitebox.getInternalState((Object)mockitoCore, (String)"reporter");
        }

        private void setMockitoReporter(Reporter reporter, MockitoCore mockitoCore) {
            Whitebox.setInternalState((Object)mockitoCore, (String)"reporter", (Object)reporter);
        }

        public void enable() {
            this.mockitoCore = this.getMockitoCoreForCurrentClassLoader();
            this.mockitoReporter = this.getMockitoReporter(this.mockitoCore);
            PowerMockitoReporter powerMockitoReporter = new PowerMockitoReporter();
            this.setMockitoReporter(powerMockitoReporter, this.mockitoCore);
        }

        private MockitoCore getMockitoCoreForCurrentClassLoader() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                return (MockitoCore)Whitebox.getInternalState(classLoader.loadClass("org.mockito.Mockito"), (String)"MOCKITO_CORE");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void disable() {
            this.setMockitoReporter(this.mockitoReporter, this.mockitoCore);
        }
    }
}

