/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rapidoid.buffer.Buf;
import org.rapidoid.bufstruct.BufMap;
import org.rapidoid.bufstruct.BufMapImpl;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.commons.Dates;
import org.rapidoid.commons.MediaType;
import org.rapidoid.data.JSON;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.Range;
import org.rapidoid.data.Ranges;
import org.rapidoid.http.Req;
import org.rapidoid.http.fast.HttpMetadata;
import org.rapidoid.http.fast.HttpParser;
import org.rapidoid.http.fast.HttpResponseCodes;
import org.rapidoid.http.fast.HttpStatus;
import org.rapidoid.http.fast.HttpUtils;
import org.rapidoid.http.fast.ReqImpl;
import org.rapidoid.http.fast.ViewRenderer;
import org.rapidoid.http.fast.handler.FastHttpHandler;
import org.rapidoid.http.fast.handler.FastStaticResourcesHandler;
import org.rapidoid.http.fast.listener.FastHttpListener;
import org.rapidoid.log.Log;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.u.U;
import org.rapidoid.util.UTILS;
import org.rapidoid.wire.Wire;
import org.rapidoid.wrap.BoolWrap;

public class FastHttp
implements Protocol,
HttpMetadata {
    public static final String[] DEFAULT_STATIC_FILES_LOCATIONS = new String[]{"static", "rapidoid/static"};
    private static final byte[] HTTP_200_OK = "HTTP/1.1 200 OK\r\n".getBytes();
    private static final byte[] HTTP_400_BAD_REQUEST = "HTTP/1.1 404 Bad Request\r\nContent-Length: 12\r\n\r\nBad Request!".getBytes();
    private static final byte[] HTTP_404_NOT_FOUND = "HTTP/1.1 404 Not Found\r\nContent-Length: 10\r\n\r\nNot found!".getBytes();
    private static final byte[] HEADER_SEP = ": ".getBytes();
    private static final byte[] CONN_KEEP_ALIVE = "Connection: keep-alive\r\n".getBytes();
    private static final byte[] CONN_CLOSE = "Connection: close\r\n".getBytes();
    private static final byte[] SERVER_HEADER = "Server: Rapidoid\r\n".getBytes();
    private static final byte[] CONTENT_LENGTH_IS = "Content-Length: ".getBytes();
    static final byte[] CONTENT_LENGTH_UNKNOWN = "Content-Length:           ".getBytes();
    private static final int CONTENT_LENGTHS_SIZE = 5000;
    private static final byte[] DATE_IS = "Date: ".getBytes();
    private static final HttpParser HTTP_PARSER = (HttpParser)Wire.singleton(HttpParser.class);
    private static final byte[] _POST = "POST".getBytes();
    private static final byte[] _PUT = "PUT".getBytes();
    private static final byte[] _DELETE = "DELETE".getBytes();
    private static final byte[] _PATCH = "PATCH".getBytes();
    private static final byte[] _OPTIONS = "OPTIONS".getBytes();
    private static final byte[] _HEAD = "HEAD".getBytes();
    private static final byte[] _TRACE = "TRACE".getBytes();
    private static final byte[][] CONTENT_LENGTHS = new byte[5000][];
    private final HttpResponseCodes responseCodes = new HttpResponseCodes();
    private final BufMap<FastHttpHandler> getHandlers = new BufMapImpl();
    private final BufMap<FastHttpHandler> postHandlers = new BufMapImpl();
    private final BufMap<FastHttpHandler> putHandlers = new BufMapImpl();
    private final BufMap<FastHttpHandler> deleteHandlers = new BufMapImpl();
    private final BufMap<FastHttpHandler> patchHandlers = new BufMapImpl();
    private final BufMap<FastHttpHandler> optionsHandlers = new BufMapImpl();
    private final BufMap<FastHttpHandler> headHandlers = new BufMapImpl();
    private final BufMap<FastHttpHandler> traceHandlers = new BufMapImpl();
    private volatile byte[] path1;
    private volatile byte[] path2;
    private volatile byte[] path3;
    private volatile FastHttpHandler handler1;
    private volatile FastHttpHandler handler2;
    private volatile FastHttpHandler handler3;
    private final List<FastHttpHandler> genericHandlers = U.synchronizedList();
    private volatile FastHttpHandler staticResourcesHandler = new FastStaticResourcesHandler(this);
    private volatile String[] staticFilesLocations = DEFAULT_STATIC_FILES_LOCATIONS;
    private volatile FastHttpHandler errorHandler;
    private volatile ViewRenderer renderer;
    private final FastHttpListener listener;
    private final Map<String, Object> attributes = U.synchronizedMap();
    private final Map<String, Map<String, Serializable>> sessions = U.mapOfMaps();

    public FastHttp(FastHttpListener listener) {
        this.listener = listener;
    }

    public synchronized void on(String verb, String path, FastHttpHandler handler) {
        if (verb.equals("GET")) {
            if (this.path1 == null) {
                this.path1 = path.getBytes();
                this.handler1 = handler;
            } else if (this.path2 == null) {
                this.path2 = path.getBytes();
                this.handler2 = handler;
            } else if (this.path3 == null) {
                this.path3 = path.getBytes();
                this.handler3 = handler;
            } else {
                this.getHandlers.put(path, (Object)handler);
            }
        } else if (verb.equals("POST")) {
            this.postHandlers.put(path, (Object)handler);
        } else if (verb.equals("PUT")) {
            this.putHandlers.put(path, (Object)handler);
        } else if (verb.equals("DELETE")) {
            this.deleteHandlers.put(path, (Object)handler);
        } else if (verb.equals("PATCH")) {
            this.patchHandlers.put(path, (Object)handler);
        } else if (verb.equals("OPTIONS")) {
            this.optionsHandlers.put(path, (Object)handler);
        } else if (verb.equals("HEAD")) {
            this.headHandlers.put(path, (Object)handler);
        } else if (verb.equals("TRACE")) {
            this.traceHandlers.put(path, (Object)handler);
        } else {
            throw U.rte((String)"Unsupported HTTP verb: %s", (Object[])new Object[]{verb});
        }
    }

    public void addGenericHandler(FastHttpHandler handler) {
        this.genericHandlers.add(handler);
    }

    public void removeGenericHandler(FastHttpHandler handler) {
        this.genericHandlers.remove(handler);
    }

    public void process(Channel channel) {
        if (channel.isInitial()) {
            return;
        }
        Buf buf = channel.input();
        RapidoidHelper helper = channel.helper();
        Range[] ranges = helper.ranges1.ranges;
        Ranges hdrs = helper.ranges2;
        BoolWrap isGet = helper.booleans[0];
        BoolWrap isKeepAlive = helper.booleans[1];
        Range xverb = ranges[ranges.length - 1];
        Range xuri = ranges[ranges.length - 2];
        Range xpath = ranges[ranges.length - 3];
        Range xquery = ranges[ranges.length - 4];
        Range xprotocol = ranges[ranges.length - 5];
        Range xbody = ranges[ranges.length - 6];
        HTTP_PARSER.parse(buf, isGet, isKeepAlive, xbody, xverb, xuri, xpath, xquery, xprotocol, hdrs, helper);
        FastHttp.removeTrailingSlash(buf, xpath);
        FastHttp.removeTrailingSlash(buf, xuri);
        String err = FastHttp.validateRequest(buf, xverb, xuri);
        if (err != null) {
            channel.write(HTTP_400_BAD_REQUEST);
            channel.close();
            return;
        }
        if (!this.listener.request(this, channel, isGet, isKeepAlive, xbody, xverb, xuri, xpath, xquery, xprotocol, hdrs)) {
            return;
        }
        HttpStatus status = HttpStatus.NOT_FOUND;
        FastHttpHandler handler = this.findHandler(buf, isGet, xverb, xpath);
        boolean noReq = handler != null && !handler.needsParams();
        ReqImpl req = null;
        if (!noReq) {
            Map<String, byte[]> files;
            Map<String, Object> posted;
            byte[] body;
            KeyValueRanges paramsKV = helper.pairs1.reset();
            KeyValueRanges headersKV = helper.pairs2.reset();
            KeyValueRanges cookiesKV = helper.pairs5.reset();
            HTTP_PARSER.parseParams(buf, paramsKV, xquery);
            Map<String, String> params = (Map<String, String>)U.cast((Object)paramsKV.toMap(buf, true, true));
            HTTP_PARSER.parseHeadersIntoKV(buf, hdrs, headersKV, cookiesKV, helper);
            Map<String, String> headers = (Map<String, String>)U.cast((Object)headersKV.toMap(buf, true, true));
            Map<String, String> cookies = (Map<String, String>)U.cast((Object)cookiesKV.toMap(buf, true, true));
            if (!isGet.value && !xbody.isEmpty()) {
                KeyValueRanges postedKV = helper.pairs3.reset();
                KeyValueRanges filesKV = helper.pairs4.reset();
                body = xbody.bytes(buf);
                posted = new HashMap<String, Object>();
                HTTP_PARSER.parsePosted(buf, headersKV, xbody, postedKV, filesKV, helper, posted);
                posted = Collections.synchronizedMap(posted);
                files = Collections.synchronizedMap(filesKV.toBinaryMap(buf, true));
            } else {
                posted = Collections.EMPTY_MAP;
                files = Collections.EMPTY_MAP;
                body = null;
            }
            String verb = xverb.str(buf);
            String uri = xuri.str(buf);
            String path = UTILS.urlDecode((String)xpath.str(buf));
            String query = UTILS.urlDecode((String)xquery.str(buf));
            MediaType contentType = handler != null ? handler.contentType() : MediaType.HTML_UTF_8;
            params = Collections.synchronizedMap(params);
            headers = Collections.synchronizedMap(headers);
            cookies = Collections.synchronizedMap(cookies);
            req = new ReqImpl(this, channel, isKeepAlive.value, verb, uri, path, query, body, params, headers, cookies, posted, files, contentType);
            if (!this.attributes.isEmpty()) {
                req.attrs().putAll(this.attributes);
            }
        }
        if (handler != null) {
            status = handler.handle(channel, isKeepAlive.value, req, null);
        }
        if (status == HttpStatus.NOT_FOUND) {
            status = this.tryGenericHandlers(channel, isKeepAlive.value, req);
        }
        if (status == HttpStatus.NOT_FOUND) {
            channel.write(HTTP_404_NOT_FOUND);
            this.listener.notFound(this, channel, isGet, isKeepAlive, xbody, xverb, xuri, xpath, xquery, xprotocol, hdrs);
        }
        if (status != HttpStatus.ASYNC) {
            channel.closeIf(!isKeepAlive.value);
        }
    }

    private HttpStatus tryGenericHandlers(Channel channel, boolean isKeepAlive, Req req) {
        for (FastHttpHandler handler : this.genericHandlers) {
            HttpStatus status = handler.handle(channel, isKeepAlive, req, null);
            if (status == HttpStatus.NOT_FOUND) continue;
            return status;
        }
        return HttpStatus.NOT_FOUND;
    }

    private FastHttpHandler findHandler(Buf buf, BoolWrap isGet, Range verb, Range path) {
        Bytes bytes = buf.bytes();
        if (isGet.value) {
            if (this.path1 != null && BytesUtil.matches((Bytes)bytes, (Range)path, (byte[])this.path1, (boolean)true)) {
                return this.handler1;
            }
            if (this.path2 != null && BytesUtil.matches((Bytes)bytes, (Range)path, (byte[])this.path2, (boolean)true)) {
                return this.handler2;
            }
            if (this.path3 != null && BytesUtil.matches((Bytes)bytes, (Range)path, (byte[])this.path3, (boolean)true)) {
                return this.handler3;
            }
            FastHttpHandler getHandler = (FastHttpHandler)this.getHandlers.get(buf, path);
            if (getHandler == null) {
                getHandler = this.staticResourcesHandler;
            }
            return getHandler;
        }
        if (BytesUtil.matches((Bytes)bytes, (Range)verb, (byte[])_POST, (boolean)true)) {
            return (FastHttpHandler)this.postHandlers.get(buf, path);
        }
        if (BytesUtil.matches((Bytes)bytes, (Range)verb, (byte[])_PUT, (boolean)true)) {
            return (FastHttpHandler)this.putHandlers.get(buf, path);
        }
        if (BytesUtil.matches((Bytes)bytes, (Range)verb, (byte[])_DELETE, (boolean)true)) {
            return (FastHttpHandler)this.deleteHandlers.get(buf, path);
        }
        if (BytesUtil.matches((Bytes)bytes, (Range)verb, (byte[])_PATCH, (boolean)true)) {
            return (FastHttpHandler)this.patchHandlers.get(buf, path);
        }
        if (BytesUtil.matches((Bytes)bytes, (Range)verb, (byte[])_OPTIONS, (boolean)true)) {
            return (FastHttpHandler)this.optionsHandlers.get(buf, path);
        }
        if (BytesUtil.matches((Bytes)bytes, (Range)verb, (byte[])_HEAD, (boolean)true)) {
            return (FastHttpHandler)this.headHandlers.get(buf, path);
        }
        if (BytesUtil.matches((Bytes)bytes, (Range)verb, (byte[])_TRACE, (boolean)true)) {
            return (FastHttpHandler)this.traceHandlers.get(buf, path);
        }
        return null;
    }

    public void start200(Channel ctx, boolean isKeepAlive, MediaType contentType) {
        ctx.write(HTTP_200_OK);
        this.addDefaultHeaders(ctx, isKeepAlive, contentType);
    }

    public void startResponse(Channel ctx, int code, boolean isKeepAlive, MediaType contentType) {
        ctx.write(this.responseCodes.get(code));
        this.addDefaultHeaders(ctx, isKeepAlive, contentType);
    }

    private void addDefaultHeaders(Channel ctx, boolean isKeepAlive, MediaType contentType) {
        ctx.write(isKeepAlive ? CONN_KEEP_ALIVE : CONN_CLOSE);
        ctx.write(SERVER_HEADER);
        ctx.write(DATE_IS);
        ctx.write(Dates.getDateTimeBytes());
        ctx.write(CR_LF);
        ctx.write(contentType.asHttpHeader());
    }

    void addCustomHeader(Channel ctx, byte[] name, byte[] value) {
        ctx.write(name);
        ctx.write(HEADER_SEP);
        ctx.write(value);
        ctx.write(CR_LF);
    }

    public void write200(Channel ctx, boolean isKeepAlive, MediaType contentTypeHeader, byte[] content) {
        this.start200(ctx, isKeepAlive, contentTypeHeader);
        this.writeContent(ctx, content);
        this.listener.onOkResponse(contentTypeHeader, content);
    }

    public void error(Channel ctx, boolean isKeepAlive, Req req, Throwable error) {
        if (this.errorHandler != null) {
            this.errorHandler.handle(ctx, isKeepAlive, req, error);
        } else {
            this.defaultErrorHandling(ctx, isKeepAlive, error);
        }
    }

    private void defaultErrorHandling(Channel ctx, boolean isKeepAlive, Throwable error) {
        Log.error((String)"Error while processing request!", (Throwable)error);
        this.startResponse(ctx, 500, isKeepAlive, MediaType.HTML_UTF_8);
        this.writeContent(ctx, HttpUtils.getErrorMessage(error).getBytes());
        this.done(ctx, isKeepAlive);
    }

    private void writeContent(Channel ctx, byte[] content) {
        int len = content.length;
        if (len < 5000) {
            ctx.write(CONTENT_LENGTHS[len]);
        } else {
            ctx.write(CONTENT_LENGTH_IS);
            Buf out = ctx.output();
            out.putNumAsText(out.size(), (long)len, true);
            ctx.write(CR_LF);
        }
        ctx.write(CR_LF);
        ctx.write(content);
    }

    public void writeSerializedJson(Channel ctx, boolean isKeepAlive, Object value) {
        this.start200(ctx, isKeepAlive, MediaType.JSON_UTF_8);
        Buf out = ctx.output();
        ctx.write(CONTENT_LENGTH_UNKNOWN);
        int posConLen = out.size();
        ctx.write(CR_LF);
        ctx.write(CR_LF);
        int posBefore = out.size();
        JSON.stringify((Object)value, (OutputStream)out.asOutputStream());
        int posAfter = out.size();
        int contentLength = posAfter - posBefore;
        out.putNumAsText(posConLen, (long)contentLength, false);
    }

    public void done(Channel ctx, boolean isKeepAlive) {
        ctx.done();
        ctx.closeIf(!isKeepAlive);
    }

    public FastHttpListener getListener() {
        return this.listener;
    }

    public synchronized void resetConfig() {
        this.path3 = null;
        this.path2 = null;
        this.path1 = null;
        this.handler3 = null;
        this.handler2 = null;
        this.handler1 = null;
        this.staticFilesLocations = DEFAULT_STATIC_FILES_LOCATIONS;
        this.staticResourcesHandler = new FastStaticResourcesHandler(this);
        this.errorHandler = null;
        this.renderer = null;
        this.getHandlers.clear();
        this.postHandlers.clear();
        this.putHandlers.clear();
        this.deleteHandlers.clear();
        this.optionsHandlers.clear();
        this.genericHandlers.clear();
    }

    public void renderBody(Channel ctx, int code, MediaType contentType, byte[] body) {
        ctx.write(body);
        if (code == 200) {
            this.listener.onOkResponse(contentType, body);
        } else {
            this.listener.onErrorResponse(code, contentType, body);
        }
    }

    public void notFound(Channel ctx, boolean isKeepAlive, FastHttpHandler fromHandler, Req req) {
        int count = this.genericHandlers.size();
        HttpStatus status = HttpStatus.NOT_FOUND;
        for (int i = 0; i < count; ++i) {
            FastHttpHandler handler = this.genericHandlers.get(i);
            if (handler != fromHandler || i >= count - 1) continue;
            FastHttpHandler nextHandler = this.genericHandlers.get(i + 1);
            status = nextHandler.handle(ctx, isKeepAlive, req, null);
            break;
        }
        if (status == HttpStatus.NOT_FOUND) {
            ctx.write(HTTP_404_NOT_FOUND);
            this.done(ctx, isKeepAlive);
        }
    }

    private static void removeTrailingSlash(Buf buf, Range range) {
        if (range.length > 1 && buf.get(range.last()) == 47) {
            --range.length;
        }
    }

    private static String validateRequest(Buf input, Range verb, Range uri) {
        if (verb.isEmpty()) {
            return "HTTP verb cannot be empty!";
        }
        if (!BytesUtil.isValidURI((Bytes)input.bytes(), (Range)uri)) {
            return "Invalid HTTP URI!";
        }
        return null;
    }

    public void setStaticResourcesHandler(FastHttpHandler staticResourcesHandler) {
        this.staticResourcesHandler = staticResourcesHandler;
    }

    public FastHttpHandler getStaticResourcesHandler() {
        return this.staticResourcesHandler;
    }

    public Map<String, Object> attributes() {
        return this.attributes;
    }

    public Map<String, Serializable> session(String sessionId) {
        return this.sessions.get(sessionId);
    }

    public void setErrorHandler(FastHttpHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public FastHttpHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setStaticFilesLocations(String ... staticFilesLocations) {
        this.staticFilesLocations = staticFilesLocations;
    }

    public String[] getStaticFilesLocations() {
        return this.staticFilesLocations;
    }

    public void setRenderer(ViewRenderer renderer) {
        this.renderer = renderer;
    }

    public ViewRenderer getRenderer() {
        return this.renderer;
    }

    static {
        for (int len = 0; len < CONTENT_LENGTHS.length; ++len) {
            FastHttp.CONTENT_LENGTHS[len] = (new String(CONTENT_LENGTH_IS) + len + new String(CR_LF)).getBytes();
        }
    }
}

