/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast;

import java.util.Map;
import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.data.JSON;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.Range;
import org.rapidoid.data.Ranges;
import org.rapidoid.http.fast.HttpContentType;
import org.rapidoid.log.Log;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.wrap.BoolWrap;
import org.rapidoid.wrap.IntWrap;

public class HttpParser
implements Constants {
    private static final byte[] CONNECTION = "Connection:".getBytes();
    private static final byte[] KEEP_ALIVE = "keep-alive".getBytes();
    private static final byte[] CONTENT_LENGTH = "Content-Length:".getBytes();
    private static final byte[] COOKIE = "Cookie".getBytes();
    private static final byte[] CT_MULTIPART_FORM_DATA_BOUNDARY1 = "multipart/form-data; boundary=".getBytes();
    private static final byte[] CT_MULTIPART_FORM_DATA_BOUNDARY2 = "multipart/form-data;boundary=".getBytes();
    private static final byte[] CT_MULTIPART_FORM_DATA = "multipart/form-data".getBytes();
    private static final byte[] CT_FORM_URLENCODED = "application/x-www-form-urlencoded".getBytes();
    private static final byte[] CT_JSON = "application/json".getBytes();
    private static final byte[] CONTENT_TYPE = "Content-Type".getBytes();
    private static final byte[] CONTENT_DISPOSITION = "Content-Disposition".getBytes();
    private static final byte[] FORM_DATA = "form-data;".getBytes();
    private static final byte[] NAME_EQ = "name=".getBytes();
    private static final byte[] FILENAME_EQ = "filename=".getBytes();
    private static final byte[] CHARSET_EQ = "charset=".getBytes();
    private static final byte[] _UTF_8 = "UTF-8".getBytes();
    private static final byte[] _ISO_8859_1 = "ISO-8859-1".getBytes();
    private static final byte[] CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding".getBytes();
    private static final byte[] _7BIT = "7bit".getBytes();
    private static final byte[] _8BIT = "8bit".getBytes();
    private static final byte[] BINARY = "binary".getBytes();
    private static final byte[] GET = "GET".getBytes();

    public void parse(Buf buf, BoolWrap isGet, BoolWrap isKeepAlive, Range body, Range verb, Range uri, Range path, Range query, Range protocol, Ranges headers, RapidoidHelper helper) {
        Bytes bytes = buf.bytes();
        buf.scanUntil((byte)32, verb);
        buf.scanUntil((byte)32, uri);
        buf.scanLn(protocol);
        IntWrap result = helper.integers[0];
        buf.scanLnLn(headers.reset(), result, (byte)115, (byte)101);
        int possibleClosePos = result.value;
        isKeepAlive.value = possibleClosePos < 0 ? false : this.isKeepAlive(bytes, headers, helper);
        BytesUtil.split((Bytes)bytes, (Range)uri, (byte)63, (Range)path, (Range)query, (boolean)false);
        isGet.value = BytesUtil.matches((Bytes)bytes, (Range)verb, (byte[])GET, (boolean)true);
        if (!isGet.value) {
            this.parseBody(buf, body, headers, helper);
        }
    }

    private boolean isKeepAlive(Bytes bytes, Ranges headers, RapidoidHelper helper) {
        Range connHdr = headers.getByPrefix(bytes, CONNECTION, false);
        return connHdr != null ? this.getKeepAliveValue(bytes, connHdr, helper) : true;
    }

    private boolean getKeepAliveValue(Bytes bytes, Range connHdr, RapidoidHelper helper) {
        assert (bytes != null);
        assert (connHdr != null);
        Range connVal = helper.ranges5.ranges[3];
        connVal.setInterval(connHdr.start + CONNECTION.length, connHdr.limit());
        BytesUtil.trim((Bytes)bytes, (Range)connVal);
        return BytesUtil.matches((Bytes)bytes, (Range)connVal, (byte[])KEEP_ALIVE, (boolean)false);
    }

    private void parseBody(Buf buf, Range body, Ranges headers, RapidoidHelper helper) {
        Range clen = headers.getByPrefix(buf.bytes(), CONTENT_LENGTH, false);
        if (clen != null) {
            Range clenValue = helper.ranges5.ranges[helper.ranges5.ranges.length - 1];
            clenValue.setInterval(clen.start + CONTENT_LENGTH.length, clen.limit());
            BytesUtil.trim((Bytes)buf.bytes(), (Range)clenValue);
            long len = buf.getN(clenValue);
            U.must((len >= 0L && len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Invalid body size!");
            buf.scanN((int)len, body);
            Log.debug((String)"Request body complete", (String)"range", (Object)body);
        } else {
            body.reset();
        }
    }

    public void parseParams(Buf buf, KeyValueRanges params, Range range) {
        this.parseURLEncodedKV(buf, params, range);
    }

    private void parseURLEncodedKV(Buf buf, KeyValueRanges params, Range body) {
        int pos = buf.position();
        int limit = buf.limit();
        buf.position(body.start);
        buf.limit(body.limit());
        while (buf.hasRemaining()) {
            int ind = params.add();
            int which = buf.scanTo((byte)61, (byte)38, params.keys[ind], false);
            if (which != 1) continue;
            buf.scanTo((byte)38, params.values[ind], false);
        }
        buf.position(pos);
        buf.limit(limit);
    }

    public int parseHeaders(Buf buf, int from, int to, KeyValueRanges headersKV, RapidoidHelper helper) {
        int pos = buf.position();
        int limit = buf.limit();
        buf.position(from);
        buf.limit(to);
        Ranges headers = helper.ranges2.reset();
        buf.scanLnLn(headers);
        this.parseHeadersIntoKV(buf, headers, headersKV, null, helper);
        int bodyPos = buf.position();
        buf.position(pos);
        buf.limit(limit);
        return bodyPos;
    }

    public void parseHeadersIntoKV(Buf buf, Ranges headers, KeyValueRanges headersKV, KeyValueRanges cookies, RapidoidHelper helper) {
        Range cookie = helper.ranges5.ranges[0];
        for (int i = 0; i < headers.count; ++i) {
            Range hdr = headers.ranges[i];
            int ind = headersKV.add();
            Range key = headersKV.keys[ind];
            Range val = headersKV.values[ind];
            assert (!hdr.isEmpty());
            boolean split = BytesUtil.split((Bytes)buf.bytes(), (Range)hdr, (byte)58, (Range)key, (Range)val, (boolean)true);
            U.must((boolean)split, (String)"Invalid HTTP header!");
            if (cookies == null || !BytesUtil.matches((Bytes)buf.bytes(), (Range)key, (byte[])COOKIE, (boolean)false)) continue;
            --headersKV.count;
            do {
                BytesUtil.split((Bytes)buf.bytes(), (Range)val, (byte)59, (Range)cookie, (Range)val, (boolean)true);
                int cind = cookies.add();
                BytesUtil.split((Bytes)buf.bytes(), (Range)cookie, (byte)61, (Range)cookies.keys[cind], (Range)cookies.values[cind], (boolean)true);
            } while (!val.isEmpty());
        }
    }

    public boolean parseBody(Buf src, KeyValueRanges headers, Range body, KeyValueRanges data, KeyValueRanges files, RapidoidHelper helper) {
        if (body.isEmpty()) {
            return true;
        }
        Range multipartBoundary = helper.ranges5.ranges[0];
        HttpContentType contentType = this.getContentType(src, headers, multipartBoundary);
        switch (contentType) {
            case MULTIPART: {
                if (multipartBoundary.isEmpty()) {
                    this.detectMultipartBoundary(src, body, multipartBoundary);
                }
                helper.bytes[0] = 45;
                helper.bytes[1] = 45;
                src.get(multipartBoundary, helper.bytes, 2);
                U.rteIf((boolean)multipartBoundary.isEmpty(), (String)"Invalid multi-part HTTP request!");
                this.parseMultiParts(src, body, data, files, multipartBoundary, helper);
                return true;
            }
            case FORM_URLENCODED: {
                this.parseURLEncodedKV(src, data, body);
                return true;
            }
            case JSON: {
                return false;
            }
            case OTHER: {
                return true;
            }
            case NOT_FOUND: {
                return true;
            }
        }
        throw U.notExpected();
    }

    private void detectMultipartBoundary(Buf src, Range body, Range multipartBoundary) {
        BytesUtil.parseLine((Bytes)src.bytes(), (Range)multipartBoundary, (int)body.start, (int)body.limit());
        multipartBoundary.strip(2, 0);
    }

    private void parseMultiParts(Buf src, Range body, KeyValueRanges data, KeyValueRanges files, Range multipartBoundary, RapidoidHelper helper) {
        int start = body.start;
        int limit = body.limit();
        int sepLen = multipartBoundary.length + 2;
        int pos1 = -1;
        try {
            int pos2;
            while ((pos2 = BytesUtil.find((Bytes)src.bytes(), (int)start, (int)limit, (byte[])helper.bytes, (int)0, (int)sepLen, (boolean)true)) >= 0) {
                if (pos1 >= 0 && pos2 >= 0) {
                    int from = pos1 + sepLen + 2;
                    int to = pos2 - 2;
                    this.parseMultiPart(src, body, data, files, multipartBoundary, helper, from, to);
                }
                pos1 = pos2;
                start = pos2 + sepLen;
            }
        }
        catch (Throwable e) {
            Log.warn((String)"Multipart parse error!", (Throwable)e);
            throw U.rte((String)"Multipart data parse error!", (Throwable)e);
        }
    }

    private void parseMultiPart(Buf src, Range body, KeyValueRanges data, KeyValueRanges files, Range multipartBoundary, RapidoidHelper helper, int from, int to) {
        int ind;
        Range encoding;
        KeyValueRanges headers = helper.pairs.reset();
        Range partBody = helper.ranges4.ranges[0];
        Range contType = helper.ranges4.ranges[1];
        Range contEnc = helper.ranges4.ranges[2];
        Range dispo1 = helper.ranges4.ranges[3];
        Range dispo2 = helper.ranges4.ranges[4];
        Range name = helper.ranges4.ranges[5];
        Range filename = helper.ranges4.ranges[6];
        Range charset = helper.ranges4.ranges[7];
        int bodyPos = this.parseHeaders(src, from, to, headers, helper);
        partBody.setInterval(bodyPos, to);
        Range disposition = headers.get(src, CONTENT_DISPOSITION, false);
        if (!BytesUtil.startsWith((Bytes)src.bytes(), (Range)disposition, (byte[])FORM_DATA, (boolean)false)) {
            return;
        }
        disposition.strip(FORM_DATA.length, 0);
        BytesUtil.split((Bytes)src.bytes(), (Range)disposition, (byte)59, (Range)dispo1, (Range)dispo2, (boolean)true);
        if (!this.parseDisposition(src, dispo1, dispo2, name, filename) && !this.parseDisposition(src, dispo2, dispo1, name, filename)) {
            throw U.rte((String)"Unrecognized Content-disposition header!");
        }
        Range contentType = headers.get(src, CONTENT_TYPE, false);
        charset.reset();
        contType.reset();
        contEnc.reset();
        if (contentType != null) {
            BytesUtil.split((Bytes)src.bytes(), (Range)contentType, (byte)59, (Range)contType, (Range)contEnc, (boolean)true);
            if (BytesUtil.startsWith((Bytes)src.bytes(), (Range)contEnc, (byte[])CHARSET_EQ, (boolean)false)) {
                charset.assign(contEnc);
                charset.strip(CHARSET_EQ.length, 0);
                BytesUtil.trim((Bytes)src.bytes(), (Range)charset);
                if (!BytesUtil.matches((Bytes)src.bytes(), (Range)charset, (byte[])_UTF_8, (boolean)false) && !BytesUtil.matches((Bytes)src.bytes(), (Range)charset, (byte[])_ISO_8859_1, (boolean)false)) {
                    Log.warn((String)"Tipically the UTF-8 and ISO-8859-1 charsets are expected, but received different!", (String)"charset", (Object)src.get(charset));
                }
            }
        }
        if ((encoding = headers.get(src, CONTENT_TRANSFER_ENCODING, false)) != null) {
            boolean validEncoding = BytesUtil.matches((Bytes)src.bytes(), (Range)encoding, (byte[])_7BIT, (boolean)false) || BytesUtil.matches((Bytes)src.bytes(), (Range)encoding, (byte[])_8BIT, (boolean)false) || BytesUtil.matches((Bytes)src.bytes(), (Range)encoding, (byte[])BINARY, (boolean)false);
            U.rteIf((!validEncoding ? 1 : 0) != 0, (String)"Invalid Content-transfer-encoding header value!");
        }
        if (filename.isEmpty()) {
            ind = data.add();
            data.keys[ind].assign(name);
            data.values[ind].assign(partBody);
        } else {
            ind = files.add();
            files.keys[ind].assign(name);
            files.values[ind].assign(partBody);
        }
    }

    private boolean parseDisposition(Buf src, Range dispoA, Range dispoB, Range name, Range filename) {
        if (BytesUtil.startsWith((Bytes)src.bytes(), (Range)dispoA, (byte[])NAME_EQ, (boolean)false)) {
            name.assign(dispoA);
            name.strip(NAME_EQ.length, 0);
            BytesUtil.trim((Bytes)src.bytes(), (Range)name);
            name.strip(1, 1);
            if (BytesUtil.startsWith((Bytes)src.bytes(), (Range)dispoB, (byte[])FILENAME_EQ, (boolean)false)) {
                filename.assign(dispoB);
                filename.strip(FILENAME_EQ.length, 0);
                BytesUtil.trim((Bytes)src.bytes(), (Range)filename);
                filename.strip(1, 1);
            } else {
                filename.reset();
            }
            return true;
        }
        return false;
    }

    private HttpContentType getContentType(Buf buf, KeyValueRanges headers, Range multipartBoundary) {
        Range contType = headers.get(buf, CONTENT_TYPE, false);
        if (contType != null) {
            if (BytesUtil.startsWith((Bytes)buf.bytes(), (Range)contType, (byte[])CT_FORM_URLENCODED, (boolean)false)) {
                multipartBoundary.reset();
                return HttpContentType.FORM_URLENCODED;
            }
            if (BytesUtil.startsWith((Bytes)buf.bytes(), (Range)contType, (byte[])CT_JSON, (boolean)false)) {
                multipartBoundary.reset();
                return HttpContentType.JSON;
            }
            if (BytesUtil.startsWith((Bytes)buf.bytes(), (Range)contType, (byte[])CT_MULTIPART_FORM_DATA_BOUNDARY1, (boolean)false)) {
                multipartBoundary.setInterval(contType.start + CT_MULTIPART_FORM_DATA_BOUNDARY1.length, contType.limit());
                return HttpContentType.MULTIPART;
            }
            if (BytesUtil.startsWith((Bytes)buf.bytes(), (Range)contType, (byte[])CT_MULTIPART_FORM_DATA_BOUNDARY2, (boolean)false)) {
                multipartBoundary.setInterval(contType.start + CT_MULTIPART_FORM_DATA_BOUNDARY2.length, contType.limit());
                return HttpContentType.MULTIPART;
            }
            if (BytesUtil.startsWith((Bytes)buf.bytes(), (Range)contType, (byte[])CT_MULTIPART_FORM_DATA, (boolean)false)) {
                multipartBoundary.reset();
                return HttpContentType.MULTIPART;
            }
        }
        multipartBoundary.reset();
        return contType != null ? HttpContentType.OTHER : HttpContentType.NOT_FOUND;
    }

    public void parsePosted(Buf input, KeyValueRanges headersKV, Range rBody, KeyValueRanges posted, KeyValueRanges files, RapidoidHelper helper, Map<String, Object> dest) {
        Map jsonData;
        boolean completed = this.parseBody(input, headersKV, rBody, posted, files, helper);
        Map urlEncodedParamsDest = (Map)U.cast(dest);
        posted.toMap(input, true, true, urlEncodedParamsDest);
        if (!completed && !rBody.isEmpty() && (jsonData = (Map)JSON.parse((String)input.get(rBody), Map.class)) != null) {
            dest.putAll(jsonData);
        }
    }
}

